/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;

public class StatsJoinKeyCountMatcher
implements Matcher {
    private final double expectedJoinBuildKeyCount;
    private final double expectedNullJoinBuildKeyCount;
    private final double expectedJoinProbeKeyCount;
    private final double expectedNullJoinProbeKeyCount;

    StatsJoinKeyCountMatcher(double expectedJoinBuildKeyCount, double expectedNullJoinBuildKeyCount, double expectedJoinProbeKeyCount, double expectedNullJoinProbeKeyCount) {
        this.expectedJoinBuildKeyCount = expectedJoinBuildKeyCount;
        this.expectedNullJoinBuildKeyCount = expectedNullJoinBuildKeyCount;
        this.expectedJoinProbeKeyCount = expectedJoinProbeKeyCount;
        this.expectedNullJoinProbeKeyCount = expectedNullJoinProbeKeyCount;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        return new MatchResult(Double.compare(stats.getStats(node).getJoinNodeStatsEstimate().getJoinBuildKeyCount(), this.expectedJoinBuildKeyCount) == 0 && Double.compare(stats.getStats(node).getJoinNodeStatsEstimate().getNullJoinBuildKeyCount(), this.expectedNullJoinBuildKeyCount) == 0 && Double.compare(stats.getStats(node).getJoinNodeStatsEstimate().getJoinProbeKeyCount(), this.expectedJoinProbeKeyCount) == 0 && Double.compare(stats.getStats(node).getJoinNodeStatsEstimate().getNullJoinProbeKeyCount(), this.expectedNullJoinProbeKeyCount) == 0);
    }

    public String toString() {
        return "expectedJoinBuildKeyCount(" + this.expectedJoinBuildKeyCount + ") expectedNullJoinBuildKeyCount(" + this.expectedNullJoinBuildKeyCount + ") expectedNullJoinProbeKeyCount(" + this.expectedNullJoinProbeKeyCount + ") expectedNullJoinProbeKeyCount(" + this.expectedNullJoinProbeKeyCount + ")";
    }
}

