/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.TaskCountEstimator;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.TestingColumnHandle;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinDistributionType;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.DetermineJoinDistributionType;
import com.facebook.presto.sql.planner.iterative.rule.JoinSwappingUtils;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDetermineJoinDistributionType {
    private static final CostComparator COST_COMPARATOR = new CostComparator(1.0, 1.0, 1.0);
    private static final int NODES_COUNT = 4;
    private RuleTester tester;

    @BeforeClass
    public void setUp() {
        this.tester = new RuleTester((List<Plugin>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of(), Optional.of(4));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.tester.close();
        this.tester = null;
    }

    @Test
    public void testDetermineDistributionType() {
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.PARTITIONED, JoinType.INNER, JoinDistributionType.PARTITIONED);
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.BROADCAST, JoinType.INNER, JoinDistributionType.REPLICATED);
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.AUTOMATIC, JoinType.INNER, JoinDistributionType.PARTITIONED);
    }

    @Test
    public void testDetermineDistributionTypeForLeftOuter() {
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.PARTITIONED, JoinType.LEFT, JoinDistributionType.PARTITIONED);
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.BROADCAST, JoinType.LEFT, JoinDistributionType.REPLICATED);
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.AUTOMATIC, JoinType.LEFT, JoinDistributionType.PARTITIONED);
    }

    private void testDetermineDistributionType(FeaturesConfig.JoinDistributionType sessionDistributedJoin, JoinType joinType, JoinDistributionType expectedDistribution) {
        this.assertDetermineJoinDistributionType().on(p -> p.join(joinType, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 11L))), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 50L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 11L))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", sessionDistributedJoin.name()).matches(PlanMatchPattern.join(joinType, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(expectedDistribution), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testRepartitionRightOuter() {
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.PARTITIONED, JoinType.FULL);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.PARTITIONED, JoinType.RIGHT);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.BROADCAST, JoinType.FULL);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.BROADCAST, JoinType.RIGHT);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.AUTOMATIC, JoinType.FULL);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.AUTOMATIC, JoinType.RIGHT);
    }

    private void testRepartitionRightOuter(FeaturesConfig.JoinDistributionType sessionDistributedJoin, JoinType joinType) {
        this.assertDetermineJoinDistributionType().on(p -> p.join(joinType, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 11L))), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 50L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 11L))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", sessionDistributedJoin.name()).matches(PlanMatchPattern.join(joinType, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicateScalar() {
        this.assertDetermineJoinDistributionType().on(p -> p.join(JoinType.INNER, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 11L))), (PlanNode)p.enforceSingleRow((PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 50L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 11L)))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.enforceSingleRow(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testReplicateNoEquiCriteria() {
        this.testReplicateNoEquiCriteria(JoinType.INNER);
        this.testReplicateNoEquiCriteria(JoinType.LEFT);
    }

    private void testReplicateNoEquiCriteria(JoinType joinType) {
        this.assertDetermineJoinDistributionType().on(p -> p.join(joinType, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 11L))), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 50L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 11L))), (List<EquiJoinClause>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.of(p.rowExpression("A1 * B1 > 100")))).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).matches(PlanMatchPattern.join(joinType, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), Optional.of("A1 * B1 > 100"), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testRetainDistributionType() {
        this.assertDetermineJoinDistributionType().on(p -> p.join(JoinType.INNER, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 11L))), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 50L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 11L))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), (Map<String, VariableReferenceExpression>)ImmutableMap.of())).doesNotFire();
    }

    @Test
    public void testFlipAndReplicateWhenOneTableMuchSmaller() {
        int aRows = 100;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testFlipAndReplicateWhenOneTableMuchSmallerAndJoinCardinalityUnknown() {
        int aRows = 100;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)VariableStatsEstimate.unknown())).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)VariableStatsEstimate.unknown())).build()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testPartitionWhenRequiredBySession() {
        int aRows = 100;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testPartitionWhenBothTablesEqual() {
        int aRows = 10000;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatesWhenRequiredBySession() {
        int aRows = 10000;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testPartitionFullOuterJoin() {
        int aRows = 10000;
        int bRows = 10;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.FULL, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.FULL, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testPartitionRightOuterJoin() {
        int aRows = 10000;
        int bRows = 10;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.RIGHT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicateLeftOuterJoin() {
        int aRows = 10000;
        int bRows = 10;
        this.assertDetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0)).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testFlipAndReplicateRightOuterJoin() {
        int aRows = 10;
        int bRows = 1000000;
        this.assertDetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0)).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testFlipAndReplicateRightOuterJoinWhenJoinCardinalityUnknown() {
        int aRows = 10;
        int bRows = 1000000;
        this.assertDetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0)).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)VariableStatsEstimate.unknown())).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)VariableStatsEstimate.unknown())).build()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatesWhenNotRestricted() {
        int aRows = 10000;
        int bRows = 10;
        PlanNodeStatsEstimate probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        PlanNodeStatsEstimate buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testChoosesLeftWhenCriteriaEmpty() {
        int aRows = 100000;
        int bRows = 10;
        this.assertDetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0)).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "1PB").overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testChoosesRightWhenFallsBackToSyntactic() {
        int aRows = 100000;
        int bRows = 10;
        this.assertDetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0)).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.RIGHT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testReplicatesWhenSourceIsSmall() {
        VarcharType variableType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 10;
        PlanNodeStatsEstimate aStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)variableType), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        PlanNodeStatsEstimate bStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)variableType), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        PlanNodeStatsEstimate bSourceStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)variableType), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 64.0, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", aStatsEstimate).overrideStats("filterB", bStatsEstimate).overrideStats("valuesB", bSourceStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.filter(new PlanNodeId("filterB"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.filter("true", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", aStatsEstimate).overrideStats("filterB", bStatsEstimate).overrideStats("valuesB", bSourceStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.INNER, (PlanNode)p.filter(new PlanNodeId("filterB"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1)), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(b1, a1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.filter("true", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bSourceStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.LEFT, (PlanNode)p.filter(new PlanNodeId("filterB"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1)), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(b1, a1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.RIGHT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.filter("true", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testReplicatesWhenOneSourceIsSmallAndTheOtherUnknown() {
        VarcharType variableType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 10;
        PlanNodeStatsEstimate bStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)variableType), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 64.0, 10.0))).build();
        PlanNodeStatsEstimate bLargeStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)variableType), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(b1, a1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bLargeStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(b1, a1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bLargeStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.LEFT, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(b1, a1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.RIGHT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.LEFT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bLargeStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.LEFT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(b1, a1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bLargeStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(b1, a1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.RIGHT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.RIGHT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.FULL, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(b1, a1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.FULL, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("use_broadcast_when_buildsize_small_probeside_unknown", "true").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.FULL, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.FULL, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testFlipWhenSizeDifferenceLarge() {
        VarcharType variableType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 1000;
        PlanNodeStatsEstimate aStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)variableType), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        PlanNodeStatsEstimate bStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)variableType), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", aStatsEstimate).overrideStats("valuesB", bStatsEstimate).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.filter(new PlanNodeId("filterB"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.filter("true", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", aStatsEstimate).overrideStats("valuesB", bStatsEstimate).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.INNER, (PlanNode)p.filter(new PlanNodeId("filterB"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1)), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(b1, a1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.filter("true", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", aStatsEstimate).overrideStats("valuesB", bStatsEstimate).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.INNER, (PlanNode)p.filter(new PlanNodeId("filterB"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1)), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<EquiJoinClause>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.filter("true", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
        bStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)variableType), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", aStatsEstimate).overrideStats("valuesB", bStatsEstimate).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinType.INNER, (PlanNode)p.filter(new PlanNodeId("filterB"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (PlanNode)p.values(new PlanNodeId("valuesB"), aRows, b1)), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(b1, a1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.filter("true", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testGetSourceTablesSizeInBytes() {
        PlanBuilder planBuilder = new PlanBuilder(this.tester.getSession(), new PlanNodeIdAllocator(), this.tester.getMetadata());
        VariableReferenceExpression variable = planBuilder.variable("col");
        VariableReferenceExpression sourceVariable1 = planBuilder.variable("source1");
        VariableReferenceExpression sourceVariable2 = planBuilder.variable("soruce2");
        Assert.assertEquals((double)DetermineJoinDistributionType.getSourceTablesSizeInBytes((PlanNode)planBuilder.values(variable), (Lookup)Lookup.noLookup(), node -> PlanNodeStatsEstimate.unknown()), (double)Double.NaN);
        PlanNodeStatsEstimate sourceStatsEstimate1 = PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).build();
        PlanNodeStatsEstimate sourceStatsEstimate2 = PlanNodeStatsEstimate.builder().setOutputRowCount(20.0).build();
        Assert.assertEquals((double)DetermineJoinDistributionType.getSourceTablesSizeInBytes((PlanNode)planBuilder.union((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().put((Object)variable, (Object)sourceVariable1).put((Object)variable, (Object)sourceVariable2).build(), (List<PlanNode>)ImmutableList.of((Object)planBuilder.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)sourceVariable1), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)sourceVariable1, (Object)new TestingColumnHandle("col"))), (Object)planBuilder.values(new PlanNodeId("valuesNode"), sourceVariable2))), (Lookup)Lookup.noLookup(), node -> {
            if (node instanceof TableScanNode) {
                return sourceStatsEstimate1;
            }
            if (node instanceof ValuesNode) {
                return sourceStatsEstimate2;
            }
            return PlanNodeStatsEstimate.unknown();
        }), (double)270.0);
        Assert.assertEquals((double)DetermineJoinDistributionType.getSourceTablesSizeInBytes((PlanNode)planBuilder.join(JoinType.INNER, (PlanNode)planBuilder.values(sourceVariable1), (PlanNode)planBuilder.values(sourceVariable2), new EquiJoinClause[0]), (Lookup)Lookup.noLookup(), node -> sourceStatsEstimate1), (double)Double.NaN);
        Assert.assertEquals((double)DetermineJoinDistributionType.getSourceTablesSizeInBytes((PlanNode)planBuilder.unnest((PlanNode)planBuilder.values(sourceVariable1), (List<VariableReferenceExpression>)ImmutableList.of(), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)ImmutableMap.of((Object)sourceVariable1, (Object)ImmutableList.of((Object)sourceVariable1)), Optional.empty()), (Lookup)Lookup.noLookup(), node -> sourceStatsEstimate1), (double)Double.NaN);
    }

    @Test
    public void testGetApproximateSourceSizeInBytes() {
        PlanBuilder planBuilder = new PlanBuilder(this.tester.getSession(), new PlanNodeIdAllocator(), this.tester.getMetadata());
        VariableReferenceExpression variable = planBuilder.variable("col");
        VariableReferenceExpression sourceVariable1 = planBuilder.variable("source1");
        VariableReferenceExpression sourceVariable2 = planBuilder.variable("source2");
        Assert.assertEquals((double)JoinSwappingUtils.getFirstKnownOutputSizeInBytes((PlanNode)planBuilder.values(variable), (Lookup)Lookup.noLookup(), node -> PlanNodeStatsEstimate.unknown()), (double)Double.NaN);
        PlanNodeStatsEstimate sourceStatsEstimate1 = PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).build();
        PlanNodeStatsEstimate sourceStatsEstimate2 = PlanNodeStatsEstimate.builder().setOutputRowCount(2000.0).build();
        PlanNodeStatsEstimate filterStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount(250.0).build();
        PlanNodeStatsEstimate limitStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount(20.0).build();
        double sourceRowCount = sourceStatsEstimate1.getOutputRowCount() + sourceStatsEstimate2.getOutputRowCount();
        double unionInputRowCount = filterStatsEstimate.getOutputRowCount() + limitStatsEstimate.getOutputRowCount();
        double sourceSizeInBytes = sourceRowCount + sourceRowCount * (double)BigintType.BIGINT.getFixedSize();
        Assert.assertEquals((double)JoinSwappingUtils.getFirstKnownOutputSizeInBytes((PlanNode)planBuilder.union((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().put((Object)variable, (Object)sourceVariable1).put((Object)variable, (Object)sourceVariable2).build(), (List<PlanNode>)ImmutableList.of((Object)planBuilder.filter((RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (PlanNode)planBuilder.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)sourceVariable1), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)sourceVariable1, (Object)new TestingColumnHandle("col")))), (Object)planBuilder.limit(20L, (PlanNode)planBuilder.values(sourceVariable2)))), (Lookup)Lookup.noLookup(), node -> {
            if (node instanceof TableScanNode) {
                return sourceStatsEstimate1;
            }
            if (node instanceof FilterNode) {
                return filterStatsEstimate;
            }
            if (node instanceof ValuesNode) {
                return sourceStatsEstimate2;
            }
            if (node instanceof LimitNode) {
                return limitStatsEstimate;
            }
            return PlanNodeStatsEstimate.unknown();
        }), (double)(unionInputRowCount / sourceRowCount * sourceSizeInBytes));
        Assert.assertEquals((double)JoinSwappingUtils.getFirstKnownOutputSizeInBytes((PlanNode)planBuilder.join(JoinType.INNER, (PlanNode)planBuilder.values(sourceVariable1), (PlanNode)planBuilder.values(sourceVariable2), new EquiJoinClause[0]), (Lookup)Lookup.noLookup(), node -> sourceStatsEstimate1), (double)(sourceStatsEstimate1.getOutputRowCount() * 2.0 * (double)(BigintType.BIGINT.getFixedSize() + 1)));
        Assert.assertEquals((double)JoinSwappingUtils.getFirstKnownOutputSizeInBytes((PlanNode)planBuilder.join(JoinType.INNER, (PlanNode)planBuilder.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)sourceVariable1), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)sourceVariable1, (Object)new TestingColumnHandle("col"))), (PlanNode)planBuilder.values(sourceVariable2), new EquiJoinClause[0]), (Lookup)Lookup.noLookup(), node -> {
            if (node instanceof TableScanNode) {
                return sourceStatsEstimate1;
            }
            if (node instanceof ValuesNode) {
                return sourceStatsEstimate2;
            }
            return PlanNodeStatsEstimate.unknown();
        }), (double)Double.NaN);
        Assert.assertEquals((double)JoinSwappingUtils.getFirstKnownOutputSizeInBytes((PlanNode)planBuilder.union((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().put((Object)variable, (Object)sourceVariable1).put((Object)variable, (Object)sourceVariable2).build(), (List<PlanNode>)ImmutableList.of((Object)planBuilder.unnest((PlanNode)planBuilder.values(sourceVariable1), (List<VariableReferenceExpression>)ImmutableList.of(), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)ImmutableMap.of((Object)sourceVariable1, (Object)ImmutableList.of((Object)sourceVariable1)), Optional.empty()), (Object)planBuilder.values(sourceVariable2))), (Lookup)Lookup.noLookup(), node -> {
            if (node instanceof UnnestNode) {
                return sourceStatsEstimate1;
            }
            if (node instanceof ValuesNode) {
                return sourceStatsEstimate2;
            }
            return PlanNodeStatsEstimate.unknown();
        }), (double)sourceSizeInBytes);
        Assert.assertEquals((double)JoinSwappingUtils.getFirstKnownOutputSizeInBytes((PlanNode)planBuilder.union((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().put((Object)variable, (Object)sourceVariable1).put((Object)variable, (Object)sourceVariable2).build(), (List<PlanNode>)ImmutableList.of((Object)planBuilder.unnest((PlanNode)planBuilder.values(sourceVariable1), (List<VariableReferenceExpression>)ImmutableList.of(), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)ImmutableMap.of((Object)sourceVariable1, (Object)ImmutableList.of((Object)sourceVariable1)), Optional.empty()), (Object)planBuilder.values(sourceVariable2))), (Lookup)Lookup.noLookup(), node -> {
            if (node instanceof ValuesNode) {
                return sourceStatsEstimate2;
            }
            return PlanNodeStatsEstimate.unknown();
        }), (double)Double.NaN);
    }

    private RuleAssert assertDetermineJoinDistributionType() {
        return this.assertDetermineJoinDistributionType(COST_COMPARATOR);
    }

    private RuleAssert assertDetermineJoinDistributionType(CostComparator costComparator) {
        return this.tester.assertThat((Rule)new DetermineJoinDistributionType(costComparator, new TaskCountEstimator(() -> 4)));
    }
}

