/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneCountAggregationOverScalar;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPruneCountAggregationOverScalar
extends BaseRuleTest {
    public TestPruneCountAggregationOverScalar() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNonNestedAggregate() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar(this.getFunctionManager())).on(p -> p.aggregation(a -> a.globalGrouping().addAggregation(p.variable("count_1", (Type)BigintType.BIGINT), p.rowExpression("count()")).source((PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of(), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of())))).doesNotFire();
    }

    @Test
    public void testFiresOnNestedCountAggregate() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar(this.getFunctionManager())).on(p -> p.aggregation(a -> a.addAggregation(p.variable("count_1", (Type)BigintType.BIGINT), p.rowExpression("count()")).globalGrouping().step(AggregationNode.Step.SINGLE).source((PlanNode)p.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of(), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of())).globalGrouping().step(AggregationNode.Step.SINGLE))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"count_1", (Object)0)));
    }

    @Test
    public void testFiresOnCountAggregateOverValues() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar(this.getFunctionManager())).on(p -> p.aggregation(a -> a.addAggregation(p.variable("count_1", (Type)BigintType.BIGINT), p.rowExpression("count()")).step(AggregationNode.Step.SINGLE).globalGrouping().source((PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("orderkey")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 1L)))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"count_1", (Object)0)));
    }

    @Test
    public void testFiresOnCountAggregateOverEnforceSingleRow() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar(this.getFunctionManager())).on(p -> p.aggregation(a -> a.addAggregation(p.variable("count_1", (Type)BigintType.BIGINT), p.rowExpression("count()")).step(AggregationNode.Step.SINGLE).globalGrouping().source((PlanNode)p.enforceSingleRow((PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of(), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of()))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"count_1", (Object)0)));
    }

    @Test
    public void testDoesNotFireOnNestedCountAggregateWithNonEmptyGroupBy() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar(this.getFunctionManager())).on(p -> p.aggregation(a -> a.addAggregation(p.variable("count_1", (Type)BigintType.BIGINT), p.rowExpression("count()")).step(AggregationNode.Step.SINGLE).globalGrouping().source((PlanNode)p.aggregation(aggregationBuilder -> {
            aggregationBuilder.source((PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of(), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of())).groupingSets(AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)p.variable("orderkey"))));
            aggregationBuilder.source((PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of(), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of()));
        })))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnNestedNonCountAggregate() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar(this.getFunctionManager())).on(p -> {
            p.registerVariable(p.variable("totalprice", (Type)DoubleType.DOUBLE));
            VariableReferenceExpression totalPriceVariable = p.variable("total_price", (Type)DoubleType.DOUBLE);
            AggregationNode inner = p.aggregation(a -> a.addAggregation(totalPriceVariable, p.rowExpression("sum(totalprice)")).globalGrouping().source((PlanNode)p.project(PlanBuilder.assignment(totalPriceVariable, (RowExpression)totalPriceVariable), (PlanNode)p.tableScan(new TableHandle(new ConnectorId("local"), (ConnectorTableHandle)new TpchTableHandle("orders", 0.01), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty()), (List<VariableReferenceExpression>)ImmutableList.of((Object)totalPriceVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)totalPriceVariable, (Object)new TpchColumnHandle(totalPriceVariable.getName(), (Type)DoubleType.DOUBLE))))));
            return p.aggregation(a -> a.addAggregation(p.variable("sum_outer", (Type)DoubleType.DOUBLE), p.registerVariable(p.variable("sum_inner", (Type)DoubleType.DOUBLE)).rowExpression("sum(sum_inner)")).globalGrouping().source((PlanNode)inner));
        }).doesNotFire();
    }
}

