/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PushDownFilterExpressionEvaluationThroughCrossJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPushDownFilterExpressionEvaluationThroughCrossJoin
extends BaseRuleTest {
    public TestPushDownFilterExpressionEvaluationThroughCrossJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testTriggerWithAddition() {
        this.tester().assertThat((Rule)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("left_k1+left_k2 = right_k1+right_k2"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2")), new EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter("add_1 = add_0", PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"add_1", (Object)PlanMatchPattern.expression("left_k1+left_k2")), PlanMatchPattern.values("left_k1", "left_k2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"add_0", (Object)PlanMatchPattern.expression("right_k1+right_k2")), PlanMatchPattern.values("right_k1", "right_k2"))))));
    }

    @Test
    public void testNotTriggerWithAddition() {
        this.tester().assertThat((Rule)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("left_k1+right_k1 = left_k2+right_k2"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2")), new EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testTriggerWithArrayCardinality() {
        this.tester().assertThat((Rule)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.filter(p.rowExpression("left_k1 = cardinality(right_k1)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("left_k1")), (PlanNode)p.values(p.variable("right_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), new EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter("left_k1 = card", PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.values("left_k1"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"card", (Object)PlanMatchPattern.expression("cardinality(right_k1)")), PlanMatchPattern.values("right_k1"))))));
    }

    @Test
    public void testCast() {
        this.tester().assertThat((Rule)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)VarcharType.VARCHAR);
            p.variable("left_k2", (Type)VarcharType.VARCHAR);
            p.variable("right_k1", (Type)VarcharType.VARCHAR);
            p.variable("right_k2", (Type)VarcharType.VARCHAR);
            return p.filter(p.rowExpression("left_k1 = right_k1 or CAST(left_k2 AS BIGINT) = CAST(right_k2 AS BIGINT)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("left_k1", (Type)VarcharType.VARCHAR), p.variable("left_k2", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("right_k1", (Type)VarcharType.VARCHAR), p.variable("right_k2", (Type)VarcharType.VARCHAR)), new EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter("left_k1 = right_k1 OR cast_1 = cast_0", PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast_1", (Object)PlanMatchPattern.expression("CAST(left_k2 AS bigint)")), PlanMatchPattern.values("left_k1", "left_k2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast_0", (Object)PlanMatchPattern.expression("CAST(right_k2 AS bigint)")), PlanMatchPattern.values("right_k1", "right_k2"))))));
    }

    @Test
    public void testCoalesce() {
        this.tester().assertThat((Rule)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)VarcharType.VARCHAR);
            p.variable("right_k3", (Type)VarcharType.VARCHAR);
            return p.filter(p.rowExpression("left_k1 = right_k1 or CAST(left_k1 AS VARCHAR) = COALESCE(right_k2, right_k3)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("left_k1")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2", (Type)VarcharType.VARCHAR), p.variable("right_k3", (Type)VarcharType.VARCHAR)), new EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter("left_k1 = right_k1 OR cast_1 = expr", PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast_1", (Object)PlanMatchPattern.expression("CAST(left_k1 AS varchar)")), PlanMatchPattern.values("left_k1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("COALESCE(right_k2, right_k3)")), PlanMatchPattern.values("right_k1", "right_k2", "right_k3"))))));
    }

    @Test
    public void testTriggerWithArrayContains() {
        this.tester().assertThat((Rule)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)VarcharType.VARCHAR);
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.filter(p.rowExpression("contains(right_array_k1, cast(left_k1 as BIGINT))"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("left_k1", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), new EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter("contains(right_array_k1, cast_l)", PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast_l", (Object)PlanMatchPattern.expression("CAST(left_k1 AS bigint)")), PlanMatchPattern.values("left_k1")), PlanMatchPattern.values("right_array_k1")))));
    }

    @Test
    public void testTriggerWithArrayContains2() {
        this.tester().assertThat((Rule)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)VarcharType.VARCHAR);
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.filter(p.rowExpression("contains(cast(right_array_k1 as array<varchar>), left_k1)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("left_k1", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), new EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter("contains(cast_arr, left_k1)", PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.values("left_k1"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast_arr", (Object)PlanMatchPattern.expression("cast(right_array_k1 as array<varchar>)")), PlanMatchPattern.values("right_array_k1"))))));
    }

    @Test
    public void testNotTriggerWithArrayContains() {
        this.tester().assertThat((Rule)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)VarcharType.VARCHAR);
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.filter(p.rowExpression("contains(right_array_k1, cast(left_k1 as BIGINT)) or cast(left_k1 as BIGINT) > 2"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("left_k1", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), new EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testNotTriggerWithArrayContains2() {
        this.tester().assertThat((Rule)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)DoubleType.DOUBLE);
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.filter(p.rowExpression("contains(cast(right_array_k1 as array<DOUBLE>), left_k1)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("left_k1", (Type)DoubleType.DOUBLE)), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), new EquiJoinClause[0]));
        }).doesNotFire();
    }
}

