/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyCardinalityMap;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.Test;

public class TestSimplifyCardinalityMap
extends BaseRuleTest {
    private final TestingRowExpressionTranslator testSqlToRowExpressionTranslator = new TestingRowExpressionTranslator();

    public TestSimplifyCardinalityMap() {
        super(new Plugin[0]);
    }

    @Test
    public void testRewriteMapValuesCardinality() {
        this.assertRewritten("cardinality(map_values(m))", "cardinality(m)");
    }

    @Test
    public void testRewriteMapValuesMixedCasesCardinality() {
        this.assertRewritten("CaRDinality(map_keys(m))", "cardinaLITY(m)");
    }

    @Test
    public void testNoRewriteMapValuesCardinality() {
        this.assertRewriteDoesNotFire("cardinality(map(ARRAY[1,3], ARRAY[2,4]))");
    }

    @Test
    public void testNestedRewriteMapValuesCardinality() {
        this.assertRewritten("cardinality(map(ARRAY[cardinality(map_values(m_1))], ARRAY[cardinality(map_values(m_2))]))", "cardinality(map(ARRAY[cardinality(m_1)], ARRAY[cardinality(m_2)]))");
    }

    @Test
    public void testNestedRewriteMapKeysCardinality() {
        this.assertRewritten("cardinality(map(ARRAY[cardinality(map_keys(m_1)),3], ARRAY[2,cardinality(map_keys(m_2))]))", "cardinality(map(ARRAY[cardinality(m_1),3], ARRAY[2,cardinality(m_2)]))");
        this.assertRewritten("cast(cardinality(map_keys(m)) as varchar)", "cast(cardinality(m) as varchar)");
    }

    @Test
    public void testAnotherNestedRewriteMapValuesCardinality() {
        this.assertRewritten("cardinality(map(ARRAY[cardinality(map_values(map(ARRAY[1,3], ARRAY[2,4]))),3], ARRAY[2,cardinality(map_values(m_2))]))", "cardinality(map(ARRAY[cardinality(map(ARRAY[1,3], ARRAY[2,4])),3], ARRAY[2,cardinality(m_2)]))");
    }

    private void assertRewriteDoesNotFire(String expression) {
        RowExpression inputExpression = this.testSqlToRowExpressionTranslator.translate(expression, (Map<String, Type>)ImmutableMap.of());
        this.tester().assertThat(new SimplifyCardinalityMap(FunctionAndTypeManager.createTestFunctionAndTypeManager()).projectRowExpressionRewriteRule()).on(p -> p.project(PlanBuilder.assignment(p.variable("x"), inputExpression), (PlanNode)p.values())).doesNotFire();
    }

    private void assertRewritten(String inputExpressionStr, String expectedExpressionStr) {
        Type mapType = PlannerUtils.createMapType((FunctionAndTypeManager)this.getFunctionManager(), (Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        ImmutableMap types = ImmutableMap.of((Object)"m", (Object)mapType, (Object)"m_1", (Object)mapType, (Object)"m_2", (Object)mapType);
        RowExpression inputExpression = this.testSqlToRowExpressionTranslator.translate(inputExpressionStr, (Map<String, Type>)types);
        this.tester().assertThat(new SimplifyCardinalityMap(FunctionAndTypeManager.createTestFunctionAndTypeManager()).projectRowExpressionRewriteRule()).on(p -> p.project(PlanBuilder.assignment(p.variable("x"), inputExpression), (PlanNode)p.values(p.variable("m", mapType), p.variable("m_1", mapType), p.variable("m_2", mapType)))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression(expectedExpressionStr)), PlanMatchPattern.values("m", "m_1", "m_2")));
    }
}

