/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.SingleDistinctAggregationToGroupBy;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestSingleDistinctAggregationToGroupBy
extends BaseRuleTest {
    public TestSingleDistinctAggregationToGroupBy() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoDistinct() {
        this.tester().assertThat((Rule)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.variable("input1"), p.variable("input2"))).addAggregation(p.variable("output1"), p.rowExpression("count(input1)")))).doesNotFire();
    }

    @Test
    public void testMultipleDistincts() {
        this.tester().assertThat((Rule)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.variable("input1"), p.variable("input2"))).addAggregation(p.variable("output1"), p.rowExpression("count(DISTINCT input1)"), true).addAggregation(p.variable("output2"), p.rowExpression("count(DISTINCT input2)"), true))).doesNotFire();
    }

    @Test
    public void testMixedDistinctAndNonDistinct() {
        this.tester().assertThat((Rule)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.variable("input1"), p.variable("input2"))).addAggregation(p.variable("output1"), p.rowExpression("count(DISTINCT input1)"), true).addAggregation(p.variable("output2"), p.rowExpression("count(input2)")))).doesNotFire();
    }

    @Test
    public void testDistinctWithFilter() {
        this.tester().assertThat((Rule)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.variable("input1"), p.variable("input2"))).addAggregation(p.variable("output"), p.rowExpression("count(DISTINCT input1) filter (where input2 > 0)"), Optional.of(p.rowExpression("input2 > 0")), Optional.empty(), true, Optional.empty()))).doesNotFire();
    }

    @Test
    public void testSingleAggregation() {
        this.tester().assertThat((Rule)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.variable("input"))).addAggregation(p.variable("output"), p.rowExpression("count(DISTINCT input)"), true))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("output"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"input"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("input"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("input"))));
    }

    @Test
    public void testMultipleAggregations() {
        this.tester().assertThat((Rule)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.variable("input"))).addAggregation(p.variable("output1"), p.rowExpression("count(DISTINCT input)"), true).addAggregation(p.variable("output2"), p.rowExpression("sum(DISTINCT input)"), true))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.builder().put(Optional.of("output1"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"input"))).put(Optional.of("output2"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"input"))).build(), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("input"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("input"))));
    }

    @Test
    public void testMultipleInputs() {
        this.tester().assertThat((Rule)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.variable("x"), p.variable("y"))).addAggregation(p.variable("output1"), p.rowExpression("corr(DISTINCT x, y)"), true).addAggregation(p.variable("output2"), p.rowExpression("corr(DISTINCT y, x)"), true))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.builder().put(Optional.of("output1"), PlanMatchPattern.functionCall("corr", (List<String>)ImmutableList.of((Object)"x", (Object)"y"))).put(Optional.of("output2"), PlanMatchPattern.functionCall("corr", (List<String>)ImmutableList.of((Object)"y", (Object)"x"))).build(), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("x", "y"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("x", "y"))));
    }
}

