/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule.test;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.assertions.OptimizerAssert;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class RuleTester
implements Closeable {
    public static final String CATALOG_ID = "local";
    public static final ConnectorId CONNECTOR_ID = new ConnectorId("local");
    private final Metadata metadata;
    private final Session session;
    private final LocalQueryRunner queryRunner;
    private final TransactionManager transactionManager;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final AccessControl accessControl;
    private final SqlParser sqlParser;

    public RuleTester() {
        this(Collections.emptyList());
    }

    public RuleTester(List<Plugin> plugins) {
        this(plugins, (Map<String, String>)ImmutableMap.of());
    }

    public RuleTester(List<Plugin> plugins, Map<String, String> sessionProperties) {
        this(plugins, sessionProperties, Optional.empty());
    }

    public RuleTester(List<Plugin> plugins, Map<String, String> sessionProperties, Optional<Integer> nodeCountForStats) {
        this(plugins, sessionProperties, nodeCountForStats, (ConnectorFactory)new TpchConnectorFactory(1));
    }

    public RuleTester(List<Plugin> plugins, Map<String, String> sessionProperties, Optional<Integer> nodeCountForStats, ConnectorFactory connectorFactory) {
        this(plugins, sessionProperties, new SessionPropertyManager(), nodeCountForStats, connectorFactory);
    }

    public RuleTester(List<Plugin> plugins, Map<String, String> sessionProperties, SessionPropertyManager sessionPropertyManager, Optional<Integer> nodeCountForStats, ConnectorFactory connectorFactory) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder((SessionPropertyManager)sessionPropertyManager).setCatalog(CATALOG_ID).setSchema("tiny").setSystemProperty("task_concurrency", "1");
        for (Map.Entry<String, String> entry : sessionProperties.entrySet()) {
            sessionBuilder.setSystemProperty(entry.getKey(), entry.getValue());
        }
        this.session = sessionBuilder.build();
        this.queryRunner = nodeCountForStats.map(nodeCount -> LocalQueryRunner.queryRunnerWithFakeNodeCountForStats((Session)this.session, (int)nodeCount)).orElseGet(() -> new LocalQueryRunner(this.session));
        this.queryRunner.createCatalog((String)this.session.getCatalog().get(), connectorFactory, (Map)ImmutableMap.of());
        plugins.stream().forEach(arg_0 -> ((LocalQueryRunner)this.queryRunner).installPlugin(arg_0));
        this.metadata = this.queryRunner.getMetadata();
        this.transactionManager = this.queryRunner.getTransactionManager();
        this.splitManager = this.queryRunner.getSplitManager();
        this.pageSourceManager = this.queryRunner.getPageSourceManager();
        this.accessControl = this.queryRunner.getAccessControl();
        this.sqlParser = this.queryRunner.getSqlParser();
    }

    public RuleAssert assertThat(Rule rule) {
        return new RuleAssert(this.metadata, this.queryRunner.getStatsCalculator(), this.queryRunner.getEstimatedExchangesCostCalculator(), this.session, rule, this.transactionManager, this.accessControl);
    }

    public RuleAssert assertThat(Rule rule, LogicalPropertiesProvider logicalPropertiesProvider) {
        return new RuleAssert(this.metadata, this.queryRunner.getStatsCalculator(), this.queryRunner.getEstimatedExchangesCostCalculator(), this.session, rule, this.transactionManager, this.accessControl, Optional.of(logicalPropertiesProvider));
    }

    public OptimizerAssert assertThat(Set<Rule<?>> rules) {
        IterativeOptimizer optimizer = new IterativeOptimizer(this.getMetadata(), new RuleStatsRecorder(), this.queryRunner.getStatsCalculator(), this.queryRunner.getCostCalculator(), rules);
        return new OptimizerAssert(this.metadata, this.queryRunner, this.queryRunner.getStatsCalculator(), this.session, (PlanOptimizer)optimizer, this.transactionManager, this.accessControl);
    }

    public OptimizerAssert assertThat(Set<Rule<?>> rules, LogicalPropertiesProvider logicalPropertiesProvider) {
        IterativeOptimizer optimizer = new IterativeOptimizer(this.getMetadata(), new RuleStatsRecorder(), this.queryRunner.getStatsCalculator(), this.queryRunner.getCostCalculator(), Optional.of(logicalPropertiesProvider), rules);
        return new OptimizerAssert(this.metadata, this.queryRunner, this.queryRunner.getStatsCalculator(), this.session, (PlanOptimizer)optimizer, this.transactionManager, this.accessControl);
    }

    public OptimizerAssert assertThat(PlanOptimizer optimizer) {
        return new OptimizerAssert(this.metadata, this.queryRunner, this.queryRunner.getStatsCalculator(), this.session, optimizer, this.transactionManager, this.accessControl);
    }

    @Override
    public void close() {
        this.queryRunner.close();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Session getSession() {
        return this.session;
    }

    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    public SqlParser getSqlParser() {
        return this.sqlParser;
    }

    public ConnectorId getCurrentConnectorId() {
        return (ConnectorId)((Optional)this.queryRunner.inTransaction(transactionSession -> this.metadata.getCatalogHandle(transactionSession, (String)this.session.getCatalog().get()))).get();
    }

    public List<TableConstraint<ColumnHandle>> getTableConstraints(TableHandle tableHandle) {
        return (List)this.queryRunner.inTransaction(transactionSession -> {
            this.metadata.getCatalogHandle(transactionSession, (String)this.session.getCatalog().get());
            return this.metadata.getTableMetadata(transactionSession, tableHandle).getMetadata().getTableConstraintsHolder().getTableConstraintsWithColumnHandles();
        });
    }
}

