/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.optimizations.ApplyConnectorOptimization;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestConnectorOptimization {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final PlanBuilder PLAN_BUILDER = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), METADATA);

    @Test
    public void testSupportedPlanNodes() {
        Set expected = (Set)Arrays.stream(PlanVisitor.class.getDeclaredMethods()).map(Method::getParameterTypes).filter(parameterTypes -> ((Class[])parameterTypes).length > 0).filter(parameterTypes -> PlanNode.class.isAssignableFrom(parameterTypes[0])).filter(parameterTypes -> Modifier.isFinal(parameterTypes[0].getModifiers())).map(parameterTypes -> parameterTypes[0]).collect(ImmutableSet.toImmutableSet());
        Assert.assertEquals((Set)ApplyConnectorOptimization.CONNECTOR_ACCESSIBLE_PLAN_NODES, (Set)expected);
    }

    @Test
    public void testEmptyOptimizers() {
        OutputNode plan = this.output((PlanNode)this.filter((PlanNode)this.tableScan("cat1", "a", "b"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT), "a");
        PlanNode actual = TestConnectorOptimization.optimize((PlanNode)plan, (Map<ConnectorId, Set<ConnectorPlanOptimizer>>)ImmutableMap.of());
        Assert.assertEquals((Object)actual, (Object)plan);
        actual = TestConnectorOptimization.optimize((PlanNode)plan, (Map<ConnectorId, Set<ConnectorPlanOptimizer>>)ImmutableMap.of((Object)new ConnectorId("cat2"), (Object)ImmutableSet.of((Object)TestConnectorOptimization.noop())));
        Assert.assertEquals((Object)actual, (Object)plan);
    }

    @Test
    public void testMultipleConnectors() {
        OutputNode plan = this.output((PlanNode)this.union(new PlanNode[]{this.tableScan("cat1", "a", "b"), this.tableScan("cat2", "a", "b"), this.tableScan("cat3", "a", "b"), this.tableScan("cat4", "a", "b"), this.tableScan("cat2", "a", "b"), this.tableScan("cat1", "a", "b"), this.values("a", "b")}), "a");
        PlanNode actual = TestConnectorOptimization.optimize((PlanNode)plan, (Map<ConnectorId, Set<ConnectorPlanOptimizer>>)ImmutableMap.of());
        Assert.assertEquals((Object)actual, (Object)plan);
        actual = TestConnectorOptimization.optimize((PlanNode)plan, (Map<ConnectorId, Set<ConnectorPlanOptimizer>>)ImmutableMap.of((Object)new ConnectorId("cat2"), (Object)ImmutableSet.of((Object)TestConnectorOptimization.noop())));
        Assert.assertEquals((Object)actual, (Object)plan);
    }

    @Test
    public void testPlanUpdateWithComplexStructures() {
        OutputNode plan = this.output((PlanNode)this.union(new PlanNode[]{this.filter((PlanNode)this.tableScan("cat1", "a", "b"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT), this.filter((PlanNode)this.tableScan("cat2", "a", "b"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT), this.union(new PlanNode[]{this.filter((PlanNode)this.tableScan("cat3", "a", "b"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT), this.union(new PlanNode[]{this.filter((PlanNode)this.tableScan("cat4", "a", "b"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT), this.filter((PlanNode)this.tableScan("cat1", "a", "b"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT)})}), this.filter((PlanNode)this.tableScan("cat2", "a", "b"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT), this.union(new PlanNode[]{this.filter((PlanNode)this.tableScan("cat1", "a", "b"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT)})}), "a");
        PlanNode actual = TestConnectorOptimization.optimize((PlanNode)plan, (Map<ConnectorId, Set<ConnectorPlanOptimizer>>)ImmutableMap.of());
        Assert.assertEquals((Object)actual, (Object)plan);
        actual = TestConnectorOptimization.optimize((PlanNode)plan, (Map<ConnectorId, Set<ConnectorPlanOptimizer>>)ImmutableMap.of((Object)new ConnectorId("cat1"), (Object)ImmutableSet.of((Object)TestConnectorOptimization.filterPushdown()), (Object)new ConnectorId("cat2"), (Object)ImmutableSet.of((Object)TestConnectorOptimization.filterPushdown()), (Object)new ConnectorId("cat3"), (Object)ImmutableSet.of((Object)TestConnectorOptimization.filterPushdown()), (Object)new ConnectorId("cat4"), (Object)ImmutableSet.of((Object)TestConnectorOptimization.filterPushdown())));
        TestConnectorOptimization.assertPlanMatch(actual, PlanMatchPattern.output(PlanMatchPattern.union(SimpleTableScanMatcher.tableScan("cat1", (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, new String[0]), SimpleTableScanMatcher.tableScan("cat2", (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, new String[0]), PlanMatchPattern.union(SimpleTableScanMatcher.tableScan("cat3", (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, new String[0]), PlanMatchPattern.union(SimpleTableScanMatcher.tableScan("cat4", (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, new String[0]), SimpleTableScanMatcher.tableScan("cat1", (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, new String[0]))), SimpleTableScanMatcher.tableScan("cat2", (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, new String[0]), PlanMatchPattern.union(SimpleTableScanMatcher.tableScan("cat1", (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, new String[0])))));
    }

    @Test
    public void testPushFilterToTableScan() {
        RowExpression expectedPredicate = LogicalRowExpressions.and((RowExpression[])new RowExpression[]{TestConnectorOptimization.newBigintVariable("a"), TestConnectorOptimization.newBigintVariable("b")});
        OutputNode plan = this.output((PlanNode)this.filter((PlanNode)this.tableScan("cat1", "a", "b"), expectedPredicate), "a");
        PlanNode actual = TestConnectorOptimization.optimize((PlanNode)plan, (Map<ConnectorId, Set<ConnectorPlanOptimizer>>)ImmutableMap.of((Object)new ConnectorId("cat1"), (Object)ImmutableSet.of((Object)TestConnectorOptimization.filterPushdown())));
        TestConnectorOptimization.assertPlanMatch(actual, PlanMatchPattern.output(SimpleTableScanMatcher.tableScan("cat1", expectedPredicate, new String[0])));
    }

    @Test
    public void testAddFilterToTableScan() {
        RowExpression expectedPredicate = LogicalRowExpressions.and((RowExpression[])new RowExpression[]{TestConnectorOptimization.newBigintVariable("a"), TestConnectorOptimization.newBigintVariable("b")});
        OutputNode plan = this.output((PlanNode)this.tableScan("cat1", "a", "b"), "a");
        PlanNode actual = TestConnectorOptimization.optimize((PlanNode)plan, (Map<ConnectorId, Set<ConnectorPlanOptimizer>>)ImmutableMap.of((Object)new ConnectorId("cat1"), (Object)ImmutableSet.of((Object)TestConnectorOptimization.addFilterToTableScan(expectedPredicate))));
        TestConnectorOptimization.assertPlanMatch(actual, PlanMatchPattern.output(PlanMatchPattern.filter("a AND b", SimpleTableScanMatcher.tableScan("cat1", "a", "b"))), TypeProvider.viewOf((Map)ImmutableMap.of((Object)"a", (Object)BigintType.BIGINT, (Object)"b", (Object)BigintType.BIGINT)));
        RowExpression existingPredicate = LogicalRowExpressions.or((RowExpression[])new RowExpression[]{TestConnectorOptimization.newBigintVariable("a"), TestConnectorOptimization.newBigintVariable("b")});
        plan = this.output((PlanNode)this.filter((PlanNode)this.tableScan("cat1", "a", "b"), existingPredicate), "a");
        actual = TestConnectorOptimization.optimize((PlanNode)plan, (Map<ConnectorId, Set<ConnectorPlanOptimizer>>)ImmutableMap.of((Object)new ConnectorId("cat1"), (Object)ImmutableSet.of((Object)TestConnectorOptimization.addFilterToTableScan(expectedPredicate))));
        TestConnectorOptimization.assertPlanMatch(actual, PlanMatchPattern.output(PlanMatchPattern.filter("(a OR b) AND (a AND b)", SimpleTableScanMatcher.tableScan("cat1", "a", "b"))), TypeProvider.viewOf((Map)ImmutableMap.of((Object)"a", (Object)BigintType.BIGINT, (Object)"b", (Object)BigintType.BIGINT)));
    }

    private TableScanNode tableScan(String connectorName, String ... columnNames) {
        return PLAN_BUILDER.tableScan(connectorName, (List<VariableReferenceExpression>)((List)Arrays.stream(columnNames).map(TestConnectorOptimization::newBigintVariable).collect(ImmutableList.toImmutableList())), Arrays.stream(columnNames).map(TestConnectorOptimization::newBigintVariable).collect(Collectors.toMap(Function.identity(), variable -> new ColumnHandle(){})));
    }

    private FilterNode filter(PlanNode source, RowExpression predicate) {
        return PLAN_BUILDER.filter(predicate, source);
    }

    private OutputNode output(PlanNode source, String ... columnNames) {
        return PLAN_BUILDER.output((List)Arrays.stream(columnNames).collect(ImmutableList.toImmutableList()), (List)Arrays.stream(columnNames).map(TestConnectorOptimization::newBigintVariable).collect(ImmutableList.toImmutableList()), source);
    }

    private UnionNode union(PlanNode ... sources) {
        ImmutableListMultimap.Builder outputsToInputs = ImmutableListMultimap.builder();
        for (PlanNode source : sources) {
            outputsToInputs.putAll(source.getOutputVariables().stream().collect(Collectors.toMap(Function.identity(), Function.identity())).entrySet());
        }
        return PLAN_BUILDER.union((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)outputsToInputs.build(), Arrays.asList(sources));
    }

    private ValuesNode values(String ... columnNames) {
        VariableReferenceExpression[] columns = new VariableReferenceExpression[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            columns[i] = TestConnectorOptimization.newBigintVariable(columnNames[i]);
        }
        return PLAN_BUILDER.values(5, columns);
    }

    private static VariableReferenceExpression newBigintVariable(String name) {
        return new VariableReferenceExpression(Optional.empty(), name, (Type)BigintType.BIGINT);
    }

    private static void assertPlanMatch(PlanNode actual, PlanMatchPattern expected) {
        TestConnectorOptimization.assertPlanMatch(actual, expected, TypeProvider.empty());
    }

    private static void assertPlanMatch(PlanNode actual, PlanMatchPattern expected, TypeProvider typeProvider) {
        PlanAssert.assertPlan(SessionTestUtils.TEST_SESSION, METADATA, (node, sourceStats, lookup, session, types) -> PlanNodeStatsEstimate.unknown(), new Plan(actual, typeProvider, StatsAndCosts.empty()), expected);
    }

    private static PlanNode optimize(PlanNode plan, Map<ConnectorId, Set<ConnectorPlanOptimizer>> optimizers) {
        ApplyConnectorOptimization optimizer = new ApplyConnectorOptimization(() -> optimizers);
        return optimizer.optimize(plan, SessionTestUtils.TEST_SESSION, TypeProvider.empty(), new VariableAllocator(), new PlanNodeIdAllocator(), WarningCollector.NOOP).getPlanNode();
    }

    private static ConnectorPlanOptimizer filterPushdown() {
        return (maxSubplan, session, variableAllocator, idAllocator) -> (PlanNode)maxSubplan.accept((PlanVisitor)new TestFilterPushdownVisitor(), null);
    }

    private static ConnectorPlanOptimizer addFilterToTableScan(RowExpression filter) {
        return (maxSubplan, session, variableAllocator, idAllocator) -> (PlanNode)maxSubplan.accept((PlanVisitor)new TestAddFilterVisitor(filter, idAllocator), null);
    }

    private static ConnectorPlanOptimizer noop() {
        return (maxSubplan, session, variableAllocator, idAllocator) -> maxSubplan;
    }

    private static final class SimpleTableScanMatcher
    implements Matcher {
        private final ConnectorId connectorId;
        private final Optional<ConnectorTableLayoutHandle> connectorTableLayoutHandle;
        private final String[] columns;

        public static PlanMatchPattern tableScan(String connectorName, RowExpression predicate, String ... columnNames) {
            return PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).with(new SimpleTableScanMatcher(new ConnectorId(connectorName), Optional.ofNullable(predicate).map(TestFilterPushdownVisitor.TestConnectorTableLayoutHandle::new), columnNames));
        }

        public static PlanMatchPattern tableScan(String connectorName, String ... columnNames) {
            return SimpleTableScanMatcher.tableScan(connectorName, null, columnNames);
        }

        private SimpleTableScanMatcher(ConnectorId connectorId, Optional<ConnectorTableLayoutHandle> connectorTableLayoutHandle, String ... columns) {
            this.connectorId = connectorId;
            this.connectorTableLayoutHandle = connectorTableLayoutHandle;
            this.columns = columns;
        }

        @Override
        public boolean shapeMatches(PlanNode node) {
            return node instanceof TableScanNode;
        }

        @Override
        public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
            Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
            TableScanNode tableScanNode = (TableScanNode)node;
            if (this.connectorId.equals((Object)tableScanNode.getTable().getConnectorId()) && this.connectorTableLayoutHandle.equals(tableScanNode.getTable().getLayout())) {
                return MatchResult.match(SymbolAliases.builder().putAll(Arrays.stream(this.columns).collect(Collectors.toMap(Function.identity(), SymbolReference::new))).build());
            }
            return MatchResult.NO_MATCH;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("connectorId", (Object)this.connectorId).add("connectorTableLayoutHandle", this.connectorTableLayoutHandle.orElse(null)).toString();
        }
    }

    private static class TestAddFilterVisitor
    extends TestPlanOptimizationVisitor {
        private final RowExpression filter;
        private final PlanNodeIdAllocator idAllocator;

        TestAddFilterVisitor(RowExpression filter, PlanNodeIdAllocator idAllocator) {
            this.filter = filter;
            this.idAllocator = idAllocator;
        }

        public PlanNode visitFilter(FilterNode node, Void context) {
            if (node.getSource() instanceof TableScanNode) {
                return new FilterNode(Optional.empty(), node.getId(), node.getSource(), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{node.getPredicate(), this.filter}));
            }
            return node;
        }

        public PlanNode visitTableScan(TableScanNode node, Void context) {
            return new FilterNode(Optional.empty(), this.idAllocator.getNextId(), (PlanNode)node, this.filter);
        }
    }

    private static class TestFilterPushdownVisitor
    extends TestPlanOptimizationVisitor {
        private TestFilterPushdownVisitor() {
        }

        public PlanNode visitFilter(FilterNode node, Void context) {
            if (node.getSource() instanceof TableScanNode) {
                TableScanNode tableScanNode = (TableScanNode)node.getSource();
                TableHandle handle = tableScanNode.getTable();
                return new TableScanNode(Optional.empty(), tableScanNode.getId(), new TableHandle(handle.getConnectorId(), handle.getConnectorHandle(), handle.getTransaction(), Optional.of(new TestConnectorTableLayoutHandle(node.getPredicate()))), tableScanNode.getOutputVariables(), tableScanNode.getAssignments(), tableScanNode.getTableConstraints(), TupleDomain.all(), TupleDomain.all());
            }
            return node;
        }

        static class TestConnectorTableLayoutHandle
        implements ConnectorTableLayoutHandle {
            private final RowExpression predicate;

            TestConnectorTableLayoutHandle(RowExpression predicate) {
                this.predicate = predicate;
            }

            public RowExpression getPredicate() {
                return this.predicate;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof TestConnectorTableLayoutHandle)) {
                    return false;
                }
                TestConnectorTableLayoutHandle other = (TestConnectorTableLayoutHandle)obj;
                return Objects.equals(this.predicate, other.predicate);
            }

            public int hashCode() {
                return Objects.hashCode(this.predicate);
            }
        }
    }

    private static class TestPlanOptimizationVisitor
    extends PlanVisitor<PlanNode, Void> {
        private TestPlanOptimizationVisitor() {
        }

        public PlanNode visitPlan(PlanNode node, Void context) {
            ImmutableList.Builder children = ImmutableList.builder();
            for (PlanNode child : node.getSources()) {
                children.add(child.accept((PlanVisitor)this, null));
            }
            return node.replaceChildren((List)children.build());
        }
    }
}

