/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.CteConsumerNode;
import com.facebook.presto.spi.plan.CteProducerNode;
import com.facebook.presto.spi.plan.CteReferenceNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.optimizations.LogicalCteOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.SequenceNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLogicalCteOptimizer
extends BasePlanTest {
    private static final List<Class<? extends PlanNode>> CTE_PLAN_NODES = ImmutableList.of(CteReferenceNode.class, CteConsumerNode.class, CteProducerNode.class, SequenceNode.class);

    @Test
    public void testConvertSimpleCte() {
        this.assertUnitPlan("WITH  temp as (SELECT orderkey FROM ORDERS) SELECT * FROM temp t JOIN temp t2 ON true ", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0))))));
    }

    @Test
    public void testSimpleRedefinedCteWithSameNameDefinedAgain() {
        this.assertUnitPlan("WITH \ntest_base AS (SELECT colB FROM (VALUES (1), (2)) AS TempTable(colB)),\ntest AS (\n    \n    WITH test_base as (SELECT colA FROM (VALUES (1), (2)) AS TempTable(colA)),\n    test1 AS (\n        WITH test2 AS(\n          SELECT * FROM test_base\n        )\n        SELECT * FROM test2\n    )\n    SELECT * FROM test1\n)\n\nSELECT * FROM test", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("test", 3), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("test1", 2)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("test1", 2), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("test2", 1)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("test2", 1), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("test_base", 0)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("test_base", 0), PlanMatchPattern.anyTree(PlanMatchPattern.values("colA"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("test", 3))))));
    }

    @Test
    public void testSimpleRedefinedCteWithSameName() {
        this.assertUnitPlan("WITH  temp as ( with temp as (SELECT orderkey FROM ORDERS) SELECT * FROM temp) SELECT * FROM temp", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 1), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 1))))));
    }

    @Test
    public void testComplexRedefinedNestedCtes() {
        this.assertUnitPlan("WITH cte1 AS (    SELECT orderkey, totalprice FROM ORDERS WHERE orderkey < 100 ), cte2 AS (    WITH cte3 AS ( WITH cte4 AS (SELECT orderkey, totalprice FROM cte1 WHERE totalprice > 1000) SELECT * FROM cte4)    SELECT cte3.orderkey FROM cte3 ), cte3 AS (    SELECT * FROM customer WHERE custkey < 50 ) SELECT cte3.*, cte2.orderkey FROM cte3 JOIN cte2 ON cte3.custkey = cte2.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte3", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer"))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte2", 4), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte3", 3)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte3", 3), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte4", 2)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte4", 2), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte1", 1)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte1", 1), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte3", 0))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte2", 4))))))));
    }

    @Test
    public void testRedefinedCteConflictingNamesInDifferentScope() {
        this.assertUnitPlan("WITH test AS (SELECT colA FROM (VALUES (1), (2)) AS TempTable(colA)),\n _query AS (\n    with test AS (\n     SELECT * FROM test\n     )\n     SELECT * FROM test\n  )\n  SELECT * FROM _query", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("_query", 2), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("test", 1)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("test", 1), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("test", 0)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("test", 0), PlanMatchPattern.anyTree(PlanMatchPattern.values("colA"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("_query", 2))))));
    }

    @Test
    public void testCtesDefinedInEntirelyDifferentScope() {
        this.assertUnitPlan("SELECT \n   *, (WITH T as (SELECT colA FROM (VALUES (1), (2)) AS TempTable(colA)) SELECT * FROM T)\nFROM (\n    WITH T AS ( \n      SELECT ColumnA, ColumnB FROM (\n            VALUES \n            (1, 'A'),\n            (2, 'B'),\n            (3, 'C'),\n            (4, 'D')\n        ) AS TempTable(ColumnA, ColumnB)\n    )\n    SELECT * FROM T JOIN T ON TRUE)", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("T", 0), PlanMatchPattern.anyTree(PlanMatchPattern.values("ColumnA", "ColumnB"))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("T", 1), PlanMatchPattern.anyTree(PlanMatchPattern.values("colA"))), PlanMatchPattern.anyTree(PlanMatchPattern.lateral((List<String>)ImmutableList.of(), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("T", 0))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("T", 0))))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("T", 1))))))));
    }

    @Test
    public void testNestedCtesReused() {
        this.assertUnitPlan("WITH  cte1 AS ( WITH cte2 as (SELECT orderkey FROM ORDERS WHERE orderkey < 100)SELECT * FROM cte2)SELECT * FROM  cte1  JOIN cte1 ON true", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte1", 1), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte2", 0)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte2", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte1", 1))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte1", 1))))))));
    }

    @Test
    public void testRedefinedCtesInDifferentScope() {
        this.assertUnitPlan("WITH  cte1 AS ( WITH cte2 as (SELECT orderkey FROM ORDERS WHERE orderkey < 100)SELECT * FROM cte2),  cte2 AS (SELECT * FROM customer WHERE custkey < 50) SELECT * FROM cte2  JOIN cte1 ON true", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte2", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer"))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte1", 2), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte2", 1)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte2", 1), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte2", 0))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte1", 2))))))));
    }

    @Test
    public void testNestedCte() {
        this.assertUnitPlan("WITH  temp1 as (SELECT orderkey FROM ORDERS),  temp2 as (SELECT * FROM temp1) SELECT * FROM temp2", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp2", 1), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp1", 0)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp1", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp2", 1))))));
    }

    @Test
    public void testMultipleIndependentCtes() {
        this.assertUnitPlan("WITH  temp1 as (SELECT orderkey FROM ORDERS),  temp2 as (SELECT custkey FROM CUSTOMER) SELECT * FROM temp1, temp2", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp1", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp2", 1), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp1", 0))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp2", 1))))))));
    }

    @Test
    public void testDependentCtes() {
        this.assertUnitPlan("WITH  temp1 as (SELECT orderkey FROM ORDERS),  temp2 as (SELECT orderkey FROM temp1) SELECT * FROM temp2 , temp1", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp2", 1), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp1", 0)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp1", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp2", 1))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp1", 0))))))));
    }

    @Test
    public void testComplexCteWithJoins() {
        this.assertUnitPlan("WITH  cte_orders AS (SELECT orderkey, custkey FROM ORDERS),  cte_line_item AS (SELECT l.orderkey, l.suppkey FROM lineitem l JOIN cte_orders o ON l.orderkey = o.orderkey) SELECT li.orderkey, s.suppkey, s.name FROM cte_line_item li JOIN SUPPLIER s ON li.suppkey = s.suppkey", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte_line_item", 1), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte_orders", 0)))))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte_orders", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("cte_line_item", 1))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("supplier")))))));
    }

    @Test
    public void testSimplePersistentCteWithRowTypeAndNonRowType() {
        this.assertUnitPlan("WITH temp AS (  SELECT * FROM (VALUES     (CAST(ROW('example_status', 100) AS ROW(status VARCHAR, amount INTEGER)), 1),    (CAST(ROW('another_status', 200) AS ROW(status VARCHAR, amount INTEGER)), 2)  ) AS t (order_details, orderkey)) SELECT * FROM temp", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0), PlanMatchPattern.anyTree(PlanMatchPattern.values("status", "amount"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0))))));
    }

    @Test(enabled=false)
    public void testNoPersistentCteWithZeroLengthVarcharType() {
        this.assertUnitPlan("WITH temp AS (  SELECT * FROM (VALUES     (CAST('' AS VARCHAR(0)), 9)  ) AS t (text_column, number_column)) SELECT * FROM temp", PlanMatchPattern.anyTree(PlanMatchPattern.values("text_column", "number_column")));
    }

    @Test
    public void testHeuristicComplexCteMaterialization() {
        this.assertUnitPlan(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC_COMPLEX_QUERIES_ONLY").setSystemProperty("cte_heuristic_replication_threshold", "4").build(), "WITH temp AS (    SELECT orderkey FROM ORDERS GROUP BY orderkey)SELECT * FROM temp UNION SELECT * FROM temp UNION SELECT * FROM temp UNION SELECT * FROM temp", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0))))));
    }

    @Test
    public void testHeuristicComplexCteMaterializationForInnerCtes() {
        this.assertUnitPlan(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC_COMPLEX_QUERIES_ONLY").setSystemProperty("cte_heuristic_replication_threshold", "4").build(), "WITH temp AS (With inner_temp AS(    SELECT orderkey FROM ORDERS GROUP BY orderkey)SELECT * FROM inner_temp)SELECT * FROM temp UNION SELECT * FROM temp UNION SELECT * FROM temp UNION SELECT * FROM temp", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("inner_temp", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("inner_temp", 0))))));
    }

    @Test
    public void testNoHeuristicCteMaterializationForInnerCtes() {
        this.assertUnitPlan(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC_COMPLEX_QUERIES_ONLY").setSystemProperty("cte_heuristic_replication_threshold", "4").build(), "WITH temp AS (With inner_temp AS(    SELECT orderkey  FROM ORDERS GROUP BY orderkey)SELECT * FROM inner_temp GROUP BY orderkey)SELECT * FROM temp UNION SELECT * FROM temp UNION SELECT * FROM temp UNION SELECT * FROM temp", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 1), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 1))))));
    }

    @Test
    public void testHeuristicComplexCteMaterializationForBothCtes() {
        this.assertUnitPlan(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC_COMPLEX_QUERIES_ONLY").setSystemProperty("cte_heuristic_replication_threshold", "4").build(), "WITH temp AS (\n    WITH inner_temp AS (\n        SELECT orderkey\n        FROM ORDERS\n        GROUP BY orderkey\n    )\n    SELECT * FROM inner_temp GROUP BY orderkey \n    UNION\n    SELECT * FROM inner_temp GROUP BY orderkey\n    UNION\n    SELECT * FROM inner_temp GROUP BY orderkey\n    UNION\n    SELECT * FROM inner_temp GROUP BY orderkey\n)\nSELECT * FROM temp\nUNION\nSELECT * FROM temp\nUNION\nSELECT * FROM temp\nUNION\nSELECT * FROM temp", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 1), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("inner_temp", 0)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("inner_temp", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 1))))));
    }

    @Test
    public void testHeuristicMaterializationWithMultipleNestedCtesAllMaterialized() {
        this.assertUnitPlan(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC").setSystemProperty("cte_heuristic_replication_threshold", "2").build(), "WITH outer_temp AS (\n   WITH mid_temp AS (\n       WITH inner_temp AS (\n           SELECT orderkey, COUNT(*) as total_orders FROM ORDERS GROUP BY orderkey\n       )\n       SELECT orderkey FROM inner_temp WHERE total_orders > 1\n       UNION ALL \n       SELECT orderkey FROM inner_temp\n   )\n   SELECT orderkey FROM mid_temp\n   UNION ALL \n   SELECT orderkey FROM mid_temp\n)\nSELECT * FROM outer_temp \nUNION ALL SELECT * FROM outer_temp  \nUNION ALL SELECT * FROM outer_temp \n", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("outer_temp", 2), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("mid_temp", 1)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("mid_temp", 1), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("inner_temp", 0)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("inner_temp", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("outer_temp", 2))))));
    }

    @Test
    public void testHeuristicMaterializationWithMultipleNestedCtesWhereInnerNotMaterialized() {
        this.assertUnitPlan(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC").setSystemProperty("cte_heuristic_replication_threshold", "3").build(), "WITH outer_temp AS (\n   WITH mid_temp AS (\n       WITH inner_temp AS (\n           SELECT orderkey, COUNT(*) as total_orders FROM ORDERS GROUP BY orderkey\n       )\n       SELECT orderkey FROM inner_temp WHERE total_orders > 1\n       UNION ALL \n       SELECT orderkey FROM inner_temp\n   )\n   SELECT orderkey FROM mid_temp\n   UNION ALL \n   SELECT orderkey FROM mid_temp\n   UNION ALL \n   SELECT orderkey FROM mid_temp\n)SELECT * FROM outer_temp \nUNION ALL SELECT * FROM outer_temp \nUNION ALL SELECT * FROM outer_temp \n", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("outer_temp", 2), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("mid_temp", 1)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("mid_temp", 1), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("outer_temp", 2))))));
    }

    @Test
    public void testHeuristicMaterializationWithDifferentPaths() {
        this.assertUnitPlan(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC").setSystemProperty("cte_heuristic_replication_threshold", "3").build(), "WITH first_cte AS (\n   SELECT orderkey FROM ORDERS\n), second_cte AS (\n   SELECT orderkey FROM first_cte\n), third_cte AS (\n   SELECT orderkey FROM second_cte\n   UNION ALL \n   SELECT orderkey FROM first_cte \n)\nSELECT * FROM third_cte \nUNION ALL\nSELECT * FROM second_cte \nUNION ALL\nSELECT * FROM first_cte \n", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("first_cte", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("first_cte", 0))))));
    }

    @Test
    public void testHeuristicMaterializationWithDeepNestedCteUsage() {
        this.assertUnitPlan(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC").setSystemProperty("cte_heuristic_replication_threshold", "3").build(), "WITH b AS (\n   SELECT orderkey FROM ORDERS\n),\na AS (\n   SELECT orderkey FROM b\n   UNION ALL\n   SELECT orderkey FROM b\n),\ny AS (\n   SELECT orderkey FROM a\n   UNION ALL\n   SELECT orderkey FROM a\n),\nx AS (\n   SELECT orderkey FROM y\n   UNION ALL\n   SELECT orderkey FROM y\n   UNION ALL\n   SELECT orderkey FROM y\n   UNION ALL\n   SELECT orderkey FROM y\n)\nSELECT * FROM x\nUNION ALL\nSELECT * FROM x\nUNION ALL\nSELECT * FROM x\n", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("x", 3), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("y", 2)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("y", 2), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("b", 0)))), PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("b", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("x", 3))))));
    }

    @Test
    public void testHeuristicMaterializationWithDeepNestedCteUsage2() {
        this.assertUnitPlan(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC").setSystemProperty("cte_heuristic_replication_threshold", "5").build(), "WITH b AS (\n   SELECT orderkey FROM ORDERS\n),\na AS (\n   SELECT orderkey FROM b\n   UNION ALL\n   SELECT orderkey FROM b\n),\ny AS (\n   SELECT orderkey FROM a\n   UNION ALL\n   SELECT orderkey FROM a\n),\nx AS (\n   SELECT orderkey FROM y\n   UNION ALL\n   SELECT orderkey FROM y\n   UNION ALL\n   SELECT orderkey FROM y\n   UNION ALL\n   SELECT orderkey FROM y\n)\nSELECT * FROM x \nUNION ALL\nSELECT * FROM x\nUNION ALL\nSELECT * FROM x\n", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("y", 2), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("y", 2))))));
    }

    @Test
    public void testHeuristicMaterializationWithDeepNestedCteUsage3() {
        this.assertUnitPlan(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC").setSystemProperty("cte_heuristic_replication_threshold", "3").build(), "WITH b AS (\n   SELECT orderkey FROM ORDERS\n),\na AS (\n   SELECT orderkey FROM b\n),\nc as ( SELECT orderkey FROM b)\nSELECT * FROM c\nUNION ALL\nSELECT * FROM a\nUNION ALL\nSELECT * FROM a\nUNION ALL\nSELECT * FROM a\n", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("a", 2), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.union(PlanMatchPattern.union(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("a", 2)))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("a", 2)))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("a", 2))))))));
    }

    @Test
    public void testNoHeuristicComplexCteMaterializationWithoutComplexNodes() {
        this.assertUnitPlanWithValidator(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC_COMPLEX_QUERIES_ONLY").setSystemProperty("cte_heuristic_replication_threshold", "4").build(), "WITH temp AS (    SELECT orderkey FROM ORDERS)SELECT * FROM temp UNION SELECT * FROM temp UNION SELECT * FROM temp UNION SELECT * FROM temp", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")), plan -> Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(planNode -> CTE_PLAN_NODES.stream().anyMatch(clazz -> clazz.isInstance(planNode))).matches()));
    }

    @Test
    public void testNoHeuristicComplexCteMaterializationWithoutDataNodes() {
        this.assertUnitPlanWithValidator(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC_COMPLEX_QUERIES_ONLY").setSystemProperty("cte_heuristic_replication_threshold", "0").build(), "WITH temp AS (    SELECT colB FROM (VALUES (1), (2)) AS TempTable(colB))SELECT * FROM temp ", PlanMatchPattern.anyTree(PlanMatchPattern.values("colB")), plan -> Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(planNode -> CTE_PLAN_NODES.stream().anyMatch(clazz -> clazz.isInstance(planNode))).matches()));
    }

    @Test
    public void testHeuristicCteMaterialization() {
        this.assertUnitPlan(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC").setSystemProperty("cte_heuristic_replication_threshold", "4").build(), "WITH temp AS (    SELECT orderkey FROM ORDERS)SELECT * FROM temp UNION SELECT * FROM temp UNION SELECT * FROM temp UNION SELECT * FROM temp", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0))))));
    }

    @Test
    public void testNoHeuristicCteMaterializationWithLesserReferences() {
        this.assertUnitPlanWithValidator(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "HEURISTIC").setSystemProperty("cte_heuristic_replication_threshold", "4").build(), "WITH temp AS (    SELECT orderkey FROM ORDERS)SELECT * FROM temp UNION SELECT * FROM temp UNION SELECT * FROM temp ", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")), plan -> Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(planNode -> CTE_PLAN_NODES.stream().anyMatch(clazz -> clazz.isInstance(planNode))).matches()));
    }

    public static String addQueryScopeDelimiter(String cteName, int scope) {
        return String.valueOf(scope) + "_*%$_" + cteName;
    }

    private void assertUnitPlan(String sql, PlanMatchPattern pattern) {
        this.assertUnitPlan(this.getSession(), sql, pattern);
    }

    private void assertUnitPlan(Session session, String sql, PlanMatchPattern pattern) {
        ImmutableList optimizers = ImmutableList.of((Object)new LogicalCteOptimizer(this.getQueryRunner().getMetadata()));
        this.assertPlan(sql, session, Optimizer.PlanStage.OPTIMIZED, pattern, (List<PlanOptimizer>)optimizers);
    }

    private void assertUnitPlanWithValidator(Session session, String sql, PlanMatchPattern pattern, Consumer<Plan> planValidator) {
        ImmutableList optimizers = ImmutableList.of((Object)new LogicalCteOptimizer(this.getQueryRunner().getMetadata()));
        this.getQueryRunner().inTransaction(session, arg_0 -> this.lambda$assertUnitPlanWithValidator$9(sql, (List)optimizers, pattern, planValidator, arg_0));
    }

    private Session getSession() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "ALL").build();
    }

    private /* synthetic */ Object lambda$assertUnitPlanWithValidator$9(String sql, List optimizers, PlanMatchPattern pattern, Consumer planValidator, Session transactionSession) {
        Plan actualPlan = this.getQueryRunner().createPlan(transactionSession, sql, optimizers, Optimizer.PlanStage.OPTIMIZED, WarningCollector.NOOP);
        PlanAssert.assertPlan(transactionSession, this.getQueryRunner().getMetadata(), this.getQueryRunner().getStatsCalculator(), actualPlan, pattern);
        planValidator.accept(actualPlan);
        return null;
    }
}

