/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestRandomizeNullKeyInOuterJoin
extends BasePlanTest {
    private Session getSessionAlwaysEnabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("randomize_outer_join_null_key", "true").setSystemProperty("join_distribution_type", "PARTITIONED").build();
    }

    private Session getSessionEnabledWhenJoinKeyFromOuterJoin() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("randomize_outer_join_null_key", "false").setSystemProperty("randomize_outer_join_null_key_strategy", "key_from_outer_join").setSystemProperty("join_distribution_type", "PARTITIONED").build();
    }

    @Test
    public void testLeftJoin() {
        this.assertPlan("SELECT * FROM orders LEFT JOIN lineitem ON orders.orderkey = lineitem.orderkey", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftRandom", "rightRandom")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftCol", (Object)PlanMatchPattern.expression("leftCol"), (Object)"leftRandom", (Object)PlanMatchPattern.expression("coalesce(cast(leftCol as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"leftCol", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightCol", (Object)PlanMatchPattern.expression("rightCol"), (Object)"rightRandom", (Object)PlanMatchPattern.expression("coalesce(cast(rightCol as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"rightCol", (Object)"orderkey")))))), false);
    }

    @Test
    public void testLeftJoinVarchar() {
        this.assertPlan("SELECT * FROM (values '3') t1(k) LEFT JOIN (values '2', '3')t2(k) ON t1.k = t2.k", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftRandom", "rightRandom"), PlanMatchPattern.equiJoinClause("leftIsNull", "rightIsNull")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftCol", (Object)PlanMatchPattern.expression("leftCol"), (Object)"leftRandom", (Object)PlanMatchPattern.expression("coalesce(leftCol, 'l' || cast(random(100) as varchar))"), (Object)"leftIsNull", (Object)PlanMatchPattern.expression("leftCol is NULL")), PlanMatchPattern.values("leftCol"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightCol", (Object)PlanMatchPattern.expression("rightCol"), (Object)"rightRandom", (Object)PlanMatchPattern.expression("coalesce(rightCol, 'r' || cast(random(100) as varchar))"), (Object)"rightIsNull", (Object)PlanMatchPattern.expression("rightCol is NULL")), PlanMatchPattern.values("rightCol"))))), false);
    }

    @Test
    public void testMixedVarcharAndIntKeys() {
        this.assertPlan("SELECT * FROM (values ('3', cast(0 as bigint))) t1(k1, k2) LEFT JOIN (values ('2', cast(1 as bigint)), ('3', 1))t2(k1, k2) ON t1.k1 = t2.k1 and t1.k2 = t2.k2", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftVarcharRandom", "rightVarcharRandom"), PlanMatchPattern.equiJoinClause("leftVarcharIsNull", "rightVarcharIsNull"), PlanMatchPattern.equiJoinClause("leftBigIntRandom", "rightBigIntRandom")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftVarcharRandom", (Object)PlanMatchPattern.expression("coalesce(leftColVarchar, 'l' || cast(random(100) as varchar))"), (Object)"leftVarcharIsNull", (Object)PlanMatchPattern.expression("leftColVarchar is NULL"), (Object)"leftBigIntRandom", (Object)PlanMatchPattern.expression("coalesce(cast(leftColBigInt as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.values("leftColVarchar", "leftColBigInt"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightVarcharRandom", (Object)PlanMatchPattern.expression("coalesce(rightColVarchar, 'r' || cast(random(100) as varchar))"), (Object)"rightVarcharIsNull", (Object)PlanMatchPattern.expression("rightColVarchar is NULL"), (Object)"rightBigIntRandom", (Object)PlanMatchPattern.expression("coalesce(cast(rightColBigInt as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.values("rightColVarchar", "rightColBigInt"))))), false);
    }

    @Test
    public void testRightJoin() {
        this.assertPlan("SELECT * FROM orders RIGHT JOIN lineitem ON orders.orderkey = lineitem.orderkey ", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.RIGHT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftRandom", "rightRandom")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftCol", (Object)PlanMatchPattern.expression("leftCol"), (Object)"leftRandom", (Object)PlanMatchPattern.expression("coalesce(cast(leftCol as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"leftCol", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightCol", (Object)PlanMatchPattern.expression("rightCol"), (Object)"rightRandom", (Object)PlanMatchPattern.expression("coalesce(cast(rightCol as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"rightCol", (Object)"orderkey")))))), false);
    }

    @Test
    public void testLeftJoinOnSameKey() {
        this.assertPlan("select * from partsupp ps left join part p on ps.partkey = p.partkey left join lineitem l on ps.partkey = l.partkey", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey_random", "l_partkey_random")), PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey_random", "p_partkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ps_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(ps_partkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"ps_partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"p_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(p_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"p_partkey", (Object)"partkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_partkey", (Object)"partkey")))))), false);
    }

    @Test
    public void testLeftJoinOnSameKeyJoinAsRightSideInput() {
        this.assertPlan("select * from partsupp ps left join (select p.name, l.orderkey, l.partkey as partkey from part p left join lineitem l on p.partkey = l.partkey) pl on ps.partkey = pl.partkey", Session.builder((Session)this.getSessionAlwaysEnabled()).setSystemProperty("optimize_hash_generation", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey_random", "l_partkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ps_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(ps_partkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"ps_partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("p_partkey_random", "l_partkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"p_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(p_partkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"p_partkey", (Object)"partkey", (Object)"name", (Object)"name")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_partkey", (Object)"partkey", (Object)"orderkey", (Object)"orderkey")))))))), false);
    }

    @Test
    public void testLeftJoinOnDifferentKey() {
        this.assertPlan("select * from part p left join lineitem l on p.partkey = l.partkey left join orders o on l.orderkey = o.orderkey", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l_orderkey_random", "o_orderkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_orderkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_orderkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("p_partkey_random", "l_partkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"p_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(p_partkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"p_partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_partkey", (Object)"partkey", (Object)"l_orderkey", (Object)"orderkey"))))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"o_orderkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(o_orderkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey")))))), false);
    }

    @Test
    public void testLeftJoinOnMixedKey() {
        this.assertPlan("select * from partsupp ps left join part p on ps.partkey = p.partkey left join lineitem l on ps.partkey = l.partkey left join orders o on l.orderkey = o.orderkey", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l_orderkey_random", "o_orderkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_orderkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_orderkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey_random", "l_partkey_random")), PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey_random", "p_partkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ps_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(ps_partkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"ps_partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"p_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(p_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"p_partkey", (Object)"partkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_partkey", (Object)"partkey", (Object)"l_orderkey", (Object)"orderkey"))))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"o_orderkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(o_orderkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey")))))), false);
    }

    @Test
    public void testJoinKeyFromOuterJoin() {
        this.assertPlan("select * from partsupp ps left join part p on ps.partkey = p.partkey left join lineitem l on ps.partkey = l.partkey left join orders o on l.orderkey = o.orderkey", this.getSessionEnabledWhenJoinKeyFromOuterJoin(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l_orderkey_random", "o_orderkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_orderkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(l_orderkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey", "l_partkey")), PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey", "p_partkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"ps_partkey", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"p_partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_partkey", (Object)"partkey", (Object)"l_orderkey", (Object)"orderkey")))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"o_orderkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(o_orderkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey")))))), false);
    }

    @Test
    public void testCrossJoin() {
        this.assertPlan("SELECT * FROM orders CROSS JOIN lineitem", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"leftCol", (Object)"orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"rightCol", (Object)"orderkey"))))), false);
    }

    @Test
    public void testCrossJoinOverLeftJoin() {
        this.assertPlan("select * from partsupp ps left join part p on ps.partkey = p.partkey CROSS JOIN lineitem l", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ps_partkey_random", "p_partkey_random")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ps_partkey", (Object)PlanMatchPattern.expression("ps_partkey"), (Object)"ps_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(ps_partkey as varchar), 'l' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"ps_partkey", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"p_partkey", (Object)PlanMatchPattern.expression("p_partkey"), (Object)"p_partkey_random", (Object)PlanMatchPattern.expression("coalesce(cast(p_partkey as varchar), 'r' || cast(random(100) as varchar))")), PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"p_partkey", (Object)"partkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_partkey", (Object)"partkey"))))), false);
    }
}

