/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.rule.RemoveUnsupportedDynamicFilters;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.sanity.DynamicFiltersChecker;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRemoveUnsupportedDynamicFilters
extends BasePlanTest {
    private Metadata metadata;
    private LogicalRowExpressions logicalRowExpressions;
    private PlanBuilder builder;
    private VariableReferenceExpression lineitemOrderKeyVariable;
    private TableScanNode lineitemTableScanNode;
    private VariableReferenceExpression ordersOrderKeyVariable;
    private TableScanNode ordersTableScanNode;

    @BeforeClass
    public void setup() {
        this.metadata = this.getQueryRunner().getMetadata();
        this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(this.metadata.getFunctionAndTypeManager()), (StandardFunctionResolution)new FunctionResolution(this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()), (FunctionMetadataManager)this.metadata.getFunctionAndTypeManager());
        this.builder = new PlanBuilder(this.getQueryRunner().getDefaultSession(), new PlanNodeIdAllocator(), this.metadata);
        ConnectorId connectorId = this.getCurrentConnectorId();
        TableHandle lineitemTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)new TpchTableHandle("lineitem", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        this.lineitemOrderKeyVariable = this.builder.variable("LINEITEM_OK", (Type)BigintType.BIGINT);
        this.lineitemTableScanNode = this.builder.tableScan(lineitemTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.lineitemOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.lineitemOrderKeyVariable, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT)));
        TableHandle ordersTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)new TpchTableHandle("orders", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        this.ordersOrderKeyVariable = this.builder.variable("ORDERS_OK", (Type)BigintType.BIGINT);
        this.ordersTableScanNode = this.builder.tableScan(ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersOrderKeyVariable, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT)));
    }

    @Test
    public void testUnconsumedDynamicFilterInJoin() {
        JoinNode root = this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter(this.builder.rowExpression("ORDERS_OK > 0"), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(this.ordersOrderKeyVariable, this.lineitemOrderKeyVariable)), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersOrderKeyVariable), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of((Object)"DF", (Object)this.lineitemOrderKeyVariable));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.filter("ORDERS_OK > 0", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))));
    }

    @Test
    public void testDynamicFilterConsumedOnBuildSide() {
        JoinNode root = this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter(PredicatePushDown.createDynamicFilterExpression((String)"DF", (RowExpression)this.ordersOrderKeyVariable, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager()), (PlanNode)this.ordersTableScanNode), (PlanNode)this.builder.filter(PredicatePushDown.createDynamicFilterExpression((String)"DF", (RowExpression)this.ordersOrderKeyVariable, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager()), (PlanNode)this.lineitemTableScanNode), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(this.ordersOrderKeyVariable, this.lineitemOrderKeyVariable)), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersOrderKeyVariable), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of((Object)"DF", (Object)this.lineitemOrderKeyVariable));
        PlanNode planNode = this.removeUnsupportedDynamicFilters((PlanNode)root);
        Assert.assertTrue((boolean)(planNode instanceof JoinNode));
        JoinNode joinNode = (JoinNode)planNode;
        Assert.assertEquals((Map)joinNode.getDynamicFilters(), (Map)ImmutableMap.of((Object)"DF", (Object)this.lineitemOrderKeyVariable));
    }

    @Test
    public void testUnmatchedDynamicFilter() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(this.logicalRowExpressions.combineConjuncts(new RowExpression[]{this.builder.rowExpression("LINEITEM_OK > 0"), PredicatePushDown.createDynamicFilterExpression((String)"DF", (RowExpression)this.lineitemOrderKeyVariable, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager())}), (PlanNode)this.lineitemTableScanNode), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(this.ordersOrderKeyVariable, this.lineitemOrderKeyVariable)), (List<VariableReferenceExpression>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of()));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")), PlanMatchPattern.filter("LINEITEM_OK > 0", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testNestedDynamicFilterDisjunctionRewrite() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(this.logicalRowExpressions.combineConjuncts(new RowExpression[]{this.logicalRowExpressions.combineDisjuncts(new RowExpression[]{this.builder.rowExpression("LINEITEM_OK IS NULL"), PredicatePushDown.createDynamicFilterExpression((String)"DF", (RowExpression)this.lineitemOrderKeyVariable, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager())}), this.logicalRowExpressions.combineDisjuncts(new RowExpression[]{this.builder.rowExpression("LINEITEM_OK IS NOT NULL"), PredicatePushDown.createDynamicFilterExpression((String)"DF", (RowExpression)this.lineitemOrderKeyVariable, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager())})}), (PlanNode)this.lineitemTableScanNode), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(this.ordersOrderKeyVariable, this.lineitemOrderKeyVariable)), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersOrderKeyVariable), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of()));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))));
    }

    @Test
    public void testNestedDynamicFilterConjunctionRewrite() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(this.logicalRowExpressions.combineDisjuncts(new RowExpression[]{this.logicalRowExpressions.combineConjuncts(new RowExpression[]{this.builder.rowExpression("LINEITEM_OK IS NULL"), PredicatePushDown.createDynamicFilterExpression((String)"DF", (RowExpression)this.lineitemOrderKeyVariable, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager())}), this.logicalRowExpressions.combineConjuncts(new RowExpression[]{this.builder.rowExpression("LINEITEM_OK IS NOT NULL"), PredicatePushDown.createDynamicFilterExpression((String)"DF", (RowExpression)this.lineitemOrderKeyVariable, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager())})}), (PlanNode)this.lineitemTableScanNode), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(this.ordersOrderKeyVariable, this.lineitemOrderKeyVariable)), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersOrderKeyVariable), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of()));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")), PlanMatchPattern.filter(ExpressionUtils.combineDisjuncts((Collection)ImmutableList.of((Object)PlanBuilder.expression("LINEITEM_OK IS NULL"), (Object)PlanBuilder.expression("LINEITEM_OK IS NOT NULL"))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))));
    }

    PlanNode removeUnsupportedDynamicFilters(PlanNode root) {
        return (PlanNode)this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            PlanNode rewrittenPlan = new RemoveUnsupportedDynamicFilters(this.metadata.getFunctionAndTypeManager()).optimize(root, session, TypeProvider.empty(), new VariableAllocator(), new PlanNodeIdAllocator(), WarningCollector.NOOP).getPlanNode();
            new DynamicFiltersChecker().validate(rewrittenPlan, session, this.metadata, new SqlParser(), TypeProvider.empty(), WarningCollector.NOOP);
            return rewrittenPlan;
        });
    }

    protected void assertPlan(PlanNode actual, PlanMatchPattern pattern) {
        this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            PlanAssert.assertPlan(session, this.metadata, this.getQueryRunner().getStatsCalculator(), new Plan(actual, this.builder.getTypes(), StatsAndCosts.empty()), pattern);
            return null;
        });
    }
}

