/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.sanity.ValidateStreamingJoins;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestValidateStreamingJoins
extends BasePlanTest {
    private Session testSession;
    private Metadata metadata;
    private SqlParser sqlParser;
    private PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private TableHandle nationTableHandle;
    private TableHandle supplierTableHandle;
    private ColumnHandle nationColumnHandle;
    private ColumnHandle suppColumnHandle;

    @BeforeClass
    public void setup() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny");
        this.testSession = sessionBuilder.build();
        this.metadata = this.getQueryRunner().getMetadata();
        this.sqlParser = this.getQueryRunner().getSqlParser();
        TpchTableHandle nationTpchTableHandle = new TpchTableHandle("nation", 1.0);
        TpchTableHandle supplierTpchTableHandle = new TpchTableHandle("supplier", 1.0);
        ConnectorId connectorId = this.getCurrentConnectorId();
        this.nationTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)nationTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(nationTpchTableHandle, TupleDomain.all())));
        this.supplierTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)supplierTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(supplierTpchTableHandle, TupleDomain.all())));
        this.nationColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.suppColumnHandle = new TpchColumnHandle("suppkey", (Type)BigintType.BIGINT);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.testSession = null;
        this.metadata = null;
        this.sqlParser = null;
        this.idAllocator = null;
        this.nationTableHandle = null;
        this.supplierTableHandle = null;
    }

    @Test
    public void testValidateSuccessful() {
        this.validatePlan(p -> p.join(JoinType.INNER, (PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle)), (PlanNode)p.exchange(e -> e.scope(ExchangeNode.Scope.LOCAL).type(ExchangeNode.Type.REPARTITION).addSource((PlanNode)p.tableScan(this.supplierTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle, (Object)p.variable("suppkey", (Type)BigintType.BIGINT), (Object)this.suppColumnHandle))).addInputsSet((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT))).fixedHashDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT)))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("nationkeyN", (Type)BigintType.BIGINT), p.variable("nationkeyS", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), Optional.empty()));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Build side needs an additional local exchange for join: [0-9]*")
    public void testValidateFailed() {
        this.validatePlan(p -> p.join(JoinType.INNER, (PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle)), (PlanNode)p.tableScan(this.supplierTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle, (Object)p.variable("suppkey", (Type)BigintType.BIGINT), (Object)this.suppColumnHandle)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("nationkeyN", (Type)BigintType.BIGINT), p.variable("nationkeyS", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), Optional.empty()));
    }

    private void validatePlan(Function<PlanBuilder, PlanNode> planProvider) {
        PlanBuilder builder = new PlanBuilder(SessionTestUtils.TEST_SESSION, this.idAllocator, this.metadata);
        PlanNode planNode = planProvider.apply(builder);
        TypeProvider types = builder.getTypes();
        this.getQueryRunner().inTransaction(this.testSession, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new ValidateStreamingJoins().validate(planNode, session, this.metadata, this.sqlParser, types, WarningCollector.NOOP);
            return null;
        });
    }
}

