/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.query;

import com.facebook.presto.sql.query.QueryAssertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestGrouping {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testImplicitCoercions() {
        this.assertions.assertQuery("SELECT GROUPING(k), SUM(v) + 1e0 FROM (VALUES (1, 1)) AS t(k,v) GROUP BY k", "VALUES (0, 2e0)");
        this.assertions.assertQuery("SELECT\n    1e0 * count(*),     grouping(x) FROM (VALUES 1) t(x) GROUP BY GROUPING SETS ((x), ()) ", "VALUES (1e0, 1), (1e0, 0)");
    }

    @Test
    public void testFilter() {
        this.assertions.assertQuery("SELECT a, b, grouping(a, b) FROM (VALUES ('x0', 'y0'), ('x1', 'y1') ) AS t (a, b) GROUP BY CUBE (a, b)HAVING grouping(a, b) = 0", "VALUES ('x0', 'y0', 0), ('x1', 'y1', 0)");
    }
}

