/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.query;

import com.facebook.presto.sql.query.QueryAssertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestUnnest {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testUnnestArrays() {
        this.assertions.assertQuery("SELECT * FROM UNNEST(ARRAY[2, 5])", "VALUES (2), (5)");
        this.assertions.assertQuery("SELECT * FROM UNNEST(ARRAY[2, 5], ARRAY['dog', 'cat', 'bird'])", "VALUES (2, 'dog'), (5, 'cat'), (null, 'bird')");
        this.assertions.assertQuery("SELECT * FROM UNNEST(ARRAY[2, 5, null], ARRAY['dog', 'cat', 'bird'])", "VALUES (2, 'dog'), (5, 'cat'), (null, 'bird')");
    }

    @Test
    public void testUnnestArrayRows() {
        this.assertions.assertQuery("SELECT * FROM UNNEST(ARRAY[ROW(1, 1.1), ROW(3, 3.3)], ARRAY[ROW('a', true), ROW('b', false)])", "VALUES (1, 1.1, 'a', true), (3, 3.3, 'b', false)");
        this.assertions.assertQuery("SELECT * FROM UNNEST(ARRAY[ROW(1, 1.1), ROW(3, 3.3)], ARRAY[ROW('a', true), null])", "VALUES (1, 1.1, 'a', true), (3, 3.3, null, null)");
        this.assertions.assertQuery("SELECT * FROM UNNEST(ARRAY[ROW(1, 1.1), ROW(3, 3.3)], ARRAY[null, ROW('a', true), null])", "VALUES (1, 1.1, null, null), (3, 3.3,  'a', true), (null, null, null, null)");
        this.assertions.assertQuery("SELECT * FROM UNNEST(ARRAY[ROW(1, 1.1), ROW(3, 3.3)], ARRAY[null, ROW(null, true), null])", "VALUES (1, 1.1, null, null), (3, 3.3,  null, true), (null, null, null, null)");
        this.assertions.assertQuery("SELECT x, y FROM (VALUES (ARRAY[ROW(1.0, 2), ROW(3, 4.123)])) AS t(a) CROSS JOIN UNNEST(a) t(x, y)", "VALUES (1.0, 2), (3, 4.123)");
        this.assertions.assertQuery("SELECT x, y, z FROM (VALUES (ARRAY[ROW(1, 2), ROW(3, 4)])) t(a) CROSS JOIN (VALUES (1), (2)) s(z) CROSS JOIN UNNEST(a) t(x, y)", "VALUES (1, 2, 1), (1, 2, 2), (3, 4, 1), (3, 4, 2)");
    }

    @Test
    public void testUnnestPreserveColumnName() {
        this.assertions.assertQuery("SELECT x FROM UNNEST(CAST(ARRAY[ROW(1, 'a'), ROW(2, 'b')] as ARRAY(ROW(x int, y varchar))))", "VALUES (1), (2)");
        this.assertions.assertFails("SELECT x FROM(VALUES (3)) AS t(x)CROSS JOIN UNNEST(CAST(ARRAY[ROW(1, 'a'), ROW(2, 'b')] as ARRAY(ROW(x int, y varchar))))", ".*Column 'x' is ambiguous.*");
        this.assertions.assertQuery("SELECT t.x FROM(VALUES (3)) AS t(x)CROSS JOIN UNNEST(CAST(ARRAY[ROW(1, 'a'), ROW(2, 'b')] as ARRAY(ROW(x int, y varchar))))", "VALUES (3), (3)");
        this.assertions.assertQuery("SELECT u.x FROM(VALUES (3)) AS t(x)CROSS JOIN UNNEST(CAST(ARRAY[ROW(1, 'a'), ROW(2, 'b')] as ARRAY(ROW(x int, y varchar)))) u", "VALUES (1), (2)");
    }

    @Test
    public void testUnnestMultiExpr() {
        this.assertions.assertFails("SELECT x FROM UNNEST(   CAST(ARRAY[ROW(1, 'a'), ROW(2, 'b')] as ARRAY(ROW(x int, y varchar))),   CAST(ARRAY[ROW(1, 'a'), ROW(2, 'b')] as ARRAY(ROW(x int, y varchar))))", ".*Column 'x' is ambiguous.*");
        this.assertions.assertQuery("SELECT t3 FROM UNNEST(   CAST(ARRAY[ROW(1, 'a'), ROW(2, 'b')] as ARRAY(ROW(x int, y varchar))),   CAST(ARRAY[ROW(3, 'c'), ROW(4, 'd')] as ARRAY(ROW(x int, y varchar)))) t(t1,t2,t3,t4)", "VALUES (3), (4)");
        this.assertions.assertQuery("SELECT x FROM UNNEST(   CAST(ARRAY[ROW(1, 'a'), ROW(2, 'b')] as ARRAY(ROW(a int, b varchar))),   CAST(ARRAY[ROW(3, 'c'), ROW(4, 'd')] as ARRAY(ROW(x int, y varchar))))", "VALUES (3), (4)");
    }
}

