/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tdigest;

import com.facebook.presto.tdigest.Centroid;
import com.facebook.presto.tdigest.TDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.distribution.GeometricDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTDigest {
    private static final int NUMBER_OF_ENTRIES = 1000000;
    private static final int STANDARD_COMPRESSION_FACTOR = 100;
    private static final double STANDARD_ERROR = 0.01;
    private static final double[] quantile = new double[]{1.0E-4, 0.02, 0.03, 0.04, 0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.95, 0.96, 0.97, 0.98, 0.9999};
    private static final int TRIMMED_MEAN_COMPRESSION_FACTOR = 200;
    private static final double TRIMMED_MEAN_ERROR_IN_DEVIATIONS = 0.05;

    @Test
    public void testAddElementsInOrder() {
        int i;
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = 0; i < 1000000; ++i) {
            tDigest.add((double)i);
            list.add(i);
        }
        this.assertSumInts(list, tDigest);
        for (i = 0; i < quantile.length; ++i) {
            this.assertDiscreteWithinBound(quantile[i], 0.01, list, tDigest);
        }
    }

    @Test
    public void testMergeTwoDistributionsWithoutOverlap() {
        int i;
        TDigest tDigest1 = TDigest.createTDigest((double)100.0);
        TDigest tDigest2 = TDigest.createTDigest((double)100.0);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = 0; i < 500000; ++i) {
            tDigest1.add((double)i);
            tDigest2.add((double)(i + 500000));
            list.add(i);
            list.add(i + 500000);
        }
        tDigest1.merge(tDigest2);
        this.assertSumInts(list, tDigest1);
        Collections.sort(list);
        for (i = 0; i < quantile.length; ++i) {
            this.assertDiscreteWithinBound(quantile[i], 0.01, list, tDigest1);
        }
    }

    @Test
    public void testMergeTwoDistributionsWithOverlap() {
        int i;
        TDigest tDigest1 = TDigest.createTDigest((double)100.0);
        TDigest tDigest2 = TDigest.createTDigest((double)100.0);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = 0; i < 500000; ++i) {
            tDigest1.add((double)i);
            tDigest2.add((double)i);
            list.add(i);
            list.add(i);
        }
        tDigest2.merge(tDigest1);
        this.assertSumInts(list, tDigest2);
        Collections.sort(list);
        for (i = 0; i < quantile.length; ++i) {
            this.assertDiscreteWithinBound(quantile[i], 0.01, list, tDigest2);
        }
    }

    @Test
    public void testAddElementsRandomized() {
        int i;
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        for (i = 0; i < 1000000; ++i) {
            double value = Math.random() * 1000000.0;
            tDigest.add(value);
            list.add(value);
        }
        this.assertSum(list, tDigest);
        Collections.sort(list);
        for (i = 0; i < quantile.length; ++i) {
            this.assertContinuousWithinBound(quantile[i], 0.01, list, tDigest);
        }
    }

    @Test
    public void testNormalDistributionLowVariance() {
        int i;
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        NormalDistribution normal = new NormalDistribution(1000.0, 1.0);
        for (i = 0; i < 1000000; ++i) {
            double value = normal.sample();
            tDigest.add(value);
            list.add(value);
        }
        this.assertSum(list, tDigest);
        Collections.sort(list);
        for (i = 0; i < quantile.length; ++i) {
            this.assertContinuousWithinBound(quantile[i], 0.01, list, tDigest);
        }
    }

    @Test
    public void testTrimmedMeanUniformDistribution() {
        this.testTrimmedMeanForRealDistribution((RealDistribution)new UniformRealDistribution(0.0, 1000000.0));
    }

    @Test(enabled=false)
    public void testTrimmedMeanNormalDistributionLowVariance() {
        this.testTrimmedMeanForRealDistribution((RealDistribution)new NormalDistribution(1000.0, 1.0));
    }

    @Test(enabled=false)
    public void testTrimmedMeanNormalDistributionHighVariance() {
        this.testTrimmedMeanForRealDistribution((RealDistribution)new NormalDistribution(0.0, 1.0));
    }

    @Test(enabled=false)
    public void testTrimmedMeanPoissonDistribution() {
        int i;
        PoissonDistribution distribution = new PoissonDistribution(1.0);
        TDigest tDigest = TDigest.createTDigest((double)200.0);
        ArrayList<Double> list = new ArrayList<Double>();
        for (i = 0; i < 1000000; ++i) {
            double value = distribution.sample();
            tDigest.add(value);
            list.add(value);
        }
        Collections.sort(list);
        for (i = 0; i < quantile.length; ++i) {
            for (int j = i + 1; j < quantile.length; ++j) {
                this.assertTrimmedMean(quantile[i], quantile[j], Math.sqrt(distribution.getNumericalVariance()), 0.05, list, tDigest);
            }
        }
    }

    @Test
    public void testLargeScalePreservesWeights() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        NormalDistribution normal = new NormalDistribution(1000.0, 100.0);
        for (int i = 0; i < 1000000; ++i) {
            tDigest.add(normal.sample());
        }
        tDigest.scale(4.294967294E9);
        for (Centroid centroid : tDigest.centroids()) {
            Assert.assertTrue((centroid.getWeight() > 2.147483647E9 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNormalDistributionHighVariance() {
        int i;
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        NormalDistribution normal = new NormalDistribution(0.0, 1.0);
        for (i = 0; i < 1000000; ++i) {
            double value = normal.sample();
            tDigest.add(value);
            list.add(value);
        }
        this.assertSum(list, tDigest);
        Collections.sort(list);
        for (i = 0; i < quantile.length; ++i) {
            this.assertContinuousWithinBound(quantile[i], 0.01, list, tDigest);
        }
    }

    @Test
    public void testMergeTwoNormalDistributions() {
        int i;
        TDigest tDigest1 = TDigest.createTDigest((double)100.0);
        TDigest tDigest2 = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        NormalDistribution normal = new NormalDistribution(0.0, 50.0);
        for (i = 0; i < 500000; ++i) {
            double value1 = normal.sample();
            double value2 = normal.sample();
            tDigest1.add(value1);
            tDigest2.add(value2);
            list.add(value1);
            list.add(value2);
        }
        tDigest1.merge(tDigest2);
        this.assertSum(list, tDigest1);
        Collections.sort(list);
        for (i = 0; i < quantile.length; ++i) {
            this.assertContinuousWithinBound(quantile[i], 0.01, list, tDigest1);
        }
    }

    @Test
    public void testMergeManySmallNormalDistributions() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        NormalDistribution normal = new NormalDistribution(500.0, 20.0);
        int digests = 100000;
        for (int k = 0; k < digests; ++k) {
            TDigest current = TDigest.createTDigest((double)100.0);
            for (int i = 0; i < 10; ++i) {
                double value = normal.sample();
                current.add(value);
                list.add(value);
            }
            tDigest.merge(current);
        }
        this.assertSum(list, tDigest);
        Collections.sort(list);
        for (int i = 0; i < quantile.length; ++i) {
            this.assertContinuousWithinBound(quantile[i], 0.01, list, tDigest);
        }
    }

    @Test
    public void testMergeManyLargeNormalDistributions() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        NormalDistribution normal = new NormalDistribution(500.0, 20.0);
        int digests = 1000;
        for (int k = 0; k < digests; ++k) {
            TDigest current = TDigest.createTDigest((double)100.0);
            for (int i = 0; i < 1000000 / digests; ++i) {
                double value = normal.sample();
                current.add(value);
                list.add(value);
            }
            tDigest.merge(current);
        }
        this.assertSum(list, tDigest);
        Collections.sort(list);
        for (int i = 0; i < quantile.length; ++i) {
            this.assertContinuousWithinBound(quantile[i], 0.01, list, tDigest);
        }
    }

    @Test(enabled=false)
    public void testBinomialDistribution() {
        int trials = 10;
        for (int k = 1; k < trials; ++k) {
            int i;
            TDigest tDigest = TDigest.createTDigest((double)100.0);
            BinomialDistribution binomial = new BinomialDistribution(trials, (double)k * 0.1);
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (i = 0; i < 1000000; ++i) {
                int sample = binomial.sample();
                tDigest.add((double)sample);
                list.add(sample);
            }
            this.assertSumInts(list, tDigest);
            Collections.sort(list);
            for (i = 0; i < quantile.length; ++i) {
                this.assertDiscreteWithinBound(quantile[i], 0.01, list, tDigest);
            }
        }
    }

    @Test(enabled=false)
    public void testGeometricDistribution() {
        int trials = 10;
        for (int k = 1; k < trials; ++k) {
            int i;
            TDigest tDigest = TDigest.createTDigest((double)100.0);
            GeometricDistribution geometric = new GeometricDistribution((double)k * 0.1);
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (i = 0; i < 1000000; ++i) {
                int sample = geometric.sample();
                tDigest.add((double)sample);
                list.add(sample);
            }
            this.assertSumInts(list, tDigest);
            Collections.sort(list);
            for (i = 0; i < quantile.length; ++i) {
                this.assertDiscreteWithinBound(quantile[i], 0.01, list, tDigest);
            }
        }
    }

    @Test(enabled=false)
    public void testPoissonDistribution() {
        int trials = 10;
        for (int k = 1; k < trials; ++k) {
            int i;
            TDigest tDigest = TDigest.createTDigest((double)100.0);
            PoissonDistribution poisson = new PoissonDistribution((double)k * 0.1);
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (i = 0; i < 1000000; ++i) {
                int sample = poisson.sample();
                tDigest.add((double)sample);
                list.add(sample);
            }
            this.assertSumInts(list, tDigest);
            Collections.sort(list);
            for (i = 0; i < quantile.length; ++i) {
                this.assertDiscreteWithinBound(quantile[i], 0.01, list, tDigest);
            }
        }
    }

    private void assertContinuousWithinBound(double quantile, double bound, List<Double> values, TDigest tDigest) {
        double lowerBound = quantile - bound;
        double upperBound = quantile + bound;
        lowerBound = lowerBound < 0.0 ? tDigest.getMin() : values.get((int)(1000000.0 * lowerBound)).doubleValue();
        upperBound = upperBound >= 1.0 ? tDigest.getMax() : values.get((int)(1000000.0 * upperBound)).doubleValue();
        Assert.assertTrue((tDigest.getQuantile(quantile) >= lowerBound && tDigest.getQuantile(quantile) <= upperBound ? 1 : 0) != 0, (String)String.format("Value %s is outside bound [%s, %s] for quantile %s", tDigest.getQuantile(quantile), lowerBound, upperBound, quantile));
    }

    private void assertDiscreteWithinBound(double quantile, double bound, List<Integer> values, TDigest tDigest) {
        double lowerBound = quantile - bound;
        double upperBound = quantile + bound;
        lowerBound = lowerBound < 0.0 ? tDigest.getMin() : (double)values.get((int)(1000000.0 * lowerBound)).intValue();
        upperBound = upperBound >= 1.0 ? tDigest.getMax() : (double)values.get((int)(1000000.0 * upperBound)).intValue();
        Assert.assertTrue((Math.rint(tDigest.getQuantile(quantile)) >= lowerBound && Math.rint(tDigest.getQuantile(quantile)) <= upperBound ? 1 : 0) != 0, (String)String.format("Value %s is outside bound [%s, %s] for quantile %s", tDigest.getQuantile(quantile), lowerBound, upperBound, quantile));
    }

    private void assertSumInts(List<Integer> values, TDigest tDigest) {
        this.assertSum(values.stream().map(Double::new).collect(Collectors.toList()), tDigest);
    }

    private void assertSum(List<Double> values, TDigest tDigest) {
        double expectedSum = values.stream().reduce(0.0, Double::sum);
        Assert.assertEquals((double)tDigest.getSum(), (double)expectedSum, (double)1.0E-4);
    }

    private void testTrimmedMeanForRealDistribution(RealDistribution distribution) {
        int i;
        TDigest tDigest = TDigest.createTDigest((double)200.0);
        ArrayList<Double> list = new ArrayList<Double>();
        for (i = 0; i < 1000000; ++i) {
            double value = distribution.sample();
            tDigest.add(value);
            list.add(value);
        }
        Collections.sort(list);
        for (i = 0; i < quantile.length; ++i) {
            for (int j = i + 1; j < quantile.length; ++j) {
                this.assertTrimmedMean(quantile[i], quantile[j], Math.sqrt(distribution.getNumericalVariance()), 0.05, list, tDigest);
            }
        }
    }

    private void assertTrimmedMean(double lowerQuantileBound, double upperQuantileBound, double sd, double sigmaBound, List<Double> values, TDigest tDigest) {
        double expectedMean = values.subList((int)(1000000.0 * lowerQuantileBound), (int)(1000000.0 * upperQuantileBound) + 1).stream().reduce(0.0, Double::sum) / (double)((int)(1000000.0 * upperQuantileBound) - (int)(1000000.0 * lowerQuantileBound) + 1);
        double returnValue = tDigest.trimmedMean(lowerQuantileBound, upperQuantileBound);
        double standardizedError = Math.abs((returnValue - expectedMean) / sd);
        Assert.assertTrue((standardizedError <= sigmaBound ? 1 : 0) != 0, (String)String.format("Returned trimmed mean %s is %s sigma > %s from the actual trimmed mean %s", returnValue, standardizedError, sigmaBound, expectedMean));
    }
}

