/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tracing.testing;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.tracing.TracerHandle;
import com.facebook.presto.tracing.SimpleTracer;
import com.facebook.presto.tracing.SimpleTracerProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSimpleTracer {
    private final SimpleTracerProvider tracerProvider = new SimpleTracerProvider();
    private final ExecutorService executor = Executors.newFixedThreadPool(16, Threads.daemonThreadsNamed((String)"presto-testing-tracer-threadpool"));
    private final Random random = new Random();
    private final int numThreads = 10;

    @Test
    public void testAddPoint() {
        HashMap testHeaders = new HashMap();
        TracerHandle testTracerHandle = (TracerHandle)this.tracerProvider.getHandleGenerator().apply(testHeaders);
        SimpleTracer tracer = (SimpleTracer)this.tracerProvider.getNewTracer(testTracerHandle);
        ArrayList futures = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            CompletableFuture future = new CompletableFuture();
            this.executor.submit(() -> {
                for (int j = 0; j < 20; ++j) {
                    tracer.addPoint("test-point");
                    try {
                        Thread.sleep(this.random.nextInt(5));
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                future.complete(null);
            });
            futures.add(future);
        }
        ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[10])).thenApply(v -> {
            tracer.endTrace("trace ended");
            Assert.assertEquals((int)tracer.pointList.size(), (int)202);
            return null;
        })).join();
    }

    @Test
    public void testAddBlock() {
        HashMap testHeaders = new HashMap();
        TracerHandle testTracerHandle = (TracerHandle)this.tracerProvider.getHandleGenerator().apply(testHeaders);
        SimpleTracer tracer = (SimpleTracer)this.tracerProvider.getNewTracer(testTracerHandle);
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 10) {
            CompletableFuture future = new CompletableFuture();
            int threadNum = i++;
            this.executor.submit(() -> {
                for (int j = 0; j < 20; ++j) {
                    tracer.startBlock("test-block-" + threadNum + "." + j, "");
                    tracer.addPointToBlock("test-block-" + threadNum + "." + j, "point added");
                    try {
                        Thread.sleep(this.random.nextInt(20));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    tracer.endBlock("test-block-" + threadNum + "." + j, "");
                }
                future.complete(null);
            });
            futures.add(future);
        }
        ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[10])).thenApply(v -> {
            tracer.endTrace("trace ended");
            Assert.assertEquals((int)tracer.recorderBlockMap.size(), (int)200);
            return null;
        })).join();
    }

    @Test
    public void testBlockErrors() {
        HashMap testHeaders = new HashMap();
        TracerHandle testTracerHandle = (TracerHandle)this.tracerProvider.getHandleGenerator().apply(testHeaders);
        SimpleTracer tracer = (SimpleTracer)this.tracerProvider.getNewTracer(testTracerHandle);
        PrestoException exception = (PrestoException)Assert.expectThrows(PrestoException.class, () -> {
            tracer.startBlock("test-block", "");
            tracer.startBlock("test-block", "");
        });
        Assert.assertEquals((Object)exception.getErrorCode(), (Object)StandardErrorCode.DISTRIBUTED_TRACING_ERROR.toErrorCode());
        tracer.endBlock("test-block", "");
        exception = (PrestoException)Assert.expectThrows(PrestoException.class, () -> {
            tracer.startBlock("test-block", "");
            tracer.endBlock("test-block-non-existing", "");
        });
        Assert.assertEquals((Object)exception.getErrorCode(), (Object)StandardErrorCode.DISTRIBUTED_TRACING_ERROR.toErrorCode());
        tracer.endBlock("test-block", "");
        exception = (PrestoException)Assert.expectThrows(PrestoException.class, () -> tracer.addPointToBlock("test-block", "Adding point to non-existing block"));
        Assert.assertEquals((Object)exception.getErrorCode(), (Object)StandardErrorCode.DISTRIBUTED_TRACING_ERROR.toErrorCode());
    }
}

