/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.type.TestTimestampWithTimeZoneBase;
import org.testng.annotations.Test;

public class TestTimestampWithTimeZone
extends TestTimestampWithTimeZoneBase {
    public TestTimestampWithTimeZone() {
        super(false);
    }

    @Override
    @Test
    public void testCastToTime() {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321 +07:09' as time)", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.functionAssertions.assertFunctionString("cast(TIMESTAMP '2001-1-22 03:04:05.321 +07:09' as time)", (Type)TimeType.TIME, "03:04:05.321");
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321123 +07:09' as time)", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.functionAssertions.assertFunctionString("cast(TIMESTAMP '2001-1-22 03:04:05.321123 +07:09' as time)", (Type)TimeType.TIME, "03:04:05.321");
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321123456 +07:09' as time)", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.functionAssertions.assertFunctionString("cast(TIMESTAMP '2001-1-22 03:04:05.321123456 +07:09' as time)", (Type)TimeType.TIME, "03:04:05.321");
    }

    @Override
    @Test
    public void testCastToTimeWithTimeZone() {
        super.testCastToTimeWithTimeZone();
        this.functionAssertions.assertFunctionString("cast(TIMESTAMP '2017-06-06 10:00:00.000 Europe/Warsaw' as time with time zone)", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "10:00:00.000 Europe/Warsaw");
        this.functionAssertions.assertFunctionString("cast(TIMESTAMP '2017-06-06 10:00:00.000 Asia/Kathmandu' as time with time zone)", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "10:00:00.000 Asia/Kathmandu");
        this.functionAssertions.assertFunctionString("cast(TIMESTAMP '2017-06-06 10:00:00.000123 Europe/Warsaw' as time with time zone)", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "10:00:00.000 Europe/Warsaw");
        this.functionAssertions.assertFunctionString("cast(TIMESTAMP '2017-06-06 10:00:00.000123 Asia/Kathmandu' as time with time zone)", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "10:00:00.000 Asia/Kathmandu");
        this.functionAssertions.assertFunctionString("cast(TIMESTAMP '2017-06-06 10:00:00.000123456 Europe/Warsaw' as time with time zone)", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "10:00:00.000 Europe/Warsaw");
        this.functionAssertions.assertFunctionString("cast(TIMESTAMP '2017-06-06 10:00:00.000123456 Asia/Kathmandu' as time with time zone)", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "10:00:00.000 Asia/Kathmandu");
    }

    @Override
    @Test
    public void testCastToTimestamp() {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321 +07:09' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321123 +07:09' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321123456 +07:09' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321 Pacific/Bougainville' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321123 Pacific/Bougainville' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321123456 Pacific/Bougainville' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
    }
}

