/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UuidType;
import com.facebook.presto.type.AbstractTestType;
import com.facebook.presto.type.UuidOperators;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestUuidType
extends AbstractTestType {
    public TestUuidType() {
        super((Type)UuidType.UUID, String.class, TestUuidType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = UuidType.UUID.createBlockBuilder(null, 1);
        for (int i = 0; i < 10; ++i) {
            String uuid = "6b5f5b65-67e4-43b0-8ee3-586cd49f58a" + i;
            UuidType.UUID.writeSlice(blockBuilder, UuidOperators.castFromVarcharToUuid((Slice)Slices.utf8Slice((String)uuid)));
        }
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        Slice slice = (Slice)value;
        return Slices.wrappedLongArray((long[])new long[]{slice.getLong(0), slice.getLong(1) + 1L});
    }

    @Override
    protected Object getNonNullValue() {
        return Slices.wrappedLongArray((long[])new long[]{0L, 0L});
    }

    @Test
    public void testDisplayName() {
        Assert.assertEquals((String)UuidType.UUID.getDisplayName(), (String)"uuid");
    }
}

