/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class JoinNodeStatsEstimate {
    private static final JoinNodeStatsEstimate UNKNOWN = new JoinNodeStatsEstimate(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    private final double nullJoinBuildKeyCount;
    private final double joinBuildKeyCount;
    private final double nullJoinProbeKeyCount;
    private final double joinProbeKeyCount;

    @JsonCreator
    public JoinNodeStatsEstimate(@JsonProperty(value="nullJoinBuildKeyCount") double nullJoinBuildKeyCount, @JsonProperty(value="joinBuildKeyCount") double joinBuildKeyCount, @JsonProperty(value="nullJoinProbeKeyCount") double nullJoinProbeKeyCount, @JsonProperty(value="joinProbeKeyCount") double joinProbeKeyCount) {
        this.nullJoinBuildKeyCount = nullJoinBuildKeyCount;
        this.joinBuildKeyCount = joinBuildKeyCount;
        this.nullJoinProbeKeyCount = nullJoinProbeKeyCount;
        this.joinProbeKeyCount = joinProbeKeyCount;
    }

    public static JoinNodeStatsEstimate unknown() {
        return UNKNOWN;
    }

    @JsonProperty
    public double getNullJoinBuildKeyCount() {
        return this.nullJoinBuildKeyCount;
    }

    @JsonProperty
    public double getJoinBuildKeyCount() {
        return this.joinBuildKeyCount;
    }

    @JsonProperty
    public double getNullJoinProbeKeyCount() {
        return this.nullJoinProbeKeyCount;
    }

    @JsonProperty
    public double getJoinProbeKeyCount() {
        return this.joinProbeKeyCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nullJoinBuildKeyCount", this.nullJoinBuildKeyCount).add("joinBuildKeyCount", this.joinBuildKeyCount).add("nullJoinProbeKeyCount", this.nullJoinProbeKeyCount).add("joinProbeKeyCount", this.joinProbeKeyCount).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinNodeStatsEstimate that = (JoinNodeStatsEstimate)o;
        return Double.compare(this.nullJoinBuildKeyCount, that.nullJoinBuildKeyCount) == 0 && Double.compare(this.joinBuildKeyCount, that.joinBuildKeyCount) == 0 && Double.compare(this.nullJoinProbeKeyCount, that.nullJoinProbeKeyCount) == 0 && Double.compare(this.joinProbeKeyCount, that.joinProbeKeyCount) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.nullJoinBuildKeyCount, this.joinBuildKeyCount, this.nullJoinProbeKeyCount, this.joinProbeKeyCount);
    }
}

