/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.presto.Session;
import com.facebook.presto.dispatcher.DispatchExecutor;
import com.facebook.presto.dispatcher.FailedDispatchQuery;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.util.Failures;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;

public class FailedDispatchQueryFactory {
    private final QueryMonitor queryMonitor;
    private final LocationFactory locationFactory;
    private final ExecutorService executor;

    @Inject
    public FailedDispatchQueryFactory(QueryMonitor queryMonitor, LocationFactory locationFactory, DispatchExecutor dispatchExecutor) {
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.executor = Objects.requireNonNull(dispatchExecutor, "dispatchExecutor is null").getExecutor();
    }

    public FailedDispatchQuery createFailedDispatchQuery(Session session, String query, Optional<ResourceGroupId> resourceGroup, Throwable throwable) {
        ExecutionFailureInfo failure = Failures.toFailure(throwable);
        FailedDispatchQuery failedDispatchQuery = new FailedDispatchQuery(session, query, this.locationFactory.createQueryLocation(session.getQueryId()), resourceGroup, failure, this.executor);
        BasicQueryInfo queryInfo = failedDispatchQuery.getBasicQueryInfo();
        this.queryMonitor.queryCreatedEvent(queryInfo);
        this.queryMonitor.queryImmediateFailureEvent(queryInfo, failure);
        return failedDispatchQuery;
    }
}

