/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.dispatcher.DispatchInfo;
import com.facebook.presto.dispatcher.DispatchQuery;
import com.facebook.presto.dispatcher.LocalCoordinatorLocation;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.prerequisites.QueryPrerequisites;
import com.facebook.presto.spi.prerequisites.QueryPrerequisitesContext;
import com.facebook.presto.spi.resourceGroups.ResourceGroupQueryLimits;
import com.facebook.presto.util.Failures;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.joda.time.DateTime;

public class LocalDispatchQuery
implements DispatchQuery {
    private static final Logger log = Logger.get(LocalDispatchQuery.class);
    private final QueryStateMachine stateMachine;
    private final QueryMonitor queryMonitor;
    private final ListenableFuture<QueryExecution> queryExecutionFuture;
    private final ClusterSizeMonitor clusterSizeMonitor;
    private final Executor queryExecutor;
    private final Consumer<DispatchQuery> queryQueuer;
    private final Consumer<QueryExecution> querySubmitter;
    private final SettableFuture<?> submitted = SettableFuture.create();
    private final AtomicReference<Optional<ResourceGroupQueryLimits>> resourceGroupQueryLimits = new AtomicReference(Optional.empty());
    private final boolean retry;
    private final QueryPrerequisites queryPrerequisites;
    private final WarningCollector warningCollector;

    public LocalDispatchQuery(QueryStateMachine stateMachine, QueryMonitor queryMonitor, ListenableFuture<QueryExecution> queryExecutionFuture, ClusterSizeMonitor clusterSizeMonitor, Executor queryExecutor, Consumer<DispatchQuery> queryQueuer, Consumer<QueryExecution> querySubmitter, boolean retry, QueryPrerequisites queryPrerequisites) {
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.queryExecutionFuture = Objects.requireNonNull(queryExecutionFuture, "queryExecutionFuture is null");
        this.clusterSizeMonitor = Objects.requireNonNull(clusterSizeMonitor, "clusterSizeMonitor is null");
        this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
        this.queryQueuer = Objects.requireNonNull(queryQueuer, "queryQueuer is null");
        this.querySubmitter = Objects.requireNonNull(querySubmitter, "querySubmitter is null");
        this.retry = retry;
        this.queryPrerequisites = Objects.requireNonNull(queryPrerequisites, "queryPrerequisites is null");
        this.warningCollector = Objects.requireNonNull(stateMachine.getWarningCollector(), "warningCollector is null");
        MoreFutures.addExceptionCallback(queryExecutionFuture, throwable -> {
            if (stateMachine.transitionToFailed((Throwable)throwable)) {
                queryMonitor.queryImmediateFailureEvent(stateMachine.getBasicQueryInfo(Optional.empty()), Failures.toFailure(throwable));
            }
        });
        stateMachine.addStateChangeListener(state -> {
            if (state.isDone()) {
                this.submitted.set(null);
            }
        });
    }

    @Override
    public void startWaitingForPrerequisites() {
        if (this.isDone()) {
            return;
        }
        try {
            Session session = this.stateMachine.getSession();
            CompletableFuture prerequisitesFuture = this.queryPrerequisites.waitForPrerequisites(this.stateMachine.getQueryId(), new QueryPrerequisitesContext(session.getCatalog(), session.getSchema(), this.stateMachine.getBasicQueryInfo(Optional.empty()).getQuery(), session.getSystemProperties(), session.getConnectorProperties()), this.warningCollector);
            this.addStateChangeListener(state -> {
                if (state.isDone()) {
                    this.queryPrerequisites.queryFinished(this.stateMachine.getQueryId());
                    if (!prerequisitesFuture.isDone()) {
                        prerequisitesFuture.cancel(true);
                    }
                }
            });
            prerequisitesFuture.whenCompleteAsync((result, throwable) -> {
                if (throwable != null) {
                    this.fail((Throwable)throwable);
                    return;
                }
                this.queueQuery();
            }, this.queryExecutor);
        }
        catch (Throwable t) {
            this.fail(t);
            throw t;
        }
    }

    private void queueQuery() {
        if (this.stateMachine.transitionToQueued()) {
            try {
                this.queryQueuer.accept(this);
            }
            catch (Throwable t) {
                this.fail(t);
            }
        }
    }

    @Override
    public void startWaitingForResources() {
        if (this.stateMachine.transitionToWaitingForResources()) {
            this.waitForMinimumWorkers();
        }
    }

    private void waitForMinimumWorkers() {
        ListenableFuture<?> minimumWorkerFuture = this.clusterSizeMonitor.waitForMinimumWorkers();
        MoreFutures.addSuccessCallback(minimumWorkerFuture, () -> {
            boolean isDispatching = this.stateMachine.transitionToDispatching();
            MoreFutures.addSuccessCallback(this.queryExecutionFuture, queryExecution -> this.startExecution((QueryExecution)queryExecution, isDispatching));
        });
        MoreFutures.addExceptionCallback(minimumWorkerFuture, throwable -> this.queryExecutor.execute(() -> this.fail((Throwable)throwable)));
    }

    private void startExecution(QueryExecution queryExecution, boolean isDispatching) {
        this.queryExecutor.execute(() -> {
            if (isDispatching) {
                try {
                    this.resourceGroupQueryLimits.get().ifPresent(queryExecution::setResourceGroupQueryLimits);
                    this.querySubmitter.accept(queryExecution);
                }
                catch (Throwable t) {
                    this.fail(t);
                    log.error(t, "query submitter threw exception");
                    throw t;
                }
                finally {
                    this.submitted.set(null);
                }
            }
        });
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.stateMachine.getLastHeartbeat();
    }

    @Override
    public ListenableFuture<?> getDispatchedFuture() {
        return Futures.nonCancellationPropagating(this.submitted);
    }

    @Override
    public DispatchInfo getDispatchInfo() {
        boolean dispatched = this.submitted.isDone();
        BasicQueryInfo queryInfo = this.stateMachine.getBasicQueryInfo(Optional.empty());
        if (queryInfo.getState() == QueryState.FAILED) {
            ExecutionFailureInfo failureInfo = this.stateMachine.getFailureInfo().orElseGet(() -> Failures.toFailure(new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Query failed for an unknown reason")));
            return DispatchInfo.failed(failureInfo, queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getWaitingForPrerequisitesTime(), queryInfo.getQueryStats().getQueuedTime());
        }
        if (dispatched) {
            return DispatchInfo.dispatched(new LocalCoordinatorLocation(), queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getWaitingForPrerequisitesTime(), queryInfo.getQueryStats().getQueuedTime());
        }
        if (queryInfo.getState() == QueryState.QUEUED) {
            return DispatchInfo.queued(queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getWaitingForPrerequisitesTime(), queryInfo.getQueryStats().getQueuedTime());
        }
        return DispatchInfo.waitingForPrerequisites(queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getWaitingForPrerequisitesTime());
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public boolean isDone() {
        return this.stateMachine.getQueryState().isDone();
    }

    @Override
    public DateTime getCreateTime() {
        return this.stateMachine.getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.stateMachine.getExecutionStartTime();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return this.stateMachine.getEndTime();
    }

    @Override
    public Duration getTotalCpuTime() {
        return this.tryGetQueryExecution().map(QueryExecution::getTotalCpuTime).orElse(new Duration(0.0, TimeUnit.MILLISECONDS));
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        return this.tryGetQueryExecution().map(QueryExecution::getTotalMemoryReservation).orElse(new DataSize(0.0, DataSize.Unit.BYTE));
    }

    @Override
    public DataSize getUserMemoryReservation() {
        return this.tryGetQueryExecution().map(QueryExecution::getUserMemoryReservation).orElse(new DataSize(0.0, DataSize.Unit.BYTE));
    }

    @Override
    public int getRunningTaskCount() {
        return this.stateMachine.getCurrentRunningTaskCount();
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.tryGetQueryExecution().map(QueryExecution::getBasicQueryInfo).orElse(this.stateMachine.getBasicQueryInfo(Optional.empty()));
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public void fail(Throwable throwable) {
        if (this.stateMachine.transitionToFailed(throwable)) {
            this.queryMonitor.queryImmediateFailureEvent(this.stateMachine.getBasicQueryInfo(Optional.empty()), Failures.toFailure(throwable));
        }
    }

    @Override
    public void cancel() {
        if (this.stateMachine.transitionToCanceled()) {
            BasicQueryInfo queryInfo = this.stateMachine.getBasicQueryInfo(Optional.empty());
            ExecutionFailureInfo failureInfo = queryInfo.getFailureInfo();
            failureInfo = failureInfo != null ? failureInfo : Failures.toFailure(new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "Query was canceled"));
            this.queryMonitor.queryImmediateFailureEvent(queryInfo, failureInfo);
        }
    }

    @Override
    public void pruneInfo() {
        this.stateMachine.pruneQueryInfo();
    }

    @Override
    public Optional<ErrorCode> getErrorCode() {
        return this.stateMachine.getFailureInfo().map(ExecutionFailureInfo::getErrorCode);
    }

    @Override
    public boolean isRetry() {
        return this.retry;
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public Optional<ResourceGroupQueryLimits> getResourceGroupQueryLimits() {
        return this.resourceGroupQueryLimits.get();
    }

    @Override
    public void setResourceGroupQueryLimits(ResourceGroupQueryLimits resourceGroupQueryLimits) {
        if (!this.resourceGroupQueryLimits.compareAndSet(Optional.empty(), Optional.of(Objects.requireNonNull(resourceGroupQueryLimits, "resourceGroupQueryLimits is null")))) {
            throw new IllegalStateException("Cannot set resourceGroupQueryLimits more than once");
        }
    }

    private Optional<QueryExecution> tryGetQueryExecution() {
        try {
            return MoreFutures.tryGetFutureValue(this.queryExecutionFuture);
        }
        catch (Throwable ignored) {
            return Optional.empty();
        }
    }
}

