/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.operator.FragmentResultCacheManager;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.planner.CanonicalPlanFragment;
import com.facebook.presto.sql.planner.CanonicalPlanGenerator;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class FragmentResultCacheContext {
    private static final Logger log = Logger.get(FragmentResultCacheContext.class);
    private static final Set<Class<? extends PlanNode>> ALLOWED_CHILDREN_NODES = ImmutableSet.of(TableScanNode.class, FilterNode.class, ProjectNode.class, GroupIdNode.class, UnnestNode.class);
    private final FragmentResultCacheManager fragmentResultCacheManager;
    private final CanonicalPlanFragment canonicalPlanFragment;
    private final String hashedCanonicalPlanFragment;
    private final ObjectMapper objectMapper;

    public static Optional<FragmentResultCacheContext> createFragmentResultCacheContext(FragmentResultCacheManager fragmentResultCacheManager, PlanNode root, PartitioningScheme partitioningScheme, Session session, ObjectMapper objectMapper) {
        if (!SystemSessionProperties.isFragmentResultCachingEnabled(session) || !FragmentResultCacheContext.isEligibleForFragmentResultCaching(root)) {
            return Optional.empty();
        }
        Optional<CanonicalPlanFragment> canonicalPlanFragment = CanonicalPlanGenerator.generateCanonicalPlanFragment(root, partitioningScheme, objectMapper, session);
        if (!canonicalPlanFragment.isPresent()) {
            return Optional.empty();
        }
        String hashedCanonicalPlanFragment = FragmentResultCacheContext.generateHashedCanonicalPlanFragment(canonicalPlanFragment.get(), objectMapper);
        if (hashedCanonicalPlanFragment == null) {
            return Optional.empty();
        }
        return Optional.of(new FragmentResultCacheContext(fragmentResultCacheManager, canonicalPlanFragment.get(), hashedCanonicalPlanFragment, objectMapper));
    }

    private static String generateHashedCanonicalPlanFragment(CanonicalPlanFragment canonicalPlanFragment, ObjectMapper objectMapper) {
        try {
            return Hashing.sha256().hashString((CharSequence)objectMapper.writeValueAsString((Object)canonicalPlanFragment), StandardCharsets.UTF_8).toString();
        }
        catch (JsonProcessingException e) {
            log.warn("Cannot serialize query plan for plan %s", new Object[]{canonicalPlanFragment.getPlan()});
            return null;
        }
    }

    private static boolean isEligibleForFragmentResultCaching(PlanNode root) {
        if (!(root instanceof AggregationNode) || ((AggregationNode)root).getStep() != AggregationNode.Step.PARTIAL) {
            return false;
        }
        return root.getSources().stream().allMatch(FragmentResultCacheContext::containsOnlyAllowedNodesInChildren);
    }

    private static boolean containsOnlyAllowedNodesInChildren(PlanNode node) {
        if (!ALLOWED_CHILDREN_NODES.contains(node.getClass())) {
            return false;
        }
        return node.getSources().stream().allMatch(FragmentResultCacheContext::containsOnlyAllowedNodesInChildren);
    }

    private FragmentResultCacheContext(FragmentResultCacheManager fragmentResultCacheManager, CanonicalPlanFragment canonicalPlanFragment, String hashedCanonicalPlanFragment, ObjectMapper objectMapper) {
        this.fragmentResultCacheManager = Objects.requireNonNull(fragmentResultCacheManager, "fragmentResultCacheManager is null");
        this.canonicalPlanFragment = Objects.requireNonNull(canonicalPlanFragment, "canonicalPlanFragment is null");
        this.hashedCanonicalPlanFragment = Objects.requireNonNull(hashedCanonicalPlanFragment, "hashedCanonicalPlanFragment is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
    }

    public FragmentResultCacheManager getFragmentResultCacheManager() {
        return this.fragmentResultCacheManager;
    }

    public String getHashedCanonicalPlanFragment() {
        return this.hashedCanonicalPlanFragment;
    }

    public FragmentResultCacheContext updateRuntimeInformation(ConnectorSplit split) {
        CanonicalPlanFragment processedContext = this.canonicalPlanFragment.updateRuntimeInformation(split);
        return new FragmentResultCacheContext(this.fragmentResultCacheManager, processedContext, FragmentResultCacheContext.generateHashedCanonicalPlanFragment(processedContext, this.objectMapper), this.objectMapper);
    }
}

