/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.resourceGroups.UpdateablePriorityQueue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

final class IndexedPriorityQueue<E>
implements UpdateablePriorityQueue<E> {
    private final Map<E, Entry<E>> index = new HashMap<E, Entry<E>>();
    private final Set<Entry<E>> queue = new TreeSet<Entry<E>>((entry1, entry2) -> {
        int priorityComparison = Long.compare(entry2.getPriority(), entry1.getPriority());
        if (priorityComparison != 0) {
            return priorityComparison;
        }
        return Long.compare(entry1.getGeneration(), entry2.getGeneration());
    });
    private long generation;

    IndexedPriorityQueue() {
    }

    @Override
    public boolean addOrUpdate(E element, long priority) {
        Entry<E> entry = this.index.get(element);
        if (entry != null) {
            this.queue.remove(entry);
            Entry newEntry = new Entry(element, priority, entry.getGeneration());
            this.queue.add(newEntry);
            this.index.put(element, newEntry);
            return false;
        }
        Entry newEntry = new Entry(element, priority, this.generation);
        ++this.generation;
        this.queue.add(newEntry);
        this.index.put(element, newEntry);
        return true;
    }

    @Override
    public boolean contains(E element) {
        return this.index.containsKey(element);
    }

    @Override
    public boolean remove(E element) {
        Entry<E> entry = this.index.remove(element);
        if (entry != null) {
            this.queue.remove(entry);
            return true;
        }
        return false;
    }

    @Override
    public E poll() {
        Iterator<E> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        E value = iterator.next();
        iterator.remove();
        return value;
    }

    @Override
    public E peek() {
        Iterator<E> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new IndexedPriorityQueueIterator<E>(this.queue, this.index);
    }

    private static class IndexedPriorityQueueIterator<E>
    implements Iterator<E> {
        private final Map<E, Entry<E>> index;
        private final Iterator<E> queueIterator;
        private boolean hasNext;
        private boolean needsNext = true;
        private boolean removeCalled = true;
        private E value;

        public IndexedPriorityQueueIterator(Set<Entry<E>> queue, Map<E, Entry<E>> index) {
            this.index = Objects.requireNonNull(index, "index is null");
            Objects.requireNonNull(queue, "queue is null");
            this.queueIterator = Iterators.transform(queue.iterator(), Entry::getValue);
        }

        @Override
        public boolean hasNext() {
            if (!this.needsNext) {
                return this.hasNext;
            }
            this.hasNext = this.queueIterator.hasNext();
            if (this.hasNext) {
                this.value = this.queueIterator.next();
            }
            this.needsNext = false;
            return this.hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removeCalled = false;
            this.needsNext = true;
            return this.value;
        }

        @Override
        public void remove() {
            if (this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            this.queueIterator.remove();
            Preconditions.checkState((this.index.remove(this.value) != null ? 1 : 0) != 0, (Object)"Failed to remove entry from index");
        }
    }

    private static final class Entry<E> {
        private final E value;
        private final long priority;
        private final long generation;

        private Entry(E value, long priority, long generation) {
            this.value = Objects.requireNonNull(value, "value is null");
            this.priority = priority;
            this.generation = generation;
        }

        public E getValue() {
            return this.value;
        }

        public long getPriority() {
            return this.priority;
        }

        public long getGeneration() {
            return this.generation;
        }
    }
}

