/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.failureDetector;

import com.facebook.airlift.concurrent.ThreadPoolExecutorMBean;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.discovery.client.ServiceDescriptor;
import com.facebook.airlift.discovery.client.ServiceSelector;
import com.facebook.airlift.discovery.client.ServiceType;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.airlift.stats.DecayCounter;
import com.facebook.airlift.stats.ExponentialDecay;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.failureDetector.FailureDetectorConfig;
import com.facebook.presto.failureDetector.ForFailureDetector;
import com.facebook.presto.server.InternalCommunicationConfig;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.util.Failures;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HeartbeatFailureDetector
implements FailureDetector {
    private static final Logger log = Logger.get(HeartbeatFailureDetector.class);
    private final ServiceSelector selector;
    private final HttpClient httpClient;
    private final NodeInfo nodeInfo;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, Threads.daemonThreadsNamed((String)"failure-detector"));
    private final ThreadPoolExecutorMBean executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.executor);
    private final ConcurrentMap<UUID, MonitoringTask> tasks = new ConcurrentHashMap<UUID, MonitoringTask>();
    private final double failureRatioThreshold;
    private final Duration heartbeat;
    private final boolean isEnabled;
    private final Duration warmupInterval;
    private final Duration gcGraceInterval;
    private final int exponentialDecaySeconds;
    private final boolean httpsRequired;
    private final AtomicBoolean started = new AtomicBoolean();

    @Inject
    public HeartbeatFailureDetector(@ServiceType(value="presto") ServiceSelector selector, @ForFailureDetector HttpClient httpClient, FailureDetectorConfig failureDetectorConfig, NodeInfo nodeInfo, InternalCommunicationConfig internalCommunicationConfig) {
        Objects.requireNonNull(selector, "selector is null");
        Objects.requireNonNull(httpClient, "httpClient is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(failureDetectorConfig, "config is null");
        Preconditions.checkArgument((failureDetectorConfig.getHeartbeatInterval().toMillis() >= 1L ? 1 : 0) != 0, (Object)"heartbeat interval must be >= 1ms");
        this.selector = selector;
        this.httpClient = httpClient;
        this.nodeInfo = nodeInfo;
        this.failureRatioThreshold = failureDetectorConfig.getFailureRatioThreshold();
        this.heartbeat = failureDetectorConfig.getHeartbeatInterval();
        this.warmupInterval = failureDetectorConfig.getWarmupInterval();
        this.gcGraceInterval = failureDetectorConfig.getExpirationGraceInterval();
        this.exponentialDecaySeconds = failureDetectorConfig.getExponentialDecaySeconds();
        this.isEnabled = failureDetectorConfig.isEnabled();
        this.httpsRequired = internalCommunicationConfig.isHttpsRequired();
    }

    @PostConstruct
    public void start() {
        if (this.isEnabled && this.started.compareAndSet(false, true)) {
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        HeartbeatFailureDetector.this.updateMonitoredServices();
                    }
                    catch (Throwable e) {
                        log.error(e, "Error updating services");
                    }
                }
            }, 0L, 5L, TimeUnit.SECONDS);
        }
    }

    @PreDestroy
    public void shutdown() {
        this.executor.shutdownNow();
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }

    @Override
    public Set<ServiceDescriptor> getFailed() {
        return (Set)this.tasks.values().stream().filter(MonitoringTask::isFailed).map(MonitoringTask::getService).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public FailureDetector.State getState(HostAddress hostAddress) {
        for (MonitoringTask task : this.tasks.values()) {
            if (!hostAddress.equals((Object)HostAddress.fromUri((URI)task.uri))) continue;
            if (!task.isFailed()) {
                return FailureDetector.State.ALIVE;
            }
            Exception lastFailureException = task.getStats().getLastFailureException();
            if (lastFailureException instanceof ConnectException) {
                return FailureDetector.State.GONE;
            }
            if (lastFailureException instanceof SocketTimeoutException) {
                return FailureDetector.State.UNRESPONSIVE;
            }
            return FailureDetector.State.UNKNOWN;
        }
        return FailureDetector.State.UNKNOWN;
    }

    @Managed(description="Number of failed services")
    public int getFailedCount() {
        return this.getFailed().size();
    }

    @Managed(description="Total number of known services")
    public int getTotalCount() {
        return this.tasks.size();
    }

    @Managed
    public int getActiveCount() {
        return this.tasks.size() - this.getFailed().size();
    }

    public Map<ServiceDescriptor, Stats> getStats() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MonitoringTask task : this.tasks.values()) {
            builder.put((Object)task.getService(), (Object)task.getStats());
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateMonitoredServices() {
        Set online = (Set)this.selector.selectAllServices().stream().filter(descriptor -> !this.nodeInfo.getNodeId().equals(descriptor.getNodeId())).collect(ImmutableSet.toImmutableSet());
        Set onlineIds = (Set)online.stream().map(ServiceDescriptor::getId).collect(ImmutableSet.toImmutableSet());
        ConcurrentMap<UUID, MonitoringTask> concurrentMap = this.tasks;
        synchronized (concurrentMap) {
            List expiredIds = (List)this.tasks.values().stream().filter(MonitoringTask::isExpired).map(MonitoringTask::getService).map(ServiceDescriptor::getId).collect(ImmutableList.toImmutableList());
            this.tasks.keySet().removeAll(expiredIds);
            this.tasks.values().stream().filter(task -> !onlineIds.contains(task.getService().getId())).forEach(MonitoringTask::disable);
            Set newServices = (Set)online.stream().filter(service -> !this.tasks.keySet().contains(service.getId())).collect(ImmutableSet.toImmutableSet());
            for (ServiceDescriptor service2 : newServices) {
                URI uri = this.getHttpUri(service2);
                if (uri == null) continue;
                URI pingURI = HttpUriBuilder.uriBuilderFrom((URI)uri).appendPath("/v1/status").build();
                this.tasks.put(service2.getId(), new MonitoringTask(service2, pingURI));
            }
            this.tasks.values().stream().filter(task -> onlineIds.contains(task.getService().getId())).forEach(MonitoringTask::enable);
        }
    }

    private URI getHttpUri(ServiceDescriptor descriptor) {
        String url = (String)descriptor.getProperties().get(this.httpsRequired ? "https" : "http");
        if (url != null) {
            try {
                return new URI(url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static class Stats {
        private final long start = System.nanoTime();
        private final URI uri;
        private final DecayCounter recentRequests;
        private final DecayCounter recentFailures;
        private final DecayCounter recentSuccesses;
        private final AtomicReference<DateTime> lastRequestTime = new AtomicReference();
        private final AtomicReference<DateTime> lastResponseTime = new AtomicReference();
        private final AtomicReference<Exception> lastFailureException = new AtomicReference();
        @GuardedBy(value="this")
        private final Map<Class<? extends Throwable>, DecayCounter> failureCountByType = new HashMap<Class<? extends Throwable>, DecayCounter>();

        public Stats(URI uri, int exponentialDecaySeconds) {
            this.uri = uri;
            this.recentRequests = new DecayCounter(ExponentialDecay.seconds((int)exponentialDecaySeconds));
            this.recentFailures = new DecayCounter(ExponentialDecay.seconds((int)exponentialDecaySeconds));
            this.recentSuccesses = new DecayCounter(ExponentialDecay.seconds((int)exponentialDecaySeconds));
        }

        public void recordStart() {
            this.recentRequests.add(1L);
            this.lastRequestTime.set(new DateTime());
        }

        public void recordSuccess() {
            this.recentSuccesses.add(1L);
            this.lastResponseTime.set(new DateTime());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recordFailure(Exception exception) {
            this.recentFailures.add(1L);
            this.lastResponseTime.set(new DateTime());
            this.lastFailureException.set(exception);
            Throwable cause = exception;
            while (cause.getClass() == RuntimeException.class && cause.getCause() != null) {
                cause = cause.getCause();
            }
            Stats stats = this;
            synchronized (stats) {
                DecayCounter counter = this.failureCountByType.get(cause.getClass());
                if (counter == null) {
                    counter = new DecayCounter(ExponentialDecay.oneMinute());
                    this.failureCountByType.put(cause.getClass(), counter);
                }
                counter.add(1L);
            }
        }

        @JsonProperty
        public Duration getAge() {
            return Duration.nanosSince((long)this.start);
        }

        @JsonProperty
        public URI getUri() {
            return this.uri;
        }

        @JsonProperty
        public double getRecentFailures() {
            return this.recentFailures.getCount();
        }

        @JsonProperty
        public double getRecentSuccesses() {
            return this.recentSuccesses.getCount();
        }

        @JsonProperty
        public double getRecentRequests() {
            return this.recentRequests.getCount();
        }

        @JsonProperty
        public double getRecentFailureRatio() {
            return this.recentFailures.getCount() / this.recentRequests.getCount();
        }

        @JsonProperty
        public DateTime getLastRequestTime() {
            return this.lastRequestTime.get();
        }

        @JsonProperty
        public DateTime getLastResponseTime() {
            return this.lastResponseTime.get();
        }

        @JsonIgnore
        public Exception getLastFailureException() {
            return this.lastFailureException.get();
        }

        @Nullable
        @JsonProperty
        public FailureInfo getLastFailureInfo() {
            Exception lastFailureException = this.getLastFailureException();
            if (lastFailureException == null) {
                return null;
            }
            return Failures.toFailure(lastFailureException).toFailureInfo();
        }

        @JsonProperty
        public synchronized Map<String, Double> getRecentFailuresByType() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<Class<? extends Throwable>, DecayCounter> entry : this.failureCountByType.entrySet()) {
                builder.put((Object)entry.getKey().getName(), (Object)entry.getValue().getCount());
            }
            return builder.build();
        }
    }

    @ThreadSafe
    private class MonitoringTask {
        private final ServiceDescriptor service;
        private final URI uri;
        private final Stats stats;
        @GuardedBy(value="this")
        private ScheduledFuture<?> future;
        @GuardedBy(value="this")
        private Long disabledTimestamp;
        @GuardedBy(value="this")
        private Long successTransitionTimestamp;

        private MonitoringTask(ServiceDescriptor service, URI uri) {
            this.uri = uri;
            this.service = service;
            this.stats = new Stats(uri, HeartbeatFailureDetector.this.exponentialDecaySeconds);
        }

        public Stats getStats() {
            return this.stats;
        }

        public ServiceDescriptor getService() {
            return this.service;
        }

        public synchronized void enable() {
            if (this.future == null) {
                this.future = HeartbeatFailureDetector.this.executor.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MonitoringTask.this.ping();
                            MonitoringTask.this.updateState();
                        }
                        catch (Throwable e) {
                            log.error(e, "Error pinging service %s (%s)", new Object[]{MonitoringTask.this.service.getId(), MonitoringTask.this.uri});
                        }
                    }
                }, HeartbeatFailureDetector.this.heartbeat.toMillis(), HeartbeatFailureDetector.this.heartbeat.toMillis(), TimeUnit.MILLISECONDS);
                this.disabledTimestamp = null;
            }
        }

        public synchronized void disable() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
                this.disabledTimestamp = System.nanoTime();
            }
        }

        public synchronized boolean isExpired() {
            return this.future == null && this.disabledTimestamp != null && Duration.nanosSince((long)this.disabledTimestamp).compareTo(HeartbeatFailureDetector.this.gcGraceInterval) > 0;
        }

        public synchronized boolean isFailed() {
            return this.future == null || this.successTransitionTimestamp == null || Duration.nanosSince((long)this.successTransitionTimestamp).compareTo(HeartbeatFailureDetector.this.warmupInterval) < 0;
        }

        private void ping() {
            try {
                this.stats.recordStart();
                HeartbeatFailureDetector.this.httpClient.executeAsync(Request.Builder.prepareHead().setUri(this.uri).build(), (ResponseHandler)new ResponseHandler<Object, Exception>(){

                    public Exception handleException(Request request, Exception exception) {
                        MonitoringTask.this.stats.recordFailure(exception);
                        return null;
                    }

                    public Object handle(Request request, Response response) {
                        MonitoringTask.this.stats.recordSuccess();
                        return null;
                    }
                });
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Error scheduling request for %s", new Object[]{this.uri});
            }
        }

        private synchronized void updateState() {
            if (this.stats.getRecentFailureRatio() > HeartbeatFailureDetector.this.failureRatioThreshold) {
                this.successTransitionTimestamp = null;
            } else if (this.successTransitionTimestamp == null) {
                this.successTransitionTimestamp = System.nanoTime();
            }
        }
    }
}

