/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.ThreadPoolExecutorMBean;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.drift.client.DriftClient;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientConfig;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.ForExchange;
import com.facebook.presto.server.thrift.ThriftTaskClient;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ExchangeClientFactory
implements ExchangeClientSupplier {
    private final DataSize maxBufferedBytes;
    private final int concurrentRequestMultiplier;
    private final Duration maxErrorDuration;
    private final HttpClient httpClient;
    private final DriftClient<ThriftTaskClient> driftClient;
    private final DataSize maxResponseSize;
    private final boolean acknowledgePages;
    private final double responseSizeExponentialMovingAverageDecayingAlpha;
    private final ScheduledExecutorService scheduler;
    private final ThreadPoolExecutorMBean executorMBean;
    private final ExecutorService pageBufferClientCallbackExecutor;

    @Inject
    public ExchangeClientFactory(ExchangeClientConfig config, @ForExchange HttpClient httpClient, @ForExchange DriftClient<ThriftTaskClient> driftClient, @ForExchange ScheduledExecutorService scheduler) {
        this(config.getMaxBufferSize(), config.getMaxResponseSize(), config.getConcurrentRequestMultiplier(), config.getMaxErrorDuration(), config.isAcknowledgePages(), config.getPageBufferClientMaxCallbackThreads(), config.getResponseSizeExponentialMovingAverageDecayingAlpha(), httpClient, driftClient, scheduler);
    }

    public ExchangeClientFactory(DataSize maxBufferedBytes, DataSize maxResponseSize, int concurrentRequestMultiplier, Duration maxErrorDuration, boolean acknowledgePages, int pageBufferClientMaxCallbackThreads, double responseSizeExponentialMovingAverageDecayingAlpha, HttpClient httpClient, DriftClient<ThriftTaskClient> driftClient, ScheduledExecutorService scheduler) {
        this.maxBufferedBytes = Objects.requireNonNull(maxBufferedBytes, "maxBufferedBytes is null");
        this.concurrentRequestMultiplier = concurrentRequestMultiplier;
        this.maxErrorDuration = Objects.requireNonNull(maxErrorDuration, "maxErrorDuration is null");
        this.acknowledgePages = acknowledgePages;
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.driftClient = Objects.requireNonNull(driftClient, "driftClient is null");
        Objects.requireNonNull(maxResponseSize, "maxResponseSize is null");
        long maxResponseSizeBytes = (long)((double)Math.min(httpClient.getMaxContentLength(), maxResponseSize.toBytes()) * 0.75);
        this.maxResponseSize = new DataSize((double)maxResponseSizeBytes, DataSize.Unit.BYTE);
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler is null");
        this.pageBufferClientCallbackExecutor = Executors.newFixedThreadPool(pageBufferClientMaxCallbackThreads, Threads.daemonThreadsNamed((String)"page-buffer-client-callback-%s"));
        this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.pageBufferClientCallbackExecutor);
        this.responseSizeExponentialMovingAverageDecayingAlpha = responseSizeExponentialMovingAverageDecayingAlpha;
        Preconditions.checkArgument((maxBufferedBytes.toBytes() > 0L ? 1 : 0) != 0, (String)"maxBufferSize must be at least 1 byte: %s", (Object)maxBufferedBytes);
        Preconditions.checkArgument((maxResponseSize.toBytes() > 0L ? 1 : 0) != 0, (String)"maxResponseSize must be at least 1 byte: %s", (Object)maxResponseSize);
        Preconditions.checkArgument((concurrentRequestMultiplier > 0 ? 1 : 0) != 0, (String)"concurrentRequestMultiplier must be at least 1: %s", (int)concurrentRequestMultiplier);
        Preconditions.checkArgument((responseSizeExponentialMovingAverageDecayingAlpha >= 0.0 && responseSizeExponentialMovingAverageDecayingAlpha <= 1.0 ? 1 : 0) != 0, (String)"responseSizeExponentialMovingAverageDecayingAlpha must be between 0 and 1: %s", (Object)responseSizeExponentialMovingAverageDecayingAlpha);
    }

    @PreDestroy
    public void stop() {
        this.pageBufferClientCallbackExecutor.shutdownNow();
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }

    @Override
    public ExchangeClient get(LocalMemoryContext systemMemoryContext) {
        return new ExchangeClient(this.maxBufferedBytes, this.maxResponseSize, this.concurrentRequestMultiplier, this.maxErrorDuration, this.acknowledgePages, this.responseSizeExponentialMovingAverageDecayingAlpha, this.httpClient, this.driftClient, this.scheduler, systemMemoryContext, this.pageBufferClientCallbackExecutor);
    }
}

