/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.state.ReduceAggregationState;
import com.facebook.presto.operator.aggregation.state.ReduceAggregationStateFactory;
import com.facebook.presto.operator.aggregation.state.ReduceAggregationStateSerializer;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.sql.gen.lambda.BinaryFunctionInterface;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ReduceAggregationFunction
extends SqlAggregationFunction {
    private static final String NAME = "reduce_agg";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "input", Type.class, ReduceAggregationState.class, Object.class, Object.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "combine", ReduceAggregationState.class, ReduceAggregationState.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "write", Type.class, ReduceAggregationState.class, BlockBuilder.class);
    private final boolean supportsComplexTypes;

    public ReduceAggregationFunction(boolean supportsComplexTypes) {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T"), (Object)Signature.typeVariable((String)"S")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"S"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T"), (Object)TypeSignature.parseTypeSignature((String)"S"), (Object)TypeSignature.parseTypeSignature((String)"function(S,T,S)"), (Object)TypeSignature.parseTypeSignature((String)"function(S,S,S)")));
        this.supportsComplexTypes = supportsComplexTypes;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    public String getDescription() {
        return "Reduce input elements into a single value";
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type inputType = boundVariables.getTypeVariable("T");
        Type stateType = boundVariables.getTypeVariable("S");
        return this.generateAggregation(inputType, stateType);
    }

    private BuiltInAggregationFunctionImplementation generateAggregation(Type inputType, Type stateType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(ReduceAggregationFunction.class.getClassLoader());
        if (!this.supportsComplexTypes && stateType.getJavaType() != Long.TYPE && stateType.getJavaType() != Double.TYPE && stateType.getJavaType() != Boolean.TYPE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("State type not enabled for %s: %s", NAME, stateType.getDisplayName()));
        }
        MethodHandle inputMethodHandle = INPUT_FUNCTION.bindTo(inputType);
        MethodHandle combineMethodHandle = COMBINE_FUNCTION;
        MethodHandle outputMethodHandle = OUTPUT_FUNCTION.bindTo(stateType);
        AggregationMetadata.AccumulatorStateDescriptor stateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor(ReduceAggregationState.class, (AccumulatorStateSerializer)new ReduceAggregationStateSerializer(stateType), (AccumulatorStateFactory)new ReduceAggregationStateFactory());
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(this.getSignature().getNameSuffix(), inputType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)inputType.getTypeSignature())), ReduceAggregationFunction.createInputParameterMetadata(inputType, stateType), inputMethodHandle.asType(inputMethodHandle.type().changeParameterType(1, inputType.getJavaType()).changeParameterType(2, stateType.getJavaType())), combineMethodHandle, outputMethodHandle, (List)ImmutableList.of((Object)stateDescriptor), stateType, (List)ImmutableList.of(BinaryFunctionInterface.class, BinaryFunctionInterface.class));
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(this.getSignature().getNameSuffix(), (List<Type>)ImmutableList.of((Object)inputType), (List<Type>)ImmutableList.of((Object)stateType), stateType, true, false, metadata, accumulatorClass, groupedAccumulatorClass, (List<Class>)ImmutableList.of(BinaryFunctionInterface.class, BinaryFunctionInterface.class));
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type inputType, Type stateType) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, inputType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, stateType));
    }

    public static void input(Type type, ReduceAggregationState state, Object value, Object initialStateValue, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.getValue() == null) {
            state.setValue(initialStateValue);
        }
        try {
            state.setValue(inputFunction.apply(state.getValue(), value));
        }
        catch (NullPointerException npe) {
            state.setValue(null);
        }
    }

    public static void combine(ReduceAggregationState state, ReduceAggregationState otherState, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.getValue() == null) {
            state.setValue(otherState.getValue());
            return;
        }
        try {
            state.setValue(combineFunction.apply(state.getValue(), otherState.getValue()));
        }
        catch (NullPointerException npe) {
            state.setValue(null);
        }
    }

    public static void write(Type type, ReduceAggregationState state, BlockBuilder blockBuilder) {
        if (state.getValue() == null) {
            blockBuilder.appendNull();
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, ((Long)state.getValue()).longValue());
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Double)state.getValue()).doubleValue());
        } else if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, ((Boolean)state.getValue()).booleanValue());
        } else if (type.getJavaType() == Block.class) {
            type.writeObject(blockBuilder, state.getValue());
        } else {
            type.writeSlice(blockBuilder, (Slice)state.getValue());
        }
    }
}

