/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation.sketch;

import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.RandomizationStrategy;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceInput;
import java.util.BitSet;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class Bitmap {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Bitmap.class).instanceSize();
    private static final int BITSET_INSTANCE_SIZE = ClassLayout.parseClass(BitSet.class).instanceSize();
    private final BitSet bitSet;
    private final int length;

    public Bitmap(int length) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"length must be positive");
        this.bitSet = new BitSet(length);
        this.length = length;
    }

    private Bitmap(int length, BitSet bitSet) {
        Objects.requireNonNull(bitSet, "bitSet cannot be null");
        Preconditions.checkArgument((length >= bitSet.length() ? 1 : 0) != 0, (Object)"bitmap size must be large enough to cover existing bits");
        this.bitSet = bitSet;
        this.length = length;
    }

    public static Bitmap fromBytes(int length, byte[] bytes) {
        return new Bitmap(length, BitSet.valueOf(bytes));
    }

    public static Bitmap fromSliceInput(SliceInput input, int byteCount, int length) {
        Preconditions.checkArgument((byteCount >= 0 ? 1 : 0) != 0, (Object)"byteCount must be nonnegative");
        if (byteCount == 0) {
            return new Bitmap(length);
        }
        byte[] bytes = new byte[byteCount];
        input.readBytes(bytes);
        return Bitmap.fromBytes(length, bytes);
    }

    public byte[] toBytes() {
        return this.bitSet.toByteArray();
    }

    public int byteLength() {
        return (this.bitSet.length() + 7) / 8;
    }

    public Bitmap clone() {
        return Bitmap.fromBytes(this.length, this.bitSet.toByteArray());
    }

    public long getRetainedSizeInBytes() {
        return (long)(INSTANCE_SIZE + BITSET_INSTANCE_SIZE) + SizeOf.sizeOfLongArray((int)(this.bitSet.size() / 64));
    }

    public boolean getBit(int position) {
        return this.bitSet.get(position);
    }

    public int getBitCount() {
        return this.bitSet.cardinality();
    }

    public void flipAll(double probability, RandomizationStrategy randomizationStrategy) {
        for (int i = 0; i < this.length; ++i) {
            this.flipBit(i, probability, randomizationStrategy);
        }
    }

    public void flipBit(int position) {
        this.bitSet.flip(position);
    }

    public void flipBit(int position, double probability, RandomizationStrategy randomizationStrategy) {
        if (randomizationStrategy.nextBoolean(probability)) {
            this.flipBit(position);
        }
    }

    public int length() {
        return this.length;
    }

    public void setBit(int position, boolean value) {
        this.bitSet.set(position, value);
    }

    public void or(Bitmap other) {
        Objects.requireNonNull(other, "cannot combine with null Bitmap");
        Preconditions.checkArgument((this.length() == other.length() ? 1 : 0) != 0, (Object)"cannot OR two bitmaps of different size");
        this.bitSet.or(other.bitSet);
    }

    public void xor(Bitmap other) {
        Objects.requireNonNull(other, "cannot combine with null Bitmap");
        Preconditions.checkArgument((this.length() == other.length() ? 1 : 0) != 0, (Object)"cannot XOR two bitmaps of different size");
        this.bitSet.xor(other.bitSet);
    }
}

