/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.partial;

import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.OptionalLong;

public class PartialAggregationController {
    private static final double DISABLE_AGGREGATION_BUFFER_SIZE_TO_INPUT_BYTES_RATIO = 1.5;
    private static final double ENABLE_AGGREGATION_BUFFER_SIZE_TO_INPUT_BYTES_RATIO = 300.0;
    private final DataSize maxPartialAggregationMemorySize;
    private final double uniqueRowsRatioThreshold;
    private volatile boolean partialAggregationDisabled;
    private long totalBytesProcessed;
    private long totalRowsProcessed;
    private long totalUniqueRowsProduced;

    public PartialAggregationController(DataSize maxPartialAggregationMemorySize, double uniqueRowsRatioThreshold) {
        this.maxPartialAggregationMemorySize = Objects.requireNonNull(maxPartialAggregationMemorySize, "maxPartialMemory is null");
        this.uniqueRowsRatioThreshold = uniqueRowsRatioThreshold;
    }

    public boolean isPartialAggregationDisabled() {
        return this.partialAggregationDisabled;
    }

    public synchronized void onFlush(long bytesProcessed, long rowsProcessed, OptionalLong uniqueRowsProduced) {
        if (!this.partialAggregationDisabled && !uniqueRowsProduced.isPresent()) {
            return;
        }
        this.totalBytesProcessed += bytesProcessed;
        this.totalRowsProcessed += rowsProcessed;
        uniqueRowsProduced.ifPresent(value -> this.totalUniqueRowsProduced += value);
        if (!this.partialAggregationDisabled && this.shouldDisablePartialAggregation()) {
            this.partialAggregationDisabled = true;
        }
        if (this.partialAggregationDisabled && (double)this.totalBytesProcessed >= (double)this.maxPartialAggregationMemorySize.toBytes() * 300.0) {
            this.totalBytesProcessed = 0L;
            this.totalRowsProcessed = 0L;
            this.totalUniqueRowsProduced = 0L;
            this.partialAggregationDisabled = false;
        }
    }

    private boolean shouldDisablePartialAggregation() {
        return (double)this.totalBytesProcessed >= (double)this.maxPartialAggregationMemorySize.toBytes() * 1.5 && (double)this.totalUniqueRowsProduced / (double)this.totalRowsProcessed > this.uniqueRowsRatioThreshold;
    }

    public PartialAggregationController duplicate() {
        return new PartialAggregationController(this.maxPartialAggregationMemorySize, this.uniqueRowsRatioThreshold);
    }
}

