/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.sketch.kll;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.sketch.kll.KllSketchAggregationState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Comparator;
import java.util.function.Supplier;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.kll.KllItemsSketch;

@AggregationFunction(value="sketch_kll_with_k")
public class KllSketchWithKAggregationFunction {
    private KllSketchWithKAggregationFunction() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState KllSketchAggregationState state, @SqlType(value="T") long value, @SqlType(value="bigint") long k) {
        KllSketchWithKAggregationFunction.initializeSketch(state, () -> Long::compareTo, ArrayOfLongsSerDe::new, k);
        KllItemsSketch sketch = state.getSketch();
        state.addMemoryUsage(-KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Long.TYPE));
        state.getSketch().update((Object)value);
        state.addMemoryUsage(KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Long.TYPE));
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState KllSketchAggregationState state, @SqlType(value="T") double value, @SqlType(value="bigint") long k) {
        KllSketchWithKAggregationFunction.initializeSketch(state, () -> Double::compareTo, ArrayOfDoublesSerDe::new, k);
        KllItemsSketch sketch = state.getSketch();
        state.addMemoryUsage(-KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Double.TYPE));
        state.getSketch().update((Object)value);
        state.addMemoryUsage(KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Double.TYPE));
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState KllSketchAggregationState state, @SqlType(value="T") Slice value, @SqlType(value="bigint") long k) {
        KllSketchWithKAggregationFunction.initializeSketch(state, () -> String::compareTo, ArrayOfStringsSerDe::new, k);
        KllItemsSketch sketch = state.getSketch();
        state.addMemoryUsage(-KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Slice.class));
        state.getSketch().update((Object)value.toStringUtf8());
        state.addMemoryUsage(KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Slice.class));
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState KllSketchAggregationState state, @SqlType(value="T") boolean value, @SqlType(value="bigint") long k) {
        KllSketchWithKAggregationFunction.initializeSketch(state, () -> Boolean::compareTo, ArrayOfBooleansSerDe::new, k);
        KllItemsSketch sketch = state.getSketch();
        state.addMemoryUsage(-KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Boolean.TYPE));
        state.getSketch().update((Object)value);
        state.addMemoryUsage(KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Boolean.TYPE));
    }

    @CombineFunction
    public static void combine(@AggregationState KllSketchAggregationState state, @AggregationState KllSketchAggregationState otherState) {
        if (state.getSketch() != null && otherState.getSketch() != null) {
            state.addMemoryUsage(-KllSketchAggregationState.getEstimatedKllInMemorySize(state.getSketch(), state.getType().getJavaType()));
            state.getSketch().merge(otherState.getSketch());
            state.addMemoryUsage(KllSketchAggregationState.getEstimatedKllInMemorySize(state.getSketch(), state.getType().getJavaType()));
        } else if (state.getSketch() == null) {
            state.setSketch(otherState.getSketch());
            state.addMemoryUsage(KllSketchAggregationState.getEstimatedKllInMemorySize(otherState.getSketch(), state.getType().getJavaType()));
        }
    }

    @TypeParameter(value="T")
    @OutputFunction(value="kllsketch(T)")
    public static void output(@AggregationState KllSketchAggregationState state, BlockBuilder out) {
        if (state.getSketch() == null) {
            out.appendNull();
            return;
        }
        VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedBuffer((byte[])state.getSketch().toByteArray()));
    }

    private static <T> void initializeSketch(KllSketchAggregationState state, Supplier<Comparator<T>> comparator, Supplier<ArrayOfItemsSerDe<T>> serdeSupplier, long k) {
        if (k < 8L || k > 65535L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("k value must satisfy 8 <= k <= %d: %d", 65535, k));
        }
        if (state.getSketch() == null) {
            KllItemsSketch sketch = KllItemsSketch.newHeapInstance((int)((int)k), comparator.get(), serdeSupplier.get());
            state.setSketch(sketch);
            state.addMemoryUsage(KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, state.getType().getJavaType()));
        }
    }
}

