/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.annotations;

import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.operator.annotations.ScalarImplementationDependency;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.InvocationConvention;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class FunctionImplementationDependency
extends ScalarImplementationDependency {
    private final String name;
    private final List<TypeSignature> argumentTypes;

    public FunctionImplementationDependency(String name, List<TypeSignature> argumentTypes, Optional<InvocationConvention> invocationConvention) {
        super(invocationConvention);
        this.name = Objects.requireNonNull(name, "name is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    @Override
    protected FunctionHandle getFunctionHandle(BoundVariables boundVariables, FunctionAndTypeManager functionAndTypeManager) {
        return functionAndTypeManager.lookupFunction(this.name, TypeSignatureProvider.fromTypeSignatures(SignatureBinder.applyBoundVariables(this.argumentTypes, boundVariables)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionImplementationDependency that = (FunctionImplementationDependency)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.argumentTypes);
    }
}

