/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;

@ScalarFunction(value="trim_array")
@Description(value="Remove elements from the end of array")
public final class ArrayTrimFunction {
    private ArrayTrimFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block trim(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long size) {
        Failures.checkCondition(size >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "size must not be negative: %s", size);
        Failures.checkCondition(size <= (long)array.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "size must not exceed array cardinality %s: %s", array.getPositionCount(), size);
        return array.getRegion(0, Math.toIntExact((long)array.getPositionCount() - size));
    }
}

