/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.queryplan;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecFactory;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.Serialization;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.planPrinter.JsonRenderer;
import com.facebook.presto.testing.TestingEnvironment;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Provider;

public final class JsonPrestoQueryPlanFunctions {
    private JsonPrestoQueryPlanFunctions() {
    }

    @Description(value="Get the plan ids of given plan node")
    @ScalarFunction(value="json_presto_query_plan_ids")
    @SqlType(value="ARRAY<VARCHAR>")
    @SqlNullable
    public static Block jsonPlanIds(@TypeParameter(value="ARRAY<VARCHAR>") ArrayType arrayType, @SqlType(value="json") Slice jsonPlan) {
        List<JsonRenderer.JsonRenderedNode> planFragments = JsonPrestoQueryPlanFunctions.parseJsonPlanFragmentsAsList(jsonPlan);
        if (planFragments == null) {
            return null;
        }
        Map<String, List<String>> planMap = JsonPrestoQueryPlanFunctions.extractPlanIds(planFragments);
        return JsonPrestoQueryPlanFunctions.constructSqlArray(arrayType, planMap.keySet().stream().collect(Collectors.toList()));
    }

    @Description(value="Get the plan ids of given plan node")
    @ScalarFunction(value="json_presto_query_plan_node_children")
    @SqlType(value="ARRAY<VARCHAR>")
    @SqlNullable
    public static Block jsonPlanNodeChildren(@TypeParameter(value="ARRAY<VARCHAR>") ArrayType arrayType, @SqlType(value="json") Slice jsonPlan, @SqlType(value="varchar") Slice planId) {
        List<JsonRenderer.JsonRenderedNode> planFragments = JsonPrestoQueryPlanFunctions.parseJsonPlanFragmentsAsList(jsonPlan);
        if (planFragments == null) {
            return null;
        }
        Map<String, List<String>> planMap = JsonPrestoQueryPlanFunctions.extractPlanIds(planFragments);
        List<String> planChildren = planMap.get(planId.toStringUtf8());
        if (planChildren == null) {
            return null;
        }
        return JsonPrestoQueryPlanFunctions.constructSqlArray(arrayType, planChildren);
    }

    @Description(value="Scrub runtime information such as plan estimates and variable names from the query plan, leaving the structure of the plan intact")
    @ScalarFunction(value="json_presto_query_plan_scrub")
    @SqlType(value="json")
    @SqlNullable
    public static Slice jsonScrubPlan(@SqlType(value="json") Slice jsonPlan) {
        Map<PlanFragmentId, Map<String, JsonRenderer.JsonRenderedNode>> jsonRenderedNodeMap = JsonPrestoQueryPlanFunctions.parseJsonPlanFragments(jsonPlan);
        if (jsonRenderedNodeMap == null) {
            return null;
        }
        jsonRenderedNodeMap.forEach((key, planMap) -> planMap.put("plan", JsonPrestoQueryPlanFunctions.scrubJsonPlan((JsonRenderer.JsonRenderedNode)planMap.get("plan"))));
        JsonCodec<Map<PlanFragmentId, Map<String, JsonRenderer.JsonRenderedNode>>> planMapCodec = JsonPrestoQueryPlanFunctions.constructJsonPlanMapCodec();
        return Slices.utf8Slice((String)planMapCodec.toJson(jsonRenderedNodeMap));
    }

    private static Map<String, List<String>> extractPlanIds(List<JsonRenderer.JsonRenderedNode> jsonPlanFragments) {
        HashMap<String, List<String>> planMap = new HashMap<String, List<String>>();
        jsonPlanFragments.stream().forEach(jsonPlanFragment -> JsonPrestoQueryPlanFunctions.addChildrenPlanIds(jsonPlanFragment, planMap));
        return planMap;
    }

    private static List<JsonRenderer.JsonRenderedNode> parseJsonPlanFragmentsAsList(Slice jsonPlan) {
        Map<PlanFragmentId, Map<String, JsonRenderer.JsonRenderedNode>> jsonRenderedNodeMap = JsonPrestoQueryPlanFunctions.parseJsonPlanFragments(jsonPlan);
        if (jsonRenderedNodeMap == null) {
            return null;
        }
        ArrayList<JsonRenderer.JsonRenderedNode> planFragments = new ArrayList<JsonRenderer.JsonRenderedNode>();
        jsonRenderedNodeMap.values().forEach(map -> planFragments.addAll(map.values()));
        return planFragments;
    }

    private static JsonCodec<Map<PlanFragmentId, Map<String, JsonRenderer.JsonRenderedNode>>> constructJsonPlanMapCodec() {
        JsonObjectMapperProvider provider = new JsonObjectMapperProvider();
        provider.setJsonSerializers((Map)ImmutableMap.of(VariableReferenceExpression.class, (Object)((Object)new Serialization.VariableReferenceExpressionSerializer())));
        provider.setKeyDeserializers((Map)ImmutableMap.of(VariableReferenceExpression.class, (Object)((Object)new Serialization.VariableReferenceExpressionDeserializer(TestingEnvironment.FUNCTION_AND_TYPE_MANAGER))));
        JsonCodecFactory codecFactory = new JsonCodecFactory((Provider)provider, true);
        JsonCodec planMapCodec = codecFactory.mapJsonCodec(PlanFragmentId.class, JsonCodec.mapJsonCodec(String.class, JsonRenderer.JsonRenderedNode.class));
        return planMapCodec;
    }

    private static Map<PlanFragmentId, Map<String, JsonRenderer.JsonRenderedNode>> parseJsonPlanFragments(Slice jsonPlan) {
        JsonCodec<Map<PlanFragmentId, Map<String, JsonRenderer.JsonRenderedNode>>> planMapCodec = JsonPrestoQueryPlanFunctions.constructJsonPlanMapCodec();
        try {
            Map fragmentMap = (Map)planMapCodec.fromJson(jsonPlan.getBytes());
            return fragmentMap;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static JsonCodec<JsonRenderer.JsonRenderedNode> constructJsonCodec() {
        JsonObjectMapperProvider provider = new JsonObjectMapperProvider();
        provider.setJsonSerializers((Map)ImmutableMap.of(VariableReferenceExpression.class, (Object)((Object)new Serialization.VariableReferenceExpressionSerializer())));
        provider.setKeyDeserializers((Map)ImmutableMap.of(VariableReferenceExpression.class, (Object)((Object)new Serialization.VariableReferenceExpressionDeserializer(TestingEnvironment.FUNCTION_AND_TYPE_MANAGER))));
        JsonCodecFactory codecFactory = new JsonCodecFactory((Provider)provider, true);
        JsonCodec planCodec = codecFactory.jsonCodec(JsonRenderer.JsonRenderedNode.class);
        return planCodec;
    }

    private static Block constructSqlArray(ArrayType arrayType, List<String> planIds) {
        ArrayType valueType = new ArrayType((Type)VarcharType.VARCHAR);
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, planIds.size());
        BlockBuilder singleMapBlockBuilder = blockBuilder.beginBlockEntry();
        for (String planId : planIds) {
            valueType.writeSlice(singleMapBlockBuilder, Slices.utf8Slice((String)planId));
        }
        blockBuilder.closeEntry();
        return arrayType.getObject((Block)blockBuilder, blockBuilder.getPositionCount() - 1);
    }

    private static void addChildrenPlanIds(JsonRenderer.JsonRenderedNode jsonRenderedNode, Map<String, List<String>> childrenMap) {
        String planId = jsonRenderedNode.getId();
        List children = jsonRenderedNode.getChildren().stream().map(x -> x.getId()).collect(Collectors.toList());
        childrenMap.put(planId, children);
        jsonRenderedNode.getChildren().stream().forEach(x -> JsonPrestoQueryPlanFunctions.addChildrenPlanIds(x, childrenMap));
    }

    private static JsonRenderer.JsonRenderedNode scrubJsonPlan(JsonRenderer.JsonRenderedNode node) {
        if (node == null) {
            return null;
        }
        String newName = JsonPrestoQueryPlanFunctions.scrubName(node.getName());
        String newIdentifier = JsonPrestoQueryPlanFunctions.scrubIdentifier(node.getIdentifier());
        List<JsonRenderer.JsonRenderedNode> newChildren = node.getChildren().stream().map(x -> JsonPrestoQueryPlanFunctions.scrubJsonPlan(x)).collect(Collectors.toList());
        String newDetails = JsonPrestoQueryPlanFunctions.scrubDetails(node.getDetails());
        return new JsonRenderer.JsonRenderedNode(node.getSourceLocation(), "PLANID", newName, newIdentifier, newDetails, newChildren, node.getRemoteSources(), (List<PlanNodeStatsEstimate>)ImmutableList.of());
    }

    private static String scrubName(String name) {
        if (name.startsWith("Aggregate(PARTIAL)")) {
            return "Aggregate(PARTIAL)";
        }
        if (name.startsWith("Aggregate(FINAL)")) {
            return "Aggregate(FINAL)";
        }
        if (name.startsWith("Aggregate")) {
            return "Aggregate";
        }
        return name;
    }

    private static String scrubIdentifier(String identifier) {
        String pattern;
        Pattern r;
        Matcher m;
        if (identifier.startsWith("[table") && (m = (r = Pattern.compile(pattern = "tableName=(\\w)")).matcher(identifier)).find()) {
            return "tableName=" + m.group(1);
        }
        return "IDENTIFIER";
    }

    private static String scrubDetails(String details) {
        return "DETAILS";
    }
}

