/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.PartitioningMetadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.TemporaryTableUtil;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.PlanFragmenterUtils;
import com.facebook.presto.sql.planner.SchedulingOrderVisitor;
import com.facebook.presto.sql.planner.StatisticsAggregationPlanner;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.SequenceNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class BasePlanFragmenter
extends SimplePlanRewriter<FragmentProperties> {
    private final Session session;
    private final Metadata metadata;
    private final PlanNodeIdAllocator idAllocator;
    private final VariableAllocator variableAllocator;
    private final StatsAndCosts statsAndCosts;
    private final PlanChecker planChecker;
    private final WarningCollector warningCollector;
    private final SqlParser sqlParser;
    private final Set<PlanNodeId> outputTableWriterNodeIds;
    private final StatisticsAggregationPlanner statisticsAggregationPlanner;
    private Map<String, TableScanNode> cteNameToTableScanMap = new HashMap<String, TableScanNode>();

    public BasePlanFragmenter(Session session, Metadata metadata, StatsAndCosts statsAndCosts, PlanChecker planChecker, WarningCollector warningCollector, SqlParser sqlParser, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, Set<PlanNodeId> outputTableWriterNodeIds) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.statsAndCosts = Objects.requireNonNull(statsAndCosts, "statsAndCosts is null");
        this.planChecker = Objects.requireNonNull(planChecker, "planChecker is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        this.outputTableWriterNodeIds = ImmutableSet.copyOf((Collection)Objects.requireNonNull(outputTableWriterNodeIds, "outputTableWriterNodeIds is null"));
        this.statisticsAggregationPlanner = new StatisticsAggregationPlanner(variableAllocator, metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver());
    }

    public SubPlan buildRootFragment(PlanNode root, FragmentProperties properties) {
        return this.buildFragment(root, properties, new PlanFragmentId(0));
    }

    public abstract PlanFragmentId nextFragmentId();

    private SubPlan buildFragment(PlanNode root, FragmentProperties properties, PlanFragmentId fragmentId) {
        List<PlanNodeId> schedulingOrder = SchedulingOrderVisitor.scheduleOrder(root);
        Preconditions.checkArgument((boolean)properties.getPartitionedSources().equals(ImmutableSet.copyOf(schedulingOrder)), (String)"Expected scheduling order (%s) to contain an entry for all partitioned sources (%s)", schedulingOrder, properties.getPartitionedSources());
        Set<VariableReferenceExpression> fragmentVariableTypes = VariablesExtractor.extractOutputVariables(root);
        this.planChecker.validatePlanFragment(root, this.session, this.metadata, this.sqlParser, TypeProvider.fromVariables(fragmentVariableTypes), this.warningCollector);
        Set<PlanNodeId> tableWriterNodeIds = PlanFragmenterUtils.getTableWriterNodeIds(root);
        boolean outputTableWriterFragment = tableWriterNodeIds.stream().anyMatch(this.outputTableWriterNodeIds::contains);
        if (outputTableWriterFragment) {
            Verify.verify((boolean)this.outputTableWriterNodeIds.containsAll(tableWriterNodeIds), (String)"outputTableWriterNodeIds %s must include either all or none of tableWriterNodeIds %s", this.outputTableWriterNodeIds, tableWriterNodeIds);
        }
        PlanFragment fragment = new PlanFragment(fragmentId, root, fragmentVariableTypes, properties.getPartitioningHandle(), schedulingOrder, properties.getPartitioningScheme(), StageExecutionDescriptor.ungroupedExecution(), outputTableWriterFragment, this.statsAndCosts.getForSubplan(root), Optional.of(PlanPrinter.jsonFragmentPlan(root, fragmentVariableTypes, this.statsAndCosts.getForSubplan(root), this.metadata.getFunctionAndTypeManager(), this.session)));
        return new SubPlan(fragment, properties.getChildren());
    }

    public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        if (SystemSessionProperties.isForceSingleNodeOutput(this.session)) {
            context.get().setSingleNodeDistribution();
        }
        return context.defaultRewrite((PlanNode)node, context.get());
    }

    @Override
    public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        context.get().setCoordinatorOnlyDistribution(node);
        return context.defaultRewrite(node, context.get());
    }

    @Override
    public PlanNode visitStatisticsWriterNode(StatisticsWriterNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        context.get().setCoordinatorOnlyDistribution(node);
        return context.defaultRewrite(node, context.get());
    }

    @Override
    public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        context.get().setCoordinatorOnlyDistribution(node);
        return context.defaultRewrite(node, context.get());
    }

    @Override
    public PlanNode visitSequence(SequenceNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        List<List<PlanNode>> independentCteProducerSubgraphs = node.getIndependentCteProducers();
        for (List<PlanNode> cteProducerSubgraph : independentCteProducerSubgraphs) {
            int cteProducerCount = cteProducerSubgraph.size();
            Preconditions.checkArgument((cteProducerCount >= 1 ? 1 : 0) != 0, (Object)"CteProducer subgraph has 0 CTE producers");
            PlanNode source = cteProducerSubgraph.get(cteProducerCount - 1);
            FragmentProperties childProperties = new FragmentProperties(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, ImmutableList.of()), source.getOutputVariables()));
            SubPlan lastSubPlan = this.buildSubPlan(source, childProperties, context);
            for (int sourceIndex = cteProducerCount - 2; sourceIndex >= 0; --sourceIndex) {
                source = cteProducerSubgraph.get(sourceIndex);
                childProperties = new FragmentProperties(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, ImmutableList.of()), source.getOutputVariables()));
                childProperties.addChildren((List<SubPlan>)ImmutableList.of((Object)lastSubPlan));
                lastSubPlan = this.buildSubPlan(source, childProperties, context);
            }
            context.get().addChildren((List<SubPlan>)ImmutableList.of((Object)lastSubPlan));
        }
        return (PlanNode)node.getPrimarySource().accept((PlanVisitor)this, context);
    }

    @Override
    public PlanNode visitMetadataDelete(MetadataDeleteNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        context.get().setCoordinatorOnlyDistribution(node);
        return context.defaultRewrite(node, context.get());
    }

    public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        PartitioningHandle partitioning = this.metadata.getLayout(this.session, node.getTable()).getTablePartitioning().map(TableLayout.TablePartitioning::getPartitioningHandle).orElse(SystemPartitioningHandle.SOURCE_DISTRIBUTION);
        context.get().addSourceDistribution(node.getId(), partitioning, this.metadata, this.session);
        return context.defaultRewrite((PlanNode)node, context.get());
    }

    @Override
    public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        if (node.getTablePartitioningScheme().isPresent()) {
            context.get().setDistribution(node.getTablePartitioningScheme().get().getPartitioning().getHandle(), this.metadata, this.session);
        }
        if (node.getPreferredShufflePartitioningScheme().isPresent()) {
            context.get().setDistribution(node.getPreferredShufflePartitioningScheme().get().getPartitioning().getHandle(), this.metadata, this.session);
        }
        return context.defaultRewrite(node, context.get());
    }

    public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        context.get().setSingleNodeDistribution();
        return context.defaultRewrite((PlanNode)node, context.get());
    }

    @Override
    public PlanNode visitExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        switch (exchange.getScope()) {
            case LOCAL: {
                return context.defaultRewrite(exchange, context.get());
            }
            case REMOTE_STREAMING: {
                return this.createRemoteStreamingExchange(exchange, context);
            }
            case REMOTE_MATERIALIZED: {
                return this.createRemoteMaterializedExchange(exchange, context);
            }
        }
        throw new IllegalArgumentException("Unexpected exchange scope: " + (Object)((Object)exchange.getScope()));
    }

    private PlanNode createRemoteStreamingExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        Preconditions.checkArgument((exchange.getScope() == ExchangeNode.Scope.REMOTE_STREAMING ? 1 : 0) != 0, (String)"Unexpected exchange scope: %s", (Object)((Object)exchange.getScope()));
        PartitioningScheme partitioningScheme = exchange.getPartitioningScheme();
        this.setDistributionForExchange(exchange.getType(), partitioningScheme, context);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int sourceIndex = 0; sourceIndex < exchange.getSources().size(); ++sourceIndex) {
            FragmentProperties childProperties = new FragmentProperties(partitioningScheme.translateOutputLayout(exchange.getInputs().get(sourceIndex)));
            builder.add((Object)this.buildSubPlan(exchange.getSources().get(sourceIndex), childProperties, context));
        }
        ImmutableList children = builder.build();
        context.get().addChildren((List<SubPlan>)children);
        List childrenIds = (List)children.stream().map(SubPlan::getFragment).map(PlanFragment::getId).collect(ImmutableList.toImmutableList());
        return new RemoteSourceNode(exchange.getSourceLocation(), exchange.getId(), exchange.getStatsEquivalentPlanNode(), childrenIds, exchange.getOutputVariables(), exchange.isEnsureSourceOrdering(), exchange.getOrderingScheme(), exchange.getType());
    }

    protected void setDistributionForExchange(ExchangeNode.Type exchangeType, PartitioningScheme partitioningScheme, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        if (exchangeType == ExchangeNode.Type.GATHER) {
            context.get().setSingleNodeDistribution();
        } else if (exchangeType == ExchangeNode.Type.REPARTITION) {
            context.get().setDistribution(partitioningScheme.getPartitioning().getHandle(), this.metadata, this.session);
        }
    }

    private PlanNode createRemoteMaterializedExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        TableHandle temporaryTableHandle;
        Preconditions.checkArgument((exchange.getType() == ExchangeNode.Type.REPARTITION ? 1 : 0) != 0, (String)"Unexpected exchange type: %s", (Object)((Object)exchange.getType()));
        Preconditions.checkArgument((exchange.getScope() == ExchangeNode.Scope.REMOTE_MATERIALIZED ? 1 : 0) != 0, (String)"Unexpected exchange scope: %s", (Object)((Object)exchange.getScope()));
        PartitioningScheme partitioningScheme = exchange.getPartitioningScheme();
        PartitioningHandle partitioningHandle = partitioningScheme.getPartitioning().getHandle();
        ConnectorId connectorId = partitioningHandle.getConnectorId().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The \"partitioning_provider_catalog\" session property must be set to enable the exchanges materialization. The catalog must support providing a custom partitioning and storing temporary tables."));
        Partitioning partitioning = partitioningScheme.getPartitioning();
        PartitioningVariableAssignments partitioningVariableAssignments = TemporaryTableUtil.assignPartitioningVariables(this.variableAllocator, partitioning);
        Map<VariableReferenceExpression, ColumnMetadata> variableToColumnMap = TemporaryTableUtil.assignTemporaryTableColumnNames(exchange.getOutputVariables(), partitioningVariableAssignments.getConstants().keySet());
        List<VariableReferenceExpression> partitioningVariables = partitioningVariableAssignments.getVariables();
        List partitionColumns = (List)partitioningVariables.stream().map(variable -> ((ColumnMetadata)variableToColumnMap.get(variable)).getName()).collect(ImmutableList.toImmutableList());
        PartitioningMetadata partitioningMetadata = new PartitioningMetadata(partitioningHandle, partitionColumns);
        try {
            temporaryTableHandle = this.metadata.createTemporaryTable(this.session, connectorId.getCatalogName(), (List<ColumnMetadata>)ImmutableList.copyOf(variableToColumnMap.values()), Optional.of(partitioningMetadata));
        }
        catch (PrestoException e) {
            if (e.getErrorCode().equals((Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Temporary table cannot be created in catalog \"%s\": %s", connectorId.getCatalogName(), e.getMessage()), (Throwable)e);
            }
            throw e;
        }
        TableScanNode scan = TemporaryTableUtil.createTemporaryTableScan(this.metadata, this.session, this.idAllocator, exchange.getSourceLocation(), temporaryTableHandle, exchange.getOutputVariables(), variableToColumnMap, partitioningMetadata);
        Preconditions.checkArgument((!exchange.getPartitioningScheme().isReplicateNullsAndAny() ? 1 : 0) != 0, (Object)"materialized remote exchange is not supported when replicateNullsAndAny is needed");
        TableFinishNode write = TemporaryTableUtil.createTemporaryTableWriteWithExchanges(this.metadata, this.session, this.idAllocator, this.variableAllocator, this.statisticsAggregationPlanner, scan.getSourceLocation(), temporaryTableHandle, variableToColumnMap, exchange.getOutputVariables(), exchange.getInputs(), exchange.getSources(), partitioningVariableAssignments.getConstants(), partitioningMetadata);
        FragmentProperties writeProperties = new FragmentProperties(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, ImmutableList.of()), write.getOutputVariables()));
        writeProperties.setCoordinatorOnlyDistribution(write);
        ImmutableList children = ImmutableList.of((Object)this.buildSubPlan(write, writeProperties, context));
        context.get().addChildren((List<SubPlan>)children);
        return this.visitTableScan(scan, context);
    }

    private SubPlan buildSubPlan(PlanNode node, FragmentProperties properties, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
        PlanFragmentId planFragmentId = this.nextFragmentId();
        PlanNode child = context.rewrite(node, properties);
        return this.buildFragment(child, properties, planFragmentId);
    }

    public static class PartitioningVariableAssignments {
        private final List<VariableReferenceExpression> variables;
        private final Map<VariableReferenceExpression, RowExpression> constants;

        public PartitioningVariableAssignments(List<VariableReferenceExpression> variables, Map<VariableReferenceExpression, RowExpression> constants) {
            this.variables = ImmutableList.copyOf((Collection)Objects.requireNonNull(variables, "variables is null"));
            this.constants = ImmutableMap.copyOf(Objects.requireNonNull(constants, "constants is null"));
            Preconditions.checkArgument((boolean)ImmutableSet.copyOf(variables).containsAll(constants.keySet()), (Object)"partitioningVariables list must contain all partitioning variables including constants");
        }

        public List<VariableReferenceExpression> getVariables() {
            return this.variables;
        }

        public Map<VariableReferenceExpression, RowExpression> getConstants() {
            return this.constants;
        }
    }

    public static class FragmentProperties {
        private final List<SubPlan> children = new ArrayList<SubPlan>();
        private final PartitioningScheme partitioningScheme;
        private Optional<PartitioningHandle> partitioningHandle = Optional.empty();
        private final Set<PlanNodeId> partitionedSources = new HashSet<PlanNodeId>();

        public FragmentProperties(PartitioningScheme partitioningScheme) {
            this.partitioningScheme = partitioningScheme;
        }

        public List<SubPlan> getChildren() {
            return this.children;
        }

        public FragmentProperties setSingleNodeDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isSingleNode()) {
                return this;
            }
            Preconditions.checkState((!this.partitioningHandle.isPresent() ? 1 : 0) != 0, (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object)SystemPartitioningHandle.SINGLE_DISTRIBUTION, this.partitioningHandle);
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.SINGLE_DISTRIBUTION);
            return this;
        }

        public FragmentProperties setDistribution(PartitioningHandle distribution, Metadata metadata, Session session) {
            if (!this.partitioningHandle.isPresent()) {
                this.partitioningHandle = Optional.of(distribution);
                return this;
            }
            PartitioningHandle currentPartitioning = this.partitioningHandle.get();
            if (SystemPartitioningHandle.isCompatibleSystemPartitioning(currentPartitioning, distribution)) {
                return this;
            }
            if (currentPartitioning.equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
                this.partitioningHandle = Optional.of(distribution);
                return this;
            }
            if (currentPartitioning.isSingleNode()) {
                return this;
            }
            if (currentPartitioning.equals(distribution)) {
                return this;
            }
            Optional<PartitioningHandle> commonPartitioning = metadata.getCommonPartitioning(session, currentPartitioning, distribution);
            if (commonPartitioning.isPresent()) {
                this.partitioningHandle = commonPartitioning;
                return this;
            }
            if (metadata.isRefinedPartitioningOver(session, distribution, currentPartitioning)) {
                return this;
            }
            throw new IllegalStateException(String.format("Cannot set distribution to %s. Already set to %s", distribution, this.partitioningHandle));
        }

        public FragmentProperties setCoordinatorOnlyDistribution(PlanNode node) {
            Preconditions.checkArgument((boolean)PlanFragmenterUtils.isCoordinatorOnlyDistribution(node), (String)"PlanNode type %s doesn't support COORDINATOR_DISTRIBUTION", node.getClass());
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isCoordinatorOnly()) {
                return this;
            }
            Preconditions.checkState((!this.partitioningHandle.isPresent() || this.partitioningHandle.get().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) ? 1 : 0) != 0, (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object)SystemPartitioningHandle.COORDINATOR_DISTRIBUTION, this.partitioningHandle);
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION);
            return this;
        }

        public FragmentProperties addSourceDistribution(PlanNodeId source, PartitioningHandle distribution, Metadata metadata, Session session) {
            Objects.requireNonNull(source, "source is null");
            Objects.requireNonNull(distribution, "distribution is null");
            this.partitionedSources.add(source);
            return this.setDistribution(distribution, metadata, session);
        }

        public FragmentProperties addChildren(List<SubPlan> children) {
            this.children.addAll(children);
            return this;
        }

        public PartitioningScheme getPartitioningScheme() {
            return this.partitioningScheme;
        }

        public PartitioningHandle getPartitioningHandle() {
            return this.partitioningHandle.get();
        }

        public Set<PlanNodeId> getPartitionedSources() {
            return this.partitionedSources;
        }
    }
}

