/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CanonicalTableScanNode
extends InternalPlanNode {
    private final CanonicalTableHandle table;
    private final Map<VariableReferenceExpression, ColumnHandle> assignments;
    private final List<VariableReferenceExpression> outputVariables;

    @JsonCreator
    public CanonicalTableScanNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") CanonicalTableHandle table, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="assignments") Map<VariableReferenceExpression, ColumnHandle> assignments) {
        this(sourceLocation, id, Optional.empty(), table, outputVariables, assignments);
    }

    public CanonicalTableScanNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, CanonicalTableHandle table, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnHandle> assignments) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputVariables = Collections.unmodifiableList(Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.assignments = Collections.unmodifiableMap(new HashMap<VariableReferenceExpression, ColumnHandle>(Objects.requireNonNull(assignments, "assignments is null")));
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputVariables), (Object)"assignments does not cover all of outputs");
    }

    public List<PlanNode> getSources() {
        return Collections.emptyList();
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Cannot assign canonical plan id to Canonical table scan node: %s", new Object[]{this}));
    }

    @JsonProperty
    public CanonicalTableHandle getTable() {
        return this.table;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitCanonicalTableScan(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CanonicalTableScanNode that = (CanonicalTableScanNode)((Object)o);
        return Objects.equals(this.table, that.table) && Objects.equals(this.assignments, that.assignments) && Objects.equals(this.outputVariables, that.outputVariables);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.assignments, this.outputVariables);
    }

    public static class CanonicalTableHandle {
        private final ConnectorId connectorId;
        private final ConnectorTableHandle tableHandle;
        private final Optional<Object> layoutIdentifier;
        private final Optional<ConnectorTableLayoutHandle> layoutHandle;

        public static CanonicalTableHandle getCanonicalTableHandle(TableHandle tableHandle, PlanCanonicalizationStrategy strategy) {
            return new CanonicalTableHandle(tableHandle.getConnectorId(), tableHandle.getConnectorHandle(), tableHandle.getLayout().map(layout -> layout.getIdentifier(Optional.empty(), strategy)), tableHandle.getLayout());
        }

        @JsonCreator
        public CanonicalTableHandle(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="tableHandle") ConnectorTableHandle tableHandle, @JsonProperty(value="layoutIdentifier") Optional<Object> layoutIdentifier) {
            this(connectorId, tableHandle, layoutIdentifier, Optional.empty());
        }

        public CanonicalTableHandle(ConnectorId connectorId, ConnectorTableHandle tableHandle, Optional<Object> layoutIdentifier, Optional<ConnectorTableLayoutHandle> layoutHandle) {
            this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
            this.layoutIdentifier = Objects.requireNonNull(layoutIdentifier, "layoutIdentifier is null");
            this.layoutHandle = Objects.requireNonNull(layoutHandle, "layoutHandle is null");
        }

        @JsonProperty
        public ConnectorId getConnectorId() {
            return this.connectorId;
        }

        @JsonProperty
        public ConnectorTableHandle getTableHandle() {
            return this.tableHandle;
        }

        @JsonProperty
        public Optional<Object> getLayoutIdentifier() {
            return this.layoutIdentifier;
        }

        public Optional<ConnectorTableLayoutHandle> getLayoutHandle() {
            return this.layoutHandle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CanonicalTableHandle that = (CanonicalTableHandle)o;
            return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.tableHandle, that.tableHandle) && Objects.equals(this.layoutIdentifier, that.layoutIdentifier);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.tableHandle, this.layoutIdentifier);
        }
    }
}

