/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.TaskCountEstimator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ConnectorPlanOptimizerManager;
import com.facebook.presto.sql.planner.OptimizerStatsRecorder;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesProviderImpl;
import com.facebook.presto.sql.planner.iterative.rule.AddIntermediateAggregations;
import com.facebook.presto.sql.planner.iterative.rule.AddNotNullFiltersToJoinNode;
import com.facebook.presto.sql.planner.iterative.rule.CombineApproxPercentileFunctions;
import com.facebook.presto.sql.planner.iterative.rule.CreatePartialTopN;
import com.facebook.presto.sql.planner.iterative.rule.CrossJoinWithArrayContainsToInnerJoin;
import com.facebook.presto.sql.planner.iterative.rule.CrossJoinWithArrayNotContainsToAntiJoin;
import com.facebook.presto.sql.planner.iterative.rule.CrossJoinWithOrFilterToInnerJoin;
import com.facebook.presto.sql.planner.iterative.rule.DesugarLambdaExpression;
import com.facebook.presto.sql.planner.iterative.rule.DetermineJoinDistributionType;
import com.facebook.presto.sql.planner.iterative.rule.DetermineSemiJoinDistributionType;
import com.facebook.presto.sql.planner.iterative.rule.EliminateCrossJoins;
import com.facebook.presto.sql.planner.iterative.rule.EvaluateZeroLimit;
import com.facebook.presto.sql.planner.iterative.rule.EvaluateZeroSample;
import com.facebook.presto.sql.planner.iterative.rule.ExtractSpatialJoins;
import com.facebook.presto.sql.planner.iterative.rule.GatherAndMergeWindows;
import com.facebook.presto.sql.planner.iterative.rule.ImplementBernoulliSampleAsFilter;
import com.facebook.presto.sql.planner.iterative.rule.ImplementFilteredAggregations;
import com.facebook.presto.sql.planner.iterative.rule.ImplementOffset;
import com.facebook.presto.sql.planner.iterative.rule.InlineProjections;
import com.facebook.presto.sql.planner.iterative.rule.InlineSqlFunctions;
import com.facebook.presto.sql.planner.iterative.rule.LeftJoinNullFilterToSemiJoin;
import com.facebook.presto.sql.planner.iterative.rule.LeftJoinWithArrayContainsToEquiJoinCondition;
import com.facebook.presto.sql.planner.iterative.rule.MergeDuplicateAggregation;
import com.facebook.presto.sql.planner.iterative.rule.MergeFilters;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithDistinct;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithSort;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithTopN;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimits;
import com.facebook.presto.sql.planner.iterative.rule.MultipleDistinctAggregationToMarkDistinct;
import com.facebook.presto.sql.planner.iterative.rule.PickTableLayout;
import com.facebook.presto.sql.planner.iterative.rule.PlanRemoteProjections;
import com.facebook.presto.sql.planner.iterative.rule.PruneAggregationColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneAggregationSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneCountAggregationOverScalar;
import com.facebook.presto.sql.planner.iterative.rule.PruneCrossJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneFilterColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneIndexSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneJoinChildrenColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneLimitColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneMarkDistinctColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneOrderByInAggregation;
import com.facebook.presto.sql.planner.iterative.rule.PruneOutputColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneProjectColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneRedundantProjectionAssignments;
import com.facebook.presto.sql.planner.iterative.rule.PruneSemiJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneSemiJoinFilteringSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneTableScanColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneTopNColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneValuesColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneWindowColumns;
import com.facebook.presto.sql.planner.iterative.rule.PullConstantsAboveGroupBy;
import com.facebook.presto.sql.planner.iterative.rule.PullUpExpressionInLambdaRules;
import com.facebook.presto.sql.planner.iterative.rule.PushAggregationThroughOuterJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushDownDereferences;
import com.facebook.presto.sql.planner.iterative.rule.PushDownFilterExpressionEvaluationThroughCrossJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughMarkDistinct;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughOffset;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughOuterJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughProject;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughSemiJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.PushOffsetThroughProject;
import com.facebook.presto.sql.planner.iterative.rule.PushPartialAggregationThroughExchange;
import com.facebook.presto.sql.planner.iterative.rule.PushPartialAggregationThroughJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushProjectionThroughExchange;
import com.facebook.presto.sql.planner.iterative.rule.PushProjectionThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.PushRemoteExchangeThroughAssignUniqueId;
import com.facebook.presto.sql.planner.iterative.rule.PushRemoteExchangeThroughGroupId;
import com.facebook.presto.sql.planner.iterative.rule.PushTableWriteThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.PushTopNThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.RemoveEmptyDelete;
import com.facebook.presto.sql.planner.iterative.rule.RemoveFullSample;
import com.facebook.presto.sql.planner.iterative.rule.RemoveIdentityProjectionsBelowProjection;
import com.facebook.presto.sql.planner.iterative.rule.RemoveMapCastRule;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantAggregateDistinct;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantCastToVarcharInJoinClause;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantDistinct;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantDistinctLimit;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantLimit;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantSort;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantSortColumns;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantTopN;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantTopNColumns;
import com.facebook.presto.sql.planner.iterative.rule.RemoveTrivialFilters;
import com.facebook.presto.sql.planner.iterative.rule.RemoveUnreferencedScalarApplyNodes;
import com.facebook.presto.sql.planner.iterative.rule.RemoveUnreferencedScalarLateralNodes;
import com.facebook.presto.sql.planner.iterative.rule.RemoveUnsupportedDynamicFilters;
import com.facebook.presto.sql.planner.iterative.rule.ReorderJoins;
import com.facebook.presto.sql.planner.iterative.rule.RewriteAggregationIfToFilter;
import com.facebook.presto.sql.planner.iterative.rule.RewriteCaseExpressionPredicate;
import com.facebook.presto.sql.planner.iterative.rule.RewriteCaseToMap;
import com.facebook.presto.sql.planner.iterative.rule.RewriteConstantArrayContainsToInExpression;
import com.facebook.presto.sql.planner.iterative.rule.RewriteFilterWithExternalFunctionToProject;
import com.facebook.presto.sql.planner.iterative.rule.RewriteSpatialPartitioningAggregation;
import com.facebook.presto.sql.planner.iterative.rule.RuntimeReorderJoinSides;
import com.facebook.presto.sql.planner.iterative.rule.ScaledWriterRule;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyCardinalityMap;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyCountOverConstant;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyRowExpressions;
import com.facebook.presto.sql.planner.iterative.rule.SimplifySortWithConstantInput;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyTopNWithConstantInput;
import com.facebook.presto.sql.planner.iterative.rule.SingleDistinctAggregationToGroupBy;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedInPredicateToJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedLateralJoinToJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedScalarAggregationToJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedScalarSubquery;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedSingleRowSubqueryToProject;
import com.facebook.presto.sql.planner.iterative.rule.TransformDistinctInnerJoinToLeftEarlyOutJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformDistinctInnerJoinToRightEarlyOutJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformExistsApplyToLateralNode;
import com.facebook.presto.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformUncorrelatedLateralToJoin;
import com.facebook.presto.sql.planner.optimizations.AddExchanges;
import com.facebook.presto.sql.planner.optimizations.AddLocalExchanges;
import com.facebook.presto.sql.planner.optimizations.ApplyConnectorOptimization;
import com.facebook.presto.sql.planner.optimizations.CheckSubqueryNodesAreRewritten;
import com.facebook.presto.sql.planner.optimizations.CteProjectionAndPredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.HashGenerationOptimizer;
import com.facebook.presto.sql.planner.optimizations.HistoricalStatisticsEquivalentPlanMarkingOptimizer;
import com.facebook.presto.sql.planner.optimizations.ImplementIntersectAndExceptAsUnion;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.optimizations.KeyBasedSampler;
import com.facebook.presto.sql.planner.optimizations.LimitPushDown;
import com.facebook.presto.sql.planner.optimizations.LogicalCteOptimizer;
import com.facebook.presto.sql.planner.optimizations.MergeJoinForSortedInputOptimizer;
import com.facebook.presto.sql.planner.optimizations.MergePartialAggregationsWithFilter;
import com.facebook.presto.sql.planner.optimizations.MetadataDeleteOptimizer;
import com.facebook.presto.sql.planner.optimizations.MetadataQueryOptimizer;
import com.facebook.presto.sql.planner.optimizations.OptimizeMixedDistinctAggregations;
import com.facebook.presto.sql.planner.optimizations.PayloadJoinOptimizer;
import com.facebook.presto.sql.planner.optimizations.PhysicalCteOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.PrefilterForLimitingAggregation;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.PushdownSubfields;
import com.facebook.presto.sql.planner.optimizations.RandomizeNullKeyInOuterJoin;
import com.facebook.presto.sql.planner.optimizations.RemoveRedundantDistinctAggregation;
import com.facebook.presto.sql.planner.optimizations.ReplaceConstantVariableReferencesWithConstants;
import com.facebook.presto.sql.planner.optimizations.ReplicateSemiJoinInDelete;
import com.facebook.presto.sql.planner.optimizations.RewriteIfOverAggregation;
import com.facebook.presto.sql.planner.optimizations.SetFlatteningOptimizer;
import com.facebook.presto.sql.planner.optimizations.ShardJoins;
import com.facebook.presto.sql.planner.optimizations.SimplifyPlanWithEmptyInput;
import com.facebook.presto.sql.planner.optimizations.StatsRecordingPlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.TransformQuantifiedComparisonApplyToLateralJoin;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.sql.planner.optimizations.WindowFilterPushDown;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.MBeanExporter;

public class PlanOptimizers {
    private final List<PlanOptimizer> planningTimeOptimizers;
    private final List<PlanOptimizer> runtimeOptimizers;
    private final RuleStatsRecorder ruleStats = new RuleStatsRecorder();
    private final OptimizerStatsRecorder optimizerStats = new OptimizerStatsRecorder();
    private final MBeanExporter exporter;

    @Inject
    public PlanOptimizers(Metadata metadata, SqlParser sqlParser, MBeanExporter exporter, SplitManager splitManager, ConnectorPlanOptimizerManager planOptimizerManager, PageSourceManager pageSourceManager, StatsCalculator statsCalculator, CostCalculator costCalculator, @CostCalculator.EstimatedExchanges CostCalculator estimatedExchangesCostCalculator, CostComparator costComparator, TaskCountEstimator taskCountEstimator, PartitioningProviderManager partitioningProviderManager, FeaturesConfig featuresConfig) {
        this(metadata, sqlParser, false, exporter, splitManager, planOptimizerManager, pageSourceManager, statsCalculator, costCalculator, estimatedExchangesCostCalculator, costComparator, taskCountEstimator, partitioningProviderManager, featuresConfig);
    }

    @PostConstruct
    public void initialize() {
        this.ruleStats.export(this.exporter);
        this.optimizerStats.export(this.exporter);
    }

    @PreDestroy
    public void destroy() {
        this.ruleStats.unexport(this.exporter);
        this.optimizerStats.unexport(this.exporter);
    }

    public PlanOptimizers(Metadata metadata, SqlParser sqlParser, boolean forceSingleNode, MBeanExporter exporter, SplitManager splitManager, ConnectorPlanOptimizerManager planOptimizerManager, PageSourceManager pageSourceManager, StatsCalculator statsCalculator, CostCalculator costCalculator, CostCalculator estimatedExchangesCostCalculator, CostComparator costComparator, TaskCountEstimator taskCountEstimator, PartitioningProviderManager partitioningProviderManager, FeaturesConfig featuresConfig) {
        this.exporter = exporter;
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet predicatePushDownRules = ImmutableSet.of((Object)new MergeFilters(metadata.getFunctionAndTypeManager()));
        ImmutableSet columnPruningRules = ImmutableSet.of((Object)new PruneAggregationColumns(), (Object)new PruneAggregationSourceColumns(), (Object)new PruneCrossJoinColumns(), (Object)new PruneFilterColumns(), (Object)new PruneIndexSourceColumns(), (Object)new PruneJoinChildrenColumns(), (Object[])new Rule[]{new PruneJoinColumns(), new PruneMarkDistinctColumns(), new PruneOutputColumns(), new PruneProjectColumns(), new PruneSemiJoinColumns(), new PruneSemiJoinFilteringSourceColumns(), new PruneTopNColumns(), new PruneValuesColumns(), new PruneWindowColumns(), new PruneLimitColumns(), new PruneTableScanColumns()});
        builder.add((Object)new LogicalCteOptimizer(metadata));
        IterativeOptimizer inlineProjections = new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(metadata.getFunctionAndTypeManager()), (Object)new RemoveRedundantIdentityProjections(), (Object)new RemoveIdentityProjectionsBelowProjection()));
        IterativeOptimizer projectionPushDown = new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushProjectionThroughUnion(), (Object)new PushProjectionThroughExchange()));
        IterativeOptimizer simplifyRowExpressionOptimizer = new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new SimplifyRowExpressions(metadata).rules()).add((Object)new PruneRedundantProjectionAssignments()).build());
        IterativeOptimizer caseExpressionPredicateRewriter = new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, new RewriteCaseExpressionPredicate(metadata.getFunctionAndTypeManager()).rules());
        IterativeOptimizer caseToMapRewriter = new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, new RewriteCaseToMap(metadata.getFunctionAndTypeManager()).rules());
        IterativeOptimizer containsToInRewriter = new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, new RewriteConstantArrayContainsToInExpression(metadata.getFunctionAndTypeManager()).rules());
        StatsRecordingPlanOptimizer predicatePushDown = new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(metadata, sqlParser, featuresConfig.isNativeExecutionEnabled()));
        StatsRecordingPlanOptimizer prefilterForLimitingAggregation = new StatsRecordingPlanOptimizer(this.optimizerStats, new PrefilterForLimitingAggregation(metadata, statsCalculator));
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new InlineSqlFunctions(metadata, sqlParser).rules()).build()), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new PullUpExpressionInLambdaRules(metadata.getFunctionAndTypeManager()).rules()).build()), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new DesugarLambdaExpression().rules()).addAll(new SimplifyCardinalityMap(metadata.getFunctionAndTypeManager()).rules()).build()), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new EvaluateZeroLimit())), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)predicatePushDownRules).addAll((Iterable)columnPruningRules).addAll((Iterable)ImmutableSet.of((Object)new MergeDuplicateAggregation(metadata.getFunctionAndTypeManager()), (Object)new RemoveRedundantIdentityProjections(), (Object)new RemoveFullSample(), (Object)new EvaluateZeroSample(), (Object)new PushOffsetThroughProject(), (Object)new PushLimitThroughOffset(), (Object[])new Rule[]{new PushLimitThroughProject(), new MergeLimits(), new MergeLimitWithSort(), new MergeLimitWithTopN(), new PushLimitThroughMarkDistinct(), new PushLimitThroughOuterJoin(), new PushLimitThroughSemiJoin(), new PushLimitThroughUnion(), new RemoveTrivialFilters(), new ImplementFilteredAggregations(metadata.getFunctionAndTypeManager()), new SingleDistinctAggregationToGroupBy(), new MultipleDistinctAggregationToMarkDistinct(), new ImplementBernoulliSampleAsFilter(metadata.getFunctionAndTypeManager()), new MergeLimitWithDistinct(), new PruneCountAggregationOverScalar(metadata.getFunctionAndTypeManager()), new PruneOrderByInAggregation(metadata.getFunctionAndTypeManager()), new RewriteSpatialPartitioningAggregation(metadata)})).build()), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ImplementBernoulliSampleAsFilter(metadata.getFunctionAndTypeManager()), (Object)new ImplementOffset(metadata.getFunctionAndTypeManager()))), simplifyRowExpressionOptimizer, new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveTrivialFilters())), new UnaliasSymbolReferences(metadata.getFunctionAndTypeManager()), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new SetFlatteningOptimizer(), new ImplementIntersectAndExceptAsUnion(metadata.getFunctionAndTypeManager()), new ReplaceConstantVariableReferencesWithConstants(metadata.getFunctionAndTypeManager()), simplifyRowExpressionOptimizer, new ReplaceConstantVariableReferencesWithConstants(metadata.getFunctionAndTypeManager()), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new SimplifySortWithConstantInput(), (Object)new SimplifyTopNWithConstantInput(), (Object)new PullConstantsAboveGroupBy())), inlineProjections, new PruneUnreferencedOutputs(), inlineProjections, new LimitPushDown(), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)columnPruningRules), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new TransformExistsApplyToLateralNode(metadata.getFunctionAndTypeManager()))), new TransformQuantifiedComparisonApplyToLateralJoin(metadata.getFunctionAndTypeManager()), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveUnreferencedScalarLateralNodes(), (Object)new TransformUncorrelatedLateralToJoin(), (Object)new TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin(), (Object)new TransformUncorrelatedInPredicateSubqueryToSemiJoin(), (Object)new TransformCorrelatedScalarAggregationToJoin(metadata.getFunctionAndTypeManager()), (Object)new TransformCorrelatedLateralJoinToJoin(metadata.getFunctionAndTypeManager()), (Object[])new Rule[0])), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveUnreferencedScalarApplyNodes(), (Object)new TransformCorrelatedInPredicateToJoin(metadata.getFunctionAndTypeManager()), (Object)new TransformCorrelatedScalarSubquery(metadata.getFunctionAndTypeManager()), (Object)new TransformCorrelatedLateralJoinToJoin(metadata.getFunctionAndTypeManager()), (Object)new ImplementFilteredAggregations(metadata.getFunctionAndTypeManager()))), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(metadata.getFunctionAndTypeManager()), (Object)new RemoveRedundantIdentityProjections(), (Object)new TransformCorrelatedSingleRowSubqueryToProject())), new CheckSubqueryNodesAreRewritten(), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantCastToVarcharInJoinClause(metadata.getFunctionAndTypeManager())).addAll(new RemoveMapCastRule(metadata.getFunctionAndTypeManager()).rules()).build())});
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new CombineApproxPercentileFunctions(metadata.getFunctionAndTypeManager()))));
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PruneRedundantProjectionAssignments(), (Object)new InlineProjections(metadata.getFunctionAndTypeManager()), (Object)new RemoveRedundantIdentityProjections())), new RewriteIfOverAggregation(metadata.getFunctionAndTypeManager())});
        builder.add((Object[])new PlanOptimizer[]{caseToMapRewriter, caseExpressionPredicateRewriter, containsToInRewriter, new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RewriteAggregationIfToFilter(metadata.getFunctionAndTypeManager()))), predicatePushDown, new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushDownFilterExpressionEvaluationThroughCrossJoin(metadata.getFunctionAndTypeManager()), (Object)new CrossJoinWithOrFilterToInnerJoin(metadata.getFunctionAndTypeManager()), (Object)new CrossJoinWithArrayContainsToInnerJoin(metadata.getFunctionAndTypeManager()), (Object)new CrossJoinWithArrayNotContainsToAntiJoin(metadata, metadata.getFunctionAndTypeManager()))), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new LeftJoinWithArrayContainsToEquiJoinCondition(metadata.getFunctionAndTypeManager()))), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new LeftJoinNullFilterToSemiJoin(metadata.getFunctionAndTypeManager()))), new KeyBasedSampler(metadata, sqlParser), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, new PickTableLayout(metadata).rules()), new PruneUnreferencedOutputs(), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, Optional.of(new LogicalPropertiesProviderImpl(new FunctionResolution(metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()))), (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct(), (Object)new RemoveRedundantTopN(), (Object)new RemoveRedundantTopNColumns(), (Object)new RemoveRedundantSort(), (Object)new RemoveRedundantSortColumns(), (Object)new RemoveRedundantLimit(), (Object[])new Rule[]{new RemoveRedundantDistinctLimit(), new RemoveRedundantAggregateDistinct(), new RemoveRedundantIdentityProjections(), new PushAggregationThroughOuterJoin(metadata.getFunctionAndTypeManager())})), inlineProjections, simplifyRowExpressionOptimizer, projectionPushDown, new PayloadJoinOptimizer(metadata), new UnaliasSymbolReferences(metadata.getFunctionAndTypeManager()), new ReplaceConstantVariableReferencesWithConstants(metadata.getFunctionAndTypeManager()), simplifyRowExpressionOptimizer, new ReplaceConstantVariableReferencesWithConstants(metadata.getFunctionAndTypeManager()), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new SimplifySortWithConstantInput(), (Object)new SimplifyTopNWithConstantInput(), (Object)new PullConstantsAboveGroupBy())), inlineProjections, new PruneUnreferencedOutputs(), new IndexJoinOptimizer(metadata), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, Optional.of(new LogicalPropertiesProviderImpl(new FunctionResolution(metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()))), (Set<Rule<?>>)ImmutableSet.of((Object)new AddNotNullFiltersToJoinNode(metadata.getFunctionAndTypeManager()))), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new SimplifyCountOverConstant(metadata.getFunctionAndTypeManager()))), new LimitPushDown(), new WindowFilterPushDown(metadata), prefilterForLimitingAggregation, new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll(GatherAndMergeWindows.rules()).build()), inlineProjections, new PruneUnreferencedOutputs(), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new InlineSqlFunctions(metadata, sqlParser).rules()).build())});
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new EliminateCrossJoins())), predicatePushDown, simplifyRowExpressionOptimizer});
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new PushDownDereferences(metadata).rules()).build()), new PruneUnreferencedOutputs()});
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, new PickTableLayout(metadata).rules()));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RewriteFilterWithExternalFunctionToProject(metadata.getFunctionAndTypeManager()), (Object)new PlanRemoteProjections(metadata.getFunctionAndTypeManager()))));
        builder.add((Object[])new PlanOptimizer[]{new ApplyConnectorOptimization((Supplier<Map<ConnectorId, Set<ConnectorPlanOptimizer>>>)((Supplier)() -> planOptimizerManager.getOptimizers(ConnectorPlanOptimizerManager.PlanPhase.LOGICAL))), projectionPushDown, new PruneUnreferencedOutputs()});
        builder.add((Object[])new PlanOptimizer[]{new SimplifyPlanWithEmptyInput(), new PruneUnreferencedOutputs()});
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new PruneRedundantProjectionAssignments())), new PushdownSubfields(metadata)});
        builder.add((Object)predicatePushDown);
        builder.add((Object)simplifyRowExpressionOptimizer);
        builder.add((Object)new MetadataQueryOptimizer(metadata));
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new EliminateCrossJoins())), predicatePushDown, simplifyRowExpressionOptimizer});
        builder.add((Object)new OptimizeMixedDistinctAggregations(metadata));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new CreatePartialTopN(), (Object)new PushTopNThroughUnion())));
        builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new HistoricalStatisticsEquivalentPlanMarkingOptimizer(statsCalculator)));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ReorderJoins(costComparator, metadata))));
        builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new HistoricalStatisticsEquivalentPlanMarkingOptimizer(statsCalculator)));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, Optional.of(new LogicalPropertiesProviderImpl(new FunctionResolution(metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()))), (Set<Rule<?>>)ImmutableSet.of((Object)new TransformDistinctInnerJoinToLeftEarlyOutJoin(), (Object)new TransformDistinctInnerJoinToRightEarlyOutJoin(), (Object)new RemoveRedundantDistinct(), (Object)new RemoveRedundantTopN(), (Object)new RemoveRedundantSort(), (Object)new RemoveRedundantLimit(), (Object[])new Rule[]{new RemoveRedundantDistinctLimit(), new RemoveRedundantAggregateDistinct(), new RemoveRedundantIdentityProjections(), new PushAggregationThroughOuterJoin(metadata.getFunctionAndTypeManager())})));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll(new ExtractSpatialJoins(metadata, splitManager, pageSourceManager).rules()).add((Object)new InlineProjections(metadata.getFunctionAndTypeManager())).build()));
        builder.add((Object)new RemoveRedundantDistinctAggregation());
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ScaledWriterRule())));
        if (!forceSingleNode) {
            builder.add((Object)new ReplicateSemiJoinInDelete());
            builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new DetermineJoinDistributionType(costComparator, taskCountEstimator), (Object)new DetermineSemiJoinDistributionType(costComparator, taskCountEstimator))));
            builder.add((Object[])new PlanOptimizer[]{new RandomizeNullKeyInOuterJoin(metadata.getFunctionAndTypeManager(), statsCalculator), new PruneUnreferencedOutputs(), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PruneRedundantProjectionAssignments(), (Object)new InlineProjections(metadata.getFunctionAndTypeManager()), (Object)new RemoveRedundantIdentityProjections()))});
            builder.add((Object[])new PlanOptimizer[]{new ShardJoins(metadata, metadata.getFunctionAndTypeManager(), statsCalculator), new PruneUnreferencedOutputs()});
            builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushTableWriteThroughUnion())));
            builder.add((Object)new CteProjectionAndPredicatePushDown(metadata));
            builder.add((Object)new PhysicalCteOptimizer(metadata));
            builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new AddExchanges(metadata, sqlParser, partitioningProviderManager, featuresConfig.isNativeExecutionEnabled())));
        }
        estimatedExchangesCostCalculator = null;
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveEmptyDelete())));
        builder.add((Object)predicatePushDown);
        builder.add((Object)new RemoveUnsupportedDynamicFilters(metadata.getFunctionAndTypeManager()));
        builder.add((Object)simplifyRowExpressionOptimizer);
        builder.add((Object)projectionPushDown);
        builder.add((Object)inlineProjections);
        builder.add((Object)new UnaliasSymbolReferences(metadata.getFunctionAndTypeManager()));
        builder.add((Object)new PruneUnreferencedOutputs());
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).add((Object)new PushRemoteExchangeThroughAssignUniqueId()).add((Object)new PushRemoteExchangeThroughGroupId(metadata)).add((Object)new InlineProjections(metadata.getFunctionAndTypeManager())).build()));
        builder.add((Object)new MergeJoinForSortedInputOptimizer(metadata, sqlParser));
        builder.add((Object)new AddLocalExchanges(metadata, sqlParser, featuresConfig.isNativeExecutionEnabled()));
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushPartialAggregationThroughJoin(), (Object)new PushPartialAggregationThroughExchange(metadata.getFunctionAndTypeManager(), featuresConfig.isNativeExecutionEnabled()))), new MergePartialAggregationsWithFilter(metadata.getFunctionAndTypeManager()), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PruneJoinColumns()))});
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new AddIntermediateAggregations(), (Object)new RemoveRedundantIdentityProjections())));
        builder.add((Object[])new PlanOptimizer[]{new ApplyConnectorOptimization((Supplier<Map<ConnectorId, Set<ConnectorPlanOptimizer>>>)((Supplier)() -> planOptimizerManager.getOptimizers(ConnectorPlanOptimizerManager.PlanPhase.PHYSICAL))), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new PruneRedundantProjectionAssignments()))});
        builder.add((Object)new HashGenerationOptimizer(metadata.getFunctionAndTypeManager()));
        builder.add((Object)new MetadataDeleteOptimizer(metadata));
        this.planningTimeOptimizers = builder.build();
        ImmutableList.Builder runtimeBuilder = ImmutableList.builder();
        runtimeBuilder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (List<PlanOptimizer>)ImmutableList.of(), (Set<Rule<?>>)ImmutableSet.of((Object)new RuntimeReorderJoinSides(metadata, sqlParser))));
        this.runtimeOptimizers = runtimeBuilder.build();
    }

    public List<PlanOptimizer> getPlanningTimeOptimizers() {
        return this.planningTimeOptimizers;
    }

    public List<PlanOptimizer> getRuntimeOptimizers() {
        return this.runtimeOptimizers;
    }
}

