/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class LeftJoinNullFilterToSemiJoin
implements Rule<FilterNode> {
    private static final Capture<JoinNode> CHILD = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.join().matching(x -> x.getType().equals((Object)JoinType.LEFT) && x.getCriteria().size() == 1 && !x.getFilter().isPresent() && x.getDynamicFilters().isEmpty()).capturedAs(CHILD)));
    private final FunctionAndTypeManager functionAndTypeManager;

    public LeftJoinNullFilterToSemiJoin(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = functionAndTypeManager;
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isRewriteLeftJoinNullFilterToSemiJoinEnabled(session);
    }

    private boolean isRightKeyNullExpression(RowExpression expression, VariableReferenceExpression rightKey) {
        return expression instanceof SpecialFormExpression && ((SpecialFormExpression)expression).getForm().equals((Object)SpecialFormExpression.Form.IS_NULL) && ((RowExpression)((SpecialFormExpression)expression).getArguments().get(0)).equals((Object)rightKey);
    }

    @Override
    public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
        JoinNode joinNode = (JoinNode)((Object)captures.get(CHILD));
        VariableReferenceExpression rightKey = joinNode.getCriteria().get(0).getRight();
        VariableReferenceExpression leftKey = joinNode.getCriteria().get(0).getLeft();
        if (joinNode.getOutputVariables().stream().anyMatch(x -> joinNode.getRight().getOutputVariables().contains(x) && !x.equals((Object)rightKey))) {
            return Rule.Result.empty();
        }
        List andConjuncts = LogicalRowExpressions.extractConjuncts((RowExpression)filterNode.getPredicate());
        List rightKeyNull = (List)andConjuncts.stream().filter(x -> this.isRightKeyNullExpression((RowExpression)x, rightKey)).collect(ImmutableList.toImmutableList());
        if (rightKeyNull.isEmpty()) {
            return Rule.Result.empty();
        }
        List remainingConjunct = (List)andConjuncts.stream().filter(x -> !rightKeyNull.contains(x)).collect(ImmutableList.toImmutableList());
        List variablesInRemainingConjuncts = (List)remainingConjunct.stream().flatMap(x -> VariablesExtractor.extractAll(x).stream()).collect(ImmutableList.toImmutableList());
        if (variablesInRemainingConjuncts.stream().anyMatch(x -> joinNode.getRight().getOutputVariables().contains(x))) {
            return Rule.Result.empty();
        }
        VariableReferenceExpression semiJoinOutput = context.getVariableAllocator().newVariable("semiJoinOutput", (Type)BooleanType.BOOLEAN);
        SemiJoinNode semiJoinNode = new SemiJoinNode(filterNode.getSourceLocation(), context.getIdAllocator().getNextId(), joinNode.getLeft(), joinNode.getRight(), leftKey, rightKey, semiJoinOutput, Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
        CallExpression filterExpression = Expressions.not(this.functionAndTypeManager, (RowExpression)Expressions.coalesceNullToFalse((RowExpression)semiJoinOutput));
        FilterNode semiFilterNode = new FilterNode(filterNode.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)semiJoinNode, (RowExpression)filterExpression);
        Map outputAssignments = (Map)filterNode.getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), x -> x.equals((Object)rightKey) ? Expressions.constantNull(rightKey.getType()) : x));
        ProjectNode planNode = new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)semiFilterNode, Assignments.builder().putAll(outputAssignments).build());
        if (!remainingConjunct.isEmpty()) {
            planNode = new FilterNode(filterNode.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)planNode, LogicalRowExpressions.and((Collection)remainingConjunct));
        }
        return Rule.Result.ofPlanNode((PlanNode)planNode);
    }
}

