/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SimplifyCardinalityMapRewriter {
    private static final Set<String> MAP_FUNCTIONS = ImmutableSet.of((Object)"map_values", (Object)"map_keys");

    private SimplifyCardinalityMapRewriter() {
    }

    public static RowExpression rewrite(RowExpression expression, FunctionAndTypeManager functionAndTypeManager, Session session) {
        return RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)new Visitor(functionAndTypeManager, session), (RowExpression)expression);
    }

    private static class Visitor
    extends RowExpressionRewriter<Void> {
        private final FunctionAndTypeManager functionAndTypeManager;
        private final Session session;

        public Visitor(FunctionAndTypeManager functionAndTypeManager, Session session) {
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public RowExpression rewriteCall(CallExpression node, Void context, RowExpressionTreeRewriter<Void> treeRewriter) {
            RowExpression argument;
            if (node.getDisplayName().equals("cardinality") && node.getArguments().size() == 1 && (argument = (RowExpression)Iterables.getOnlyElement((Iterable)node.getArguments())) instanceof CallExpression) {
                CallExpression callExpression = (CallExpression)argument;
                if (MAP_FUNCTIONS.contains(callExpression.getDisplayName()) && callExpression.getArguments().size() == 1) {
                    RowExpression rewrittenArgument = treeRewriter.rewrite((RowExpression)Iterables.getOnlyElement((Iterable)callExpression.getArguments()), (Object)context);
                    ImmutableList types = ImmutableList.of((Object)rewrittenArgument.getType());
                    FunctionHandle rewrittenFunctionHandle = this.functionAndTypeManager.resolveFunction(Optional.of(this.session.getSessionFunctions()), this.session.getTransactionId(), QualifiedObjectName.valueOf((String)node.getFunctionHandle().getName()), TypeSignatureProvider.fromTypes((List)types));
                    return this.newFunctionIfRewritten(rewrittenFunctionHandle, node, (List<RowExpression>)ImmutableList.of((Object)rewrittenArgument));
                }
            }
            ImmutableList.Builder rewrittenArguments = ImmutableList.builder();
            for (RowExpression argument2 : node.getArguments()) {
                rewrittenArguments.add((Object)treeRewriter.rewrite(argument2, (Object)context));
            }
            return this.newFunctionIfRewritten(node.getFunctionHandle(), node, (List<RowExpression>)rewrittenArguments.build());
        }

        private RowExpression newFunctionIfRewritten(FunctionHandle rewrittenFunctionHandle, CallExpression node, List<RowExpression> rewrittenArguments) {
            if (!node.getArguments().equals(rewrittenArguments) || !rewrittenFunctionHandle.equals(node.getFunctionHandle())) {
                return new CallExpression(node.getSourceLocation(), node.getDisplayName(), rewrittenFunctionHandle, node.getType(), rewrittenArguments);
            }
            return node;
        }
    }
}

