/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.InSubqueryExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode().with(Pattern.empty(Patterns.Apply.correlation()));

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isExploitConstraints(session) && SystemSessionProperties.getJoinReorderingStrategy(session) == FeaturesConfig.JoinReorderingStrategy.AUTOMATIC && SystemSessionProperties.isInPredicatesAsInnerJoinsEnabled(session);
    }

    @Override
    public Rule.Result apply(ApplyNode applyNode, Captures captures, Rule.Context context) {
        if (applyNode.getMayParticipateInAntiJoin()) {
            return Rule.Result.empty();
        }
        Assignments subqueryAssignments = applyNode.getSubqueryAssignments();
        if (subqueryAssignments.size() != 1) {
            return Rule.Result.empty();
        }
        RowExpression expression = (RowExpression)Iterables.getOnlyElement((Iterable)subqueryAssignments.getExpressions());
        if (!(expression instanceof InSubqueryExpression)) {
            return Rule.Result.empty();
        }
        InSubqueryExpression inPredicate = (InSubqueryExpression)expression;
        VariableReferenceExpression inPredicateOutputVariable = (VariableReferenceExpression)Iterables.getOnlyElement((Iterable)subqueryAssignments.getVariables());
        PlanNode leftInput = applyNode.getInput();
        if (!((GroupReference)leftInput).getLogicalProperties().isPresent() || !((GroupReference)leftInput).getLogicalProperties().get().isDistinct((Set)ImmutableSet.copyOf((Collection)leftInput.getOutputVariables()))) {
            VariableReferenceExpression uniqueKeyVariable = context.getVariableAllocator().newVariable("unique", (Type)BigintType.BIGINT);
            leftInput = new AssignUniqueId(applyNode.getSourceLocation(), context.getIdAllocator().getNextId(), leftInput, uniqueKeyVariable);
        }
        VariableReferenceExpression leftVariableReference = inPredicate.getValue();
        VariableReferenceExpression rightVariableReference = inPredicate.getSubquery();
        JoinNode innerJoin = new JoinNode(applyNode.getSourceLocation(), context.getIdAllocator().getNextId(), JoinType.INNER, leftInput, applyNode.getSubquery(), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(leftVariableReference, rightVariableReference)), (List<VariableReferenceExpression>)ImmutableList.builder().addAll((Iterable)leftInput.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
        AggregationNode distinctNode = new AggregationNode(innerJoin.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)innerJoin, (Map)ImmutableMap.of(), AggregationNode.singleGroupingSet((List)ImmutableList.builder().addAll(innerJoin.getOutputVariables()).build()), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty(), Optional.empty());
        ImmutableList referencedOutputs = ImmutableList.builder().addAll((Iterable)applyNode.getInput().getOutputVariables()).add((Object)inPredicateOutputVariable).build();
        ProjectNode finalProjectNdde = new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)distinctNode, Assignments.builder().putAll(AssignmentUtils.identityAssignments(distinctNode.getOutputVariables())).put(inPredicateOutputVariable, (RowExpression)LogicalRowExpressions.TRUE_CONSTANT).build().filter((Collection)referencedOutputs));
        return Rule.Result.ofPlanNode((PlanNode)finalProjectNdde);
    }
}

