/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.ConnectorJoinNode;
import com.facebook.presto.spi.plan.CteConsumerNode;
import com.facebook.presto.spi.plan.CteProducerNode;
import com.facebook.presto.spi.plan.CteReferenceNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.ExceptNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.IntersectNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ApplyConnectorOptimization
implements PlanOptimizer {
    static final Set<Class<? extends PlanNode>> CONNECTOR_ACCESSIBLE_PLAN_NODES = ImmutableSet.of(CteProducerNode.class, CteConsumerNode.class, CteReferenceNode.class, DistinctLimitNode.class, FilterNode.class, TableScanNode.class, (Object[])new Class[]{LimitNode.class, SortNode.class, TopNNode.class, ValuesNode.class, ProjectNode.class, AggregationNode.class, MarkDistinctNode.class, UnionNode.class, IntersectNode.class, ExceptNode.class});
    private static final ConnectorId EMPTY_CONNECTOR_ID = new ConnectorId("$internal$" + ApplyConnectorOptimization.class + "_CONNECTOR");
    private final Supplier<Map<ConnectorId, Set<ConnectorPlanOptimizer>>> connectorOptimizersSupplier;

    public ApplyConnectorOptimization(Supplier<Map<ConnectorId, Set<ConnectorPlanOptimizer>>> connectorOptimizersSupplier) {
        this.connectorOptimizersSupplier = Objects.requireNonNull(connectorOptimizersSupplier, "connectorOptimizersSupplier is null");
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Map connectorOptimizers = (Map)this.connectorOptimizersSupplier.get();
        if (connectorOptimizers.isEmpty()) {
            return PlanOptimizerResult.optimizerResult(plan, false);
        }
        ImmutableSet.Builder connectorIds = ImmutableSet.builder();
        ApplyConnectorOptimization.getAllConnectorIds(plan, (ImmutableSet.Builder<ConnectorId>)connectorIds);
        for (ConnectorId connectorId : connectorIds.build()) {
            Set optimizers = (Set)connectorOptimizers.get(connectorId);
            if (optimizers == null) continue;
            ImmutableMap.Builder contextMapBuilder = ImmutableMap.builder();
            ApplyConnectorOptimization.buildConnectorPlanNodeContext(plan, null, (ImmutableMap.Builder<PlanNode, ConnectorPlanNodeContext>)contextMapBuilder);
            ImmutableMap contextMap = contextMapBuilder.build();
            HashMap<PlanNode, PlanNode> updates = new HashMap<PlanNode, PlanNode>();
            for (PlanNode node : contextMap.keySet()) {
                ConnectorPlanNodeContext context = (ConnectorPlanNodeContext)contextMap.get(node);
                if (!context.isClosure(connectorId) || !context.getParent().isPresent() || ((ConnectorPlanNodeContext)contextMap.get(context.getParent().get())).isClosure(connectorId)) continue;
                PlanNode newNode = node;
                for (ConnectorPlanOptimizer optimizer : optimizers) {
                    newNode = optimizer.optimize(newNode, session.toConnectorSession(connectorId), variableAllocator, idAllocator);
                }
                if (node == newNode) continue;
                Preconditions.checkState((boolean)ApplyConnectorOptimization.containsAll(ImmutableSet.copyOf((Collection)newNode.getOutputVariables()), node.getOutputVariables()), (String)"the connector optimizer from %s returns a node that does not cover all output before optimization", (Object)connectorId);
                newNode = SimplePlanRewriter.rewriteWith(new ConnectorToInternalJoinRewriter(), newNode);
                updates.put(node, newNode);
            }
            LinkedList originalNodes = new LinkedList(updates.keySet());
            while (!originalNodes.isEmpty()) {
                PlanNode originalNode = (PlanNode)originalNodes.poll();
                if (!((ConnectorPlanNodeContext)contextMap.get(originalNode)).getParent().isPresent()) {
                    plan = (PlanNode)updates.get(originalNode);
                    continue;
                }
                PlanNode originalParent = ((ConnectorPlanNodeContext)contextMap.get(originalNode)).getParent().get();
                ImmutableList.Builder newChildren = ImmutableList.builder();
                originalParent.getSources().forEach(child -> newChildren.add((Object)updates.getOrDefault(child, (PlanNode)child)));
                PlanNode newParent = originalParent.replaceChildren((List)newChildren.build());
                updates.put(originalParent, newParent);
                originalNodes.add(originalParent);
            }
        }
        return PlanOptimizerResult.optimizerResult(plan, true);
    }

    private static void getAllConnectorIds(PlanNode node, ImmutableSet.Builder<ConnectorId> builder) {
        if (node.getSources().isEmpty()) {
            if (node instanceof TableScanNode) {
                builder.add((Object)((TableScanNode)node).getTable().getConnectorId());
            } else {
                builder.add((Object)EMPTY_CONNECTOR_ID);
            }
            return;
        }
        for (PlanNode child : node.getSources()) {
            ApplyConnectorOptimization.getAllConnectorIds(child, builder);
        }
    }

    private static ConnectorPlanNodeContext buildConnectorPlanNodeContext(PlanNode node, PlanNode parent, ImmutableMap.Builder<PlanNode, ConnectorPlanNodeContext> contextBuilder) {
        ImmutableSet planNodeTypes;
        ImmutableSet connectorIds;
        if (node.getSources().isEmpty()) {
            if (node instanceof TableScanNode) {
                connectorIds = ImmutableSet.of((Object)((TableScanNode)node).getTable().getConnectorId());
                planNodeTypes = ImmutableSet.of(TableScanNode.class);
            } else {
                connectorIds = ImmutableSet.of((Object)EMPTY_CONNECTOR_ID);
                planNodeTypes = ImmutableSet.of(node.getClass());
            }
        } else {
            connectorIds = new HashSet();
            planNodeTypes = new HashSet();
            for (PlanNode child : node.getSources()) {
                ConnectorPlanNodeContext childContext = ApplyConnectorOptimization.buildConnectorPlanNodeContext(child, node, contextBuilder);
                connectorIds.addAll(childContext.getReachableConnectors());
                planNodeTypes.addAll(childContext.getReachablePlanNodeTypes());
            }
            planNodeTypes.add(node.getClass());
        }
        ConnectorPlanNodeContext connectorPlanNodeContext = new ConnectorPlanNodeContext(parent, (Set<ConnectorId>)connectorIds, (Set<Class<? extends PlanNode>>)planNodeTypes);
        contextBuilder.put((Object)node, (Object)connectorPlanNodeContext);
        return connectorPlanNodeContext;
    }

    private static <T> boolean containsAll(Set<T> container, Collection<T> test) {
        for (T element : test) {
            if (container.contains(element)) continue;
            return false;
        }
        return true;
    }

    private static class ConnectorToInternalJoinRewriter
    extends SimplePlanRewriter<Void> {
        private ConnectorToInternalJoinRewriter() {
        }

        public PlanNode visitConnectorJoinNode(ConnectorJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new JoinNode(node.getSourceLocation(), node.getId(), node.getStatsEquivalentPlanNode(), node.getType(), context.rewrite((PlanNode)node.getSources().get(0)), context.rewrite((PlanNode)node.getSources().get(1)), (List<EquiJoinClause>)ImmutableList.copyOf((Collection)node.getCriteria()), node.getOutputVariables(), node.getFilters().isEmpty() ? Optional.empty() : Optional.of(LogicalRowExpressions.and((Collection)node.getFilters())), Optional.empty(), Optional.empty(), node.getDistributionType(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
        }
    }

    private static final class ConnectorPlanNodeContext {
        private final PlanNode parent;
        private final Set<ConnectorId> reachableConnectors;
        private final Set<Class<? extends PlanNode>> reachablePlanNodeTypes;

        ConnectorPlanNodeContext(PlanNode parent, Set<ConnectorId> reachableConnectors, Set<Class<? extends PlanNode>> reachablePlanNodeTypes) {
            this.parent = parent;
            this.reachableConnectors = Objects.requireNonNull(reachableConnectors, "reachableConnectors is null");
            this.reachablePlanNodeTypes = Objects.requireNonNull(reachablePlanNodeTypes, "reachablePlanNodeTypes is null");
            Preconditions.checkArgument((!reachableConnectors.isEmpty() ? 1 : 0) != 0, (Object)"encountered a PlanNode that reaches no connector");
            Preconditions.checkArgument((!reachablePlanNodeTypes.isEmpty() ? 1 : 0) != 0, (Object)"encountered a PlanNode that reaches no plan node");
        }

        Optional<PlanNode> getParent() {
            return Optional.ofNullable(this.parent);
        }

        public Set<ConnectorId> getReachableConnectors() {
            return this.reachableConnectors;
        }

        public Set<Class<? extends PlanNode>> getReachablePlanNodeTypes() {
            return this.reachablePlanNodeTypes;
        }

        boolean isClosure(ConnectorId connectorId) {
            if (this.reachableConnectors.size() != 1 || !this.reachableConnectors.contains(connectorId)) {
                return false;
            }
            return ApplyConnectorOptimization.containsAll(CONNECTOR_ACCESSIBLE_PLAN_NODES, this.reachablePlanNodeTypes);
        }
    }
}

