/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.ExceptNode;
import com.facebook.presto.spi.plan.IntersectNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.SetOperationNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.optimizations.SetOperationNodeUtils;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SetFlatteningOptimizer
implements PlanOptimizer {
    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Rewriter rewriter = new Rewriter();
        PlanNode rewrittenPlan = SimplePlanRewriter.rewriteWith(rewriter, plan, false);
        return PlanOptimizerResult.optimizerResult(rewrittenPlan, rewriter.isPlanChanged());
    }

    private static class Rewriter
    extends SimplePlanRewriter<Boolean> {
        private boolean planChanged;

        private Rewriter() {
        }

        public boolean isPlanChanged() {
            return this.planChanged;
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Boolean> context) {
            return context.defaultRewrite(node, false);
        }

        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Boolean> context) {
            ImmutableList.Builder flattenedSources = ImmutableList.builder();
            ImmutableListMultimap.Builder flattenedVariableMap = ImmutableListMultimap.builder();
            this.flattenSetOperation((SetOperationNode)node, context, (ImmutableList.Builder<PlanNode>)flattenedSources, (ImmutableListMultimap.Builder<VariableReferenceExpression, VariableReferenceExpression>)flattenedVariableMap);
            ImmutableListMultimap mappings = flattenedVariableMap.build();
            return new UnionNode(node.getSourceLocation(), node.getId(), (List)flattenedSources.build(), (List)ImmutableList.copyOf((Collection)mappings.keySet()), SetOperationNodeUtils.fromListMultimap((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)mappings));
        }

        public PlanNode visitIntersect(IntersectNode node, SimplePlanRewriter.RewriteContext<Boolean> context) {
            ImmutableList.Builder flattenedSources = ImmutableList.builder();
            ImmutableListMultimap.Builder flattenedVariableMap = ImmutableListMultimap.builder();
            this.flattenSetOperation((SetOperationNode)node, context, (ImmutableList.Builder<PlanNode>)flattenedSources, (ImmutableListMultimap.Builder<VariableReferenceExpression, VariableReferenceExpression>)flattenedVariableMap);
            ImmutableListMultimap mappings = flattenedVariableMap.build();
            return new IntersectNode(node.getSourceLocation(), node.getId(), (List)flattenedSources.build(), (List)ImmutableList.copyOf((Collection)mappings.keySet()), SetOperationNodeUtils.fromListMultimap((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)mappings));
        }

        public PlanNode visitExcept(ExceptNode node, SimplePlanRewriter.RewriteContext<Boolean> context) {
            ImmutableList.Builder flattenedSources = ImmutableList.builder();
            ImmutableListMultimap.Builder flattenedVariableMap = ImmutableListMultimap.builder();
            this.flattenSetOperation((SetOperationNode)node, context, (ImmutableList.Builder<PlanNode>)flattenedSources, (ImmutableListMultimap.Builder<VariableReferenceExpression, VariableReferenceExpression>)flattenedVariableMap);
            ImmutableListMultimap mappings = flattenedVariableMap.build();
            return new ExceptNode(node.getSourceLocation(), node.getId(), (List)flattenedSources.build(), (List)ImmutableList.copyOf((Collection)mappings.keySet()), SetOperationNodeUtils.fromListMultimap((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)mappings));
        }

        private void flattenSetOperation(SetOperationNode node, SimplePlanRewriter.RewriteContext<Boolean> context, ImmutableList.Builder<PlanNode> flattenedSources, ImmutableListMultimap.Builder<VariableReferenceExpression, VariableReferenceExpression> flattenedVariableMap) {
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = (PlanNode)node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(subplan, context.get());
                Class<?> setOperationClass = node.getClass();
                if (setOperationClass.isInstance(rewrittenSource) && (!setOperationClass.equals(ExceptNode.class) || i == 0)) {
                    SetOperationNode rewrittenSetOperation = (SetOperationNode)rewrittenSource;
                    flattenedSources.addAll((Iterable)rewrittenSetOperation.getSources());
                    this.planChanged = true;
                    for (Map.Entry entry : node.getVariableMapping().entrySet()) {
                        VariableReferenceExpression inputVariable = (VariableReferenceExpression)Iterables.get((Iterable)((Iterable)entry.getValue()), (int)i);
                        flattenedVariableMap.putAll(entry.getKey(), (Iterable)rewrittenSetOperation.getVariableMapping().get(inputVariable));
                    }
                    continue;
                }
                flattenedSources.add((Object)rewrittenSource);
                for (Map.Entry entry : node.getVariableMapping().entrySet()) {
                    flattenedVariableMap.put(entry.getKey(), Iterables.get((Iterable)((Iterable)entry.getValue()), (int)i));
                }
            }
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Boolean> context) {
            boolean distinct = Rewriter.isDistinctOperator(node);
            PlanNode rewrittenNode = context.rewrite(node.getSource(), distinct);
            if (context.get().booleanValue() && distinct) {
                return rewrittenNode;
            }
            return new AggregationNode(node.getSourceLocation(), node.getId(), rewrittenNode, node.getAggregations(), node.getGroupingSets(), (List)ImmutableList.of(), node.getStep(), node.getHashVariable(), node.getGroupIdVariable(), node.getAggregationId());
        }

        private static boolean isDistinctOperator(AggregationNode node) {
            return node.getAggregations().isEmpty();
        }
    }
}

