/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.function.SqlInvokedScalarFunctionImplementation;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.iterative.rule.LambdaCaptureDesugaringRewriter;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class SqlFunctionUtils {
    private SqlFunctionUtils() {
    }

    public static Expression getSqlFunctionExpression(FunctionMetadata functionMetadata, SqlInvokedScalarFunctionImplementation implementation, FunctionAndTypeResolver functionAndTypeResolver, VariableAllocator variableAllocator, SqlFunctionProperties sqlFunctionProperties, List<Expression> arguments) {
        Map<String, VariableReferenceExpression> argumentVariables = SqlFunctionUtils.allocateFunctionArgumentVariables(functionMetadata, functionAndTypeResolver, variableAllocator);
        Expression expression = SqlFunctionUtils.getSqlFunctionImplementationExpression(functionMetadata, implementation, functionAndTypeResolver, variableAllocator, sqlFunctionProperties, argumentVariables);
        return SqlFunctionArgumentBinder.bindFunctionArguments(expression, (List<String>)((List)functionMetadata.getArgumentNames().get()), arguments, argumentVariables);
    }

    public static RowExpression getSqlFunctionRowExpression(FunctionMetadata functionMetadata, SqlInvokedScalarFunctionImplementation implementation, FunctionAndTypeManager functionAndTypeManager, SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, List<RowExpression> arguments) {
        VariableAllocator variableAllocator = new VariableAllocator();
        Map<String, VariableReferenceExpression> argumentVariables = SqlFunctionUtils.allocateFunctionArgumentVariables(functionMetadata, functionAndTypeManager.getFunctionAndTypeResolver(), variableAllocator);
        Expression expression = SqlFunctionUtils.getSqlFunctionImplementationExpression(functionMetadata, implementation, functionAndTypeManager.getFunctionAndTypeResolver(), variableAllocator, sqlFunctionProperties, argumentVariables);
        return SqlFunctionArgumentBinder.bindFunctionArguments(SqlToRowExpressionTranslator.translate(expression, ExpressionAnalyzer.analyzeSqlFunctionExpression(functionAndTypeManager.getFunctionAndTypeResolver(), sqlFunctionProperties, expression, (Map)argumentVariables.values().stream().collect(ImmutableMap.toImmutableMap(VariableReferenceExpression::getName, VariableReferenceExpression::getType))).getExpressionTypes(), (Map<VariableReferenceExpression, Integer>)ImmutableMap.of(), functionAndTypeManager, Optional.empty(), Optional.empty(), sqlFunctionProperties, sessionFunctions, new SqlToRowExpressionTranslator.Context()), (List<String>)((List)functionMetadata.getArgumentNames().get()), arguments, argumentVariables);
    }

    private static Expression getSqlFunctionImplementationExpression(FunctionMetadata functionMetadata, SqlInvokedScalarFunctionImplementation implementation, FunctionAndTypeResolver functionAndTypeResolver, VariableAllocator variableAllocator, SqlFunctionProperties sqlFunctionProperties, Map<String, VariableReferenceExpression> argumentVariables) {
        Preconditions.checkArgument((boolean)functionMetadata.getImplementationType().equals((Object)FunctionImplementationType.SQL), (Object)String.format("Expect SQL function, get %s", functionMetadata.getImplementationType()));
        Preconditions.checkArgument((boolean)functionMetadata.getArgumentNames().isPresent(), (Object)"ArgumentNames is missing");
        Expression expression = SqlFunctionUtils.normalizeParameters((List)functionMetadata.getArgumentNames().get(), SqlFunctionUtils.parseSqlFunctionExpression(implementation, sqlFunctionProperties));
        ExpressionAnalysis functionAnalysis = ExpressionAnalyzer.analyzeSqlFunctionExpression(functionAndTypeResolver, sqlFunctionProperties, expression, (Map)argumentVariables.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((VariableReferenceExpression)entry.getValue()).getType())));
        expression = SqlFunctionUtils.coerceIfNecessary(expression, functionAnalysis);
        return SqlFunctionUtils.rewriteLambdaExpression(expression, argumentVariables, functionAnalysis, variableAllocator);
    }

    private static Expression normalizeParameters(List<String> argumentNames, Expression sqlFunction) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Map<String, String>>(){

            public Expression rewriteIdentifier(Identifier node, Map<String, String> context, ExpressionTreeRewriter<Map<String, String>> treeRewriter) {
                String name = node.getValueLowerCase();
                if (context.containsKey(name)) {
                    return new Identifier(context.get(name));
                }
                return node;
            }
        }, (Expression)sqlFunction, argumentNames.stream().collect(ImmutableMap.toImmutableMap(String::toLowerCase, Function.identity())));
    }

    private static Expression parseSqlFunctionExpression(SqlInvokedScalarFunctionImplementation functionImplementation, SqlFunctionProperties sqlFunctionProperties) {
        ParsingOptions parsingOptions = ParsingOptions.builder().setDecimalLiteralTreatment(sqlFunctionProperties.isParseDecimalLiteralAsDouble() ? ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE : ParsingOptions.DecimalLiteralTreatment.AS_DECIMAL).build();
        return new SqlParser().createReturn(functionImplementation.getImplementation(), parsingOptions).getExpression();
    }

    private static Map<String, VariableReferenceExpression> allocateFunctionArgumentVariables(FunctionMetadata functionMetadata, FunctionAndTypeResolver functionAndTypeResolver, VariableAllocator variableAllocator) {
        List argumentNames = (List)functionMetadata.getArgumentNames().get();
        List argumentTypes = (List)functionMetadata.getArgumentTypes().stream().map(arg_0 -> ((FunctionAndTypeResolver)functionAndTypeResolver).getType(arg_0)).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((argumentNames.size() == argumentTypes.size() ? 1 : 0) != 0, (Object)String.format("Expect argumentNames (size %d) and argumentTypes (size %d) to be of the same size", argumentNames.size(), argumentTypes.size()));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < argumentNames.size(); ++i) {
            builder.put(argumentNames.get(i), (Object)variableAllocator.newVariable((String)argumentNames.get(i), (Type)argumentTypes.get(i)));
        }
        return builder.build();
    }

    private static Expression rewriteLambdaExpression(Expression sqlFunction, Map<String, VariableReferenceExpression> arguments, ExpressionAnalysis functionAnalysis, VariableAllocator variableAllocator) {
        Map lambdaArgumentReferences = functionAnalysis.getLambdaArgumentReferences();
        Map expressionTypes = functionAnalysis.getExpressionTypes();
        final Map variables = (Map)expressionTypes.entrySet().stream().filter(entry -> ((NodeRef)entry.getKey()).getNode() instanceof LambdaArgumentDeclaration).distinct().collect(ImmutableMap.toImmutableMap(entry -> NodeRef.of((Node)((LambdaArgumentDeclaration)((NodeRef)entry.getKey()).getNode())), entry -> PlannerUtils.newVariable(variableAllocator, (Expression)((LambdaArgumentDeclaration)((NodeRef)entry.getKey()).getNode()).getName(), (Type)entry.getValue(), "lambda")));
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Map<NodeRef<Identifier>, LambdaArgumentDeclaration>>(){

            public Expression rewriteLambdaExpression(LambdaExpression node, Map<NodeRef<Identifier>, LambdaArgumentDeclaration> context, ExpressionTreeRewriter<Map<NodeRef<Identifier>, LambdaArgumentDeclaration>> treeRewriter) {
                return new LambdaExpression((List)node.getArguments().stream().map(argument -> new LambdaArgumentDeclaration(new Identifier(((VariableReferenceExpression)variables.get(NodeRef.of((Node)argument))).getName()))).collect(ImmutableList.toImmutableList()), treeRewriter.rewrite(node.getBody(), context));
            }

            public Expression rewriteIdentifier(Identifier node, Map<NodeRef<Identifier>, LambdaArgumentDeclaration> context, ExpressionTreeRewriter<Map<NodeRef<Identifier>, LambdaArgumentDeclaration>> treeRewriter) {
                NodeRef ref = NodeRef.of((Node)node);
                if (context.containsKey(ref)) {
                    return ExpressionTreeUtils.createSymbolReference((VariableReferenceExpression)variables.get(NodeRef.of((Node)((Node)context.get(ref)))));
                }
                return node;
            }
        }, (Expression)sqlFunction, (Object)lambdaArgumentReferences);
        rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Map<String, VariableReferenceExpression>>(){

            public Expression rewriteIdentifier(Identifier node, Map<String, VariableReferenceExpression> context, ExpressionTreeRewriter<Map<String, VariableReferenceExpression>> treeRewriter) {
                if (context.containsKey(node.getValue())) {
                    return ExpressionTreeUtils.createSymbolReference(context.get(node.getValue()));
                }
                return node;
            }
        }, (Expression)rewritten, arguments);
        return LambdaCaptureDesugaringRewriter.rewrite(rewritten, variableAllocator);
    }

    private static Expression coerceIfNecessary(Expression sqlFunction, final ExpressionAnalysis analysis) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<ExpressionAnalysis>(){

            public Expression rewriteExpression(Expression expression, ExpressionAnalysis context, ExpressionTreeRewriter<ExpressionAnalysis> treeRewriter) {
                Expression rewritten = treeRewriter.defaultRewrite(expression, null);
                Type coercion = analysis.getCoercion(expression);
                if (coercion != null) {
                    return new Cast(rewritten, coercion.getTypeSignature().toString(), false, analysis.isTypeOnlyCoercion(expression));
                }
                return rewritten;
            }
        }, (Expression)sqlFunction, (Object)analysis);
    }

    private static final class SqlFunctionArgumentBinder {
        private SqlFunctionArgumentBinder() {
        }

        public static Expression bindFunctionArguments(Expression function, List<String> argumentNames, List<Expression> argumentValues, Map<String, VariableReferenceExpression> argumentVariables) {
            Preconditions.checkArgument((argumentNames.size() == argumentValues.size() ? 1 : 0) != 0, (Object)String.format("Expect same size for argumentNames (%d) and argumentValues (%d)", argumentNames.size(), argumentValues.size()));
            ImmutableMap.Builder argumentBindings = ImmutableMap.builder();
            for (int i = 0; i < argumentNames.size(); ++i) {
                String argumentName = argumentNames.get(i);
                argumentBindings.put((Object)argumentVariables.get(argumentName).getName(), (Object)argumentValues.get(i));
            }
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionFunctionVisitor(), (Expression)function, (Object)argumentBindings.build());
        }

        public static RowExpression bindFunctionArguments(RowExpression function, List<String> argumentNames, List<RowExpression> argumentValues, Map<String, VariableReferenceExpression> argumentVariables) {
            Preconditions.checkArgument((argumentNames.size() == argumentValues.size() ? 1 : 0) != 0, (Object)String.format("Expect same size for argumentNames (%d) and argumentValues (%d)", argumentNames.size(), argumentValues.size()));
            ImmutableMap.Builder argumentBindings = ImmutableMap.builder();
            for (int i = 0; i < argumentNames.size(); ++i) {
                String argumentName = argumentNames.get(i);
                argumentBindings.put((Object)argumentVariables.get(argumentName).getName(), (Object)argumentValues.get(i));
            }
            return RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)new RowExpressionRewriter<Map<String, RowExpression>>(){

                public RowExpression rewriteVariableReference(VariableReferenceExpression variable, Map<String, RowExpression> context, RowExpressionTreeRewriter<Map<String, RowExpression>> treeRewriter) {
                    if (context.containsKey(variable.getName())) {
                        return context.get(variable.getName());
                    }
                    return variable;
                }
            }, (RowExpression)function, (Object)argumentBindings.build());
        }

        private static class ExpressionFunctionVisitor
        extends ExpressionRewriter<Map<String, Expression>> {
            private ExpressionFunctionVisitor() {
            }

            public Expression rewriteSymbolReference(SymbolReference node, Map<String, Expression> context, ExpressionTreeRewriter<Map<String, Expression>> treeRewriter) {
                if (context.containsKey(node.getName())) {
                    return context.get(node.getName());
                }
                return node;
            }
        }
    }
}

