/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.spi.eventlistener.EventListenerFactory;
import com.facebook.presto.spi.eventlistener.QueryCompletedEvent;
import com.facebook.presto.spi.eventlistener.QueryCreatedEvent;
import com.facebook.presto.spi.eventlistener.QueryUpdatedEvent;
import com.facebook.presto.spi.eventlistener.SplitCompletedEvent;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class TestingEventListenerManager
extends EventListenerManager {
    private final AtomicReference<Optional<EventListener>> configuredEventListener = new AtomicReference(Optional.empty());

    @Override
    public void addEventListenerFactory(EventListenerFactory eventListenerFactory) {
        this.configuredEventListener.set(Optional.of(eventListenerFactory.create((Map)ImmutableMap.of())));
    }

    @Override
    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        if (this.configuredEventListener.get().isPresent()) {
            this.configuredEventListener.get().get().queryCompleted(queryCompletedEvent);
        }
    }

    @Override
    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
        if (this.configuredEventListener.get().isPresent()) {
            this.configuredEventListener.get().get().queryCreated(queryCreatedEvent);
        }
    }

    @Override
    public void queryUpdated(QueryUpdatedEvent queryUpdatedEvent) {
        if (this.configuredEventListener.get().isPresent()) {
            this.configuredEventListener.get().get().queryUpdated(queryUpdatedEvent);
        }
    }

    @Override
    public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
        if (this.configuredEventListener.get().isPresent()) {
            this.configuredEventListener.get().get().splitCompleted(splitCompletedEvent);
        }
    }

    public Optional<EventListener> getEventListener() {
        return this.configuredEventListener.get();
    }
}

