/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.DisjointRangeDomainHistogram;
import com.facebook.presto.cost.HistogramCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatisticRange;
import com.facebook.presto.cost.UniformDistributionHistogram;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.util.MoreMath;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public final class ComparisonStatsCalculator {
    private static final Logger log = Logger.get(ComparisonStatsCalculator.class);
    private final boolean useHistograms;

    public ComparisonStatsCalculator(Session session) {
        Objects.requireNonNull(session, "session is null");
        this.useHistograms = SystemSessionProperties.shouldOptimizerUseHistograms(session);
    }

    public PlanNodeStatsEstimate estimateExpressionToLiteralComparison(PlanNodeStatsEstimate inputStatistics, VariableStatsEstimate expressionStatistics, Optional<VariableReferenceExpression> expressionVariable, OptionalDouble literalValue, ComparisonExpression.Operator operator) {
        switch (operator) {
            case EQUAL: {
                return this.estimateExpressionEqualToLiteral(inputStatistics, expressionStatistics, expressionVariable, literalValue);
            }
            case NOT_EQUAL: {
                return this.estimateExpressionNotEqualToLiteral(inputStatistics, expressionStatistics, expressionVariable, literalValue);
            }
            case LESS_THAN: {
                return this.estimateExpressionLessThanLiteral(inputStatistics, expressionStatistics, expressionVariable, literalValue, false);
            }
            case LESS_THAN_OR_EQUAL: {
                return this.estimateExpressionLessThanLiteral(inputStatistics, expressionStatistics, expressionVariable, literalValue, true);
            }
            case GREATER_THAN: {
                return this.estimateExpressionGreaterThanLiteral(inputStatistics, expressionStatistics, expressionVariable, literalValue, false);
            }
            case GREATER_THAN_OR_EQUAL: {
                return this.estimateExpressionGreaterThanLiteral(inputStatistics, expressionStatistics, expressionVariable, literalValue, true);
            }
            case IS_DISTINCT_FROM: {
                return PlanNodeStatsEstimate.unknown();
            }
        }
        throw new IllegalArgumentException("Unexpected comparison operator: " + operator);
    }

    private PlanNodeStatsEstimate estimateExpressionEqualToLiteral(PlanNodeStatsEstimate inputStatistics, VariableStatsEstimate expressionStatistics, Optional<VariableReferenceExpression> expressionVariable, OptionalDouble literalValue) {
        StatisticRange filterRange = literalValue.isPresent() ? new StatisticRange(literalValue.getAsDouble(), false, literalValue.getAsDouble(), false, 1.0) : new StatisticRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        return this.estimateFilterRange(inputStatistics, expressionStatistics, expressionVariable, filterRange);
    }

    private PlanNodeStatsEstimate estimateExpressionNotEqualToLiteral(PlanNodeStatsEstimate inputStatistics, VariableStatsEstimate expressionStatistics, Optional<VariableReferenceExpression> expressionVariable, OptionalDouble literalValue) {
        StatisticRange filterRange = literalValue.isPresent() ? new StatisticRange(literalValue.getAsDouble(), false, literalValue.getAsDouble(), false, 1.0) : new StatisticRange(Double.NEGATIVE_INFINITY, true, Double.POSITIVE_INFINITY, true, 1.0);
        double filterFactor = 1.0 - this.calculateFilterFactor(expressionStatistics, filterRange);
        PlanNodeStatsEstimate.Builder estimate = PlanNodeStatsEstimate.buildFrom(inputStatistics);
        estimate.setOutputRowCount(filterFactor * (1.0 - expressionStatistics.getNullsFraction()) * inputStatistics.getOutputRowCount());
        if (expressionVariable.isPresent()) {
            VariableStatsEstimate symbolNewEstimate = VariableStatsEstimate.buildFrom(expressionStatistics).setNullsFraction(0.0).setDistinctValuesCount(MoreMath.max(expressionStatistics.getDistinctValuesCount() - 1.0, 0.0)).build();
            estimate = estimate.addVariableStatistics(expressionVariable.get(), symbolNewEstimate);
        }
        return estimate.build();
    }

    private PlanNodeStatsEstimate estimateExpressionLessThanLiteral(PlanNodeStatsEstimate inputStatistics, VariableStatsEstimate expressionStatistics, Optional<VariableReferenceExpression> expressionVariable, OptionalDouble literalValue, boolean equals) {
        StatisticRange filterRange = new StatisticRange(Double.NEGATIVE_INFINITY, true, literalValue.orElse(Double.POSITIVE_INFINITY), !equals, Double.NaN);
        return this.estimateFilterRange(inputStatistics, expressionStatistics, expressionVariable, filterRange);
    }

    private PlanNodeStatsEstimate estimateExpressionGreaterThanLiteral(PlanNodeStatsEstimate inputStatistics, VariableStatsEstimate expressionStatistics, Optional<VariableReferenceExpression> expressionVariable, OptionalDouble literalValue, boolean equals) {
        StatisticRange filterRange = new StatisticRange(literalValue.orElse(Double.NEGATIVE_INFINITY), !equals, Double.POSITIVE_INFINITY, true, Double.NaN);
        return this.estimateFilterRange(inputStatistics, expressionStatistics, expressionVariable, filterRange);
    }

    private PlanNodeStatsEstimate estimateFilterRange(PlanNodeStatsEstimate inputStatistics, VariableStatsEstimate expressionStatistics, Optional<VariableReferenceExpression> expressionVariable, StatisticRange filterRange) {
        double filterFactor = this.calculateFilterFactor(expressionStatistics, filterRange);
        StatisticRange expressionRange = StatisticRange.from(expressionStatistics);
        StatisticRange intersectRange = expressionRange.intersect(filterRange);
        PlanNodeStatsEstimate estimate = inputStatistics.mapOutputRowCount(rowCount -> filterFactor * (1.0 - expressionStatistics.getNullsFraction()) * rowCount);
        if (expressionVariable.isPresent()) {
            VariableStatsEstimate.Builder symbolNewEstimate = VariableStatsEstimate.builder().setAverageRowSize(expressionStatistics.getAverageRowSize()).setStatisticsRange(intersectRange).setNullsFraction(0.0);
            if (this.useHistograms) {
                symbolNewEstimate.setHistogram(expressionStatistics.getHistogram().map(expressionHistogram -> DisjointRangeDomainHistogram.addConjunction(expressionHistogram, intersectRange)));
            }
            estimate = estimate.mapVariableColumnStatistics(expressionVariable.get(), oldStats -> symbolNewEstimate.build());
        }
        return estimate;
    }

    private double calculateFilterFactor(VariableStatsEstimate variableStatistics, StatisticRange filterRange) {
        Estimate filterEstimate;
        StatisticRange variableRange = StatisticRange.from(variableStatistics);
        StatisticRange intersectRange = variableRange.intersect(filterRange);
        if (this.useHistograms) {
            double expressionFilter;
            Estimate distinctEstimate = Double.isNaN(variableStatistics.getDistinctValuesCount()) ? Estimate.unknown() : Estimate.of((double)variableRange.getDistinctValuesCount());
            filterEstimate = HistogramCalculator.calculateFilterFactor(intersectRange, variableStatistics.getHistogram().orElse(new UniformDistributionHistogram(variableStatistics.getLowValue(), variableStatistics.getHighValue())), distinctEstimate, true);
            if (log.isDebugEnabled() && !Double.isNaN(expressionFilter = variableRange.overlapPercentWith(intersectRange)) && !filterEstimate.fuzzyEquals(Estimate.of((double)expressionFilter), 1.0E-4)) {
                log.debug(String.format("histogram-calculated filter factor differs from the uniformity assumption:expression range: %s%nintersect range: %s%noverlapPercent: %s%nhistogram: %s%nhistogramFilterIntersect: %s%n", variableRange, intersectRange, expressionFilter, variableStatistics.getHistogram(), filterEstimate));
            }
        } else {
            filterEstimate = Estimate.estimateFromDouble((double)variableRange.overlapPercentWith(intersectRange));
        }
        return filterEstimate.orElse(() -> 0.9);
    }

    public PlanNodeStatsEstimate estimateExpressionToExpressionComparison(PlanNodeStatsEstimate inputStatistics, VariableStatsEstimate leftExpressionStatistics, Optional<VariableReferenceExpression> leftExpressionVariable, VariableStatsEstimate rightExpressionStatistics, Optional<VariableReferenceExpression> rightExpressionVariable, ComparisonExpression.Operator operator) {
        switch (operator) {
            case EQUAL: {
                return this.estimateExpressionEqualToExpression(inputStatistics, leftExpressionStatistics, leftExpressionVariable, rightExpressionStatistics, rightExpressionVariable);
            }
            case NOT_EQUAL: {
                return this.estimateExpressionNotEqualToExpression(inputStatistics, leftExpressionStatistics, leftExpressionVariable, rightExpressionStatistics, rightExpressionVariable);
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case IS_DISTINCT_FROM: {
                return PlanNodeStatsEstimate.unknown();
            }
        }
        throw new IllegalArgumentException("Unexpected comparison operator: " + operator);
    }

    private PlanNodeStatsEstimate estimateExpressionEqualToExpression(PlanNodeStatsEstimate inputStatistics, VariableStatsEstimate leftExpressionStatistics, Optional<VariableReferenceExpression> leftExpressionVariable, VariableStatsEstimate rightExpressionStatistics, Optional<VariableReferenceExpression> rightExpressionVariable) {
        if (Double.isNaN(leftExpressionStatistics.getDistinctValuesCount()) || Double.isNaN(rightExpressionStatistics.getDistinctValuesCount())) {
            return PlanNodeStatsEstimate.unknown();
        }
        StatisticRange leftExpressionRange = StatisticRange.from(leftExpressionStatistics);
        StatisticRange rightExpressionRange = StatisticRange.from(rightExpressionStatistics);
        StatisticRange intersect = leftExpressionRange.intersect(rightExpressionRange);
        double nullsFilterFactor = (1.0 - leftExpressionStatistics.getNullsFraction()) * (1.0 - rightExpressionStatistics.getNullsFraction());
        double leftNdv = leftExpressionRange.getDistinctValuesCount();
        double rightNdv = rightExpressionRange.getDistinctValuesCount();
        double filterFactor = 1.0 / MoreMath.max(leftNdv, rightNdv, 1.0);
        double retainedNdv = MoreMath.min(leftNdv, rightNdv);
        PlanNodeStatsEstimate.Builder estimate = PlanNodeStatsEstimate.buildFrom(inputStatistics).setOutputRowCount(inputStatistics.getOutputRowCount() * nullsFilterFactor * filterFactor);
        VariableStatsEstimate equalityStats = VariableStatsEstimate.builder().setAverageRowSize(ComparisonStatsCalculator.averageExcludingNaNs(leftExpressionStatistics.getAverageRowSize(), rightExpressionStatistics.getAverageRowSize())).setNullsFraction(0.0).setStatisticsRange(intersect).setDistinctValuesCount(retainedNdv).build();
        leftExpressionVariable.ifPresent(variable -> estimate.addVariableStatistics((VariableReferenceExpression)variable, equalityStats));
        rightExpressionVariable.ifPresent(variable -> estimate.addVariableStatistics((VariableReferenceExpression)variable, equalityStats));
        return estimate.build();
    }

    private PlanNodeStatsEstimate estimateExpressionNotEqualToExpression(PlanNodeStatsEstimate inputStatistics, VariableStatsEstimate leftExpressionStatistics, Optional<VariableReferenceExpression> leftExpressionVariable, VariableStatsEstimate rightExpressionStatistics, Optional<VariableReferenceExpression> rightExpressionVariable) {
        VariableStatsEstimate rightNullsFiltered;
        VariableStatsEstimate leftNullsFiltered;
        double nullsFilterFactor = (1.0 - leftExpressionStatistics.getNullsFraction()) * (1.0 - rightExpressionStatistics.getNullsFraction());
        PlanNodeStatsEstimate inputNullsFiltered = inputStatistics.mapOutputRowCount(size -> size * nullsFilterFactor);
        PlanNodeStatsEstimate equalityStats = this.estimateExpressionEqualToExpression(inputNullsFiltered, leftNullsFiltered = leftExpressionStatistics.mapNullsFraction(nullsFraction -> 0.0), leftExpressionVariable, rightNullsFiltered = rightExpressionStatistics.mapNullsFraction(nullsFraction -> 0.0), rightExpressionVariable);
        if (equalityStats.isOutputRowCountUnknown()) {
            return PlanNodeStatsEstimate.unknown();
        }
        PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.buildFrom(inputNullsFiltered);
        double equalityFilterFactor = equalityStats.getOutputRowCount() / inputNullsFiltered.getOutputRowCount();
        if (!Double.isFinite(equalityFilterFactor)) {
            equalityFilterFactor = 0.0;
        }
        result.setOutputRowCount(inputNullsFiltered.getOutputRowCount() * (1.0 - equalityFilterFactor));
        leftExpressionVariable.ifPresent(symbol -> result.addVariableStatistics((VariableReferenceExpression)symbol, leftNullsFiltered));
        rightExpressionVariable.ifPresent(symbol -> result.addVariableStatistics((VariableReferenceExpression)symbol, rightNullsFiltered));
        return result.build();
    }

    private static double averageExcludingNaNs(double first, double second) {
        if (Double.isNaN(first) && Double.isNaN(second)) {
            return Double.NaN;
        }
        if (!Double.isNaN(first) && !Double.isNaN(second)) {
            return (first + second) / 2.0;
        }
        return MoreMath.firstNonNaN(first, second);
    }
}

