/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.facebook.presto.spi.statistics.Estimate;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Objects;

public class UniformDistributionHistogram
implements ConnectorHistogram {
    private final double lowValue;
    private final double highValue;

    @JsonCreator
    public UniformDistributionHistogram(@JsonProperty(value="lowValue") double lowValue, @JsonProperty(value="highValue") double highValue) {
        Verify.verify((Double.isNaN(lowValue) || Double.isNaN(highValue) || lowValue <= highValue ? 1 : 0) != 0, (String)"lowValue must be <= highValue", (Object[])new Object[0]);
        this.lowValue = lowValue;
        this.highValue = highValue;
    }

    @JsonProperty
    public double getLowValue() {
        return this.lowValue;
    }

    @JsonProperty
    public double getHighValue() {
        return this.highValue;
    }

    public Estimate cumulativeProbability(double value, boolean inclusive) {
        if (Double.isNaN(this.lowValue) || Double.isNaN(this.highValue) || Double.isNaN(value)) {
            return Estimate.unknown();
        }
        if (value >= this.highValue) {
            return Estimate.of((double)1.0);
        }
        if (value <= this.lowValue) {
            return Estimate.of((double)0.0);
        }
        if (Double.isInfinite(this.lowValue) || Double.isInfinite(this.highValue)) {
            return Estimate.unknown();
        }
        return Estimate.of((double)Math.min(1.0, Math.max(0.0, (value - this.lowValue) / (this.highValue - this.lowValue))));
    }

    public Estimate inverseCumulativeProbability(double percentile) {
        Preconditions.checkArgument((percentile >= 0.0 && percentile <= 1.0 ? 1 : 0) != 0, (Object)("percentile must be in [0.0, 1.0]: " + percentile));
        if (Double.isNaN(this.lowValue) || Double.isNaN(this.highValue)) {
            return Estimate.unknown();
        }
        if (percentile == 0.0 && !Double.isInfinite(this.lowValue)) {
            return Estimate.of((double)this.lowValue);
        }
        if (percentile == 1.0 && !Double.isInfinite(this.highValue)) {
            return Estimate.of((double)this.highValue);
        }
        if (Double.isInfinite(this.lowValue) || Double.isInfinite(this.highValue)) {
            return Estimate.unknown();
        }
        return Estimate.of((double)(this.lowValue + percentile * (this.highValue - this.lowValue)));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lowValue", this.lowValue).add("highValue", this.highValue).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UniformDistributionHistogram)) {
            return false;
        }
        UniformDistributionHistogram other = (UniformDistributionHistogram)o;
        return UniformDistributionHistogram.equalsOrBothNaN(this.lowValue, other.lowValue) && UniformDistributionHistogram.equalsOrBothNaN(this.highValue, other.highValue);
    }

    public int hashCode() {
        return Objects.hash(this.lowValue, this.highValue);
    }

    private static boolean equalsOrBothNaN(Double first, Double second) {
        return first.equals(second) || Double.isNaN(first) && Double.isNaN(second);
    }
}

