/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.presto.dispatcher.CoordinatorLocation;
import com.facebook.presto.execution.ExecutionFailureInfo;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;

public class DispatchInfo {
    private final Optional<CoordinatorLocation> coordinatorLocation;
    private final Optional<ExecutionFailureInfo> failureInfo;
    private final Duration elapsedTime;
    private final Duration waitingForPrerequisitesTime;
    private final Optional<Duration> queuedTime;

    public static DispatchInfo waitingForPrerequisites(Duration elapsedTime, Duration waitingForPrerequisitesTime) {
        return new DispatchInfo(Optional.empty(), Optional.empty(), elapsedTime, waitingForPrerequisitesTime, Optional.empty());
    }

    public static DispatchInfo queued(Duration elapsedTime, Duration waitingForPrerequisitesTime, Duration queuedTime) {
        Objects.requireNonNull(queuedTime, "queuedTime is null");
        return new DispatchInfo(Optional.empty(), Optional.empty(), elapsedTime, waitingForPrerequisitesTime, Optional.of(queuedTime));
    }

    public static DispatchInfo dispatched(CoordinatorLocation coordinatorLocation, Duration elapsedTime, Duration waitingForPrerequisitesTime, Duration queuedTime) {
        Objects.requireNonNull(coordinatorLocation, "coordinatorLocation is null");
        Objects.requireNonNull(queuedTime, "queuedTime is null");
        return new DispatchInfo(Optional.of(coordinatorLocation), Optional.empty(), elapsedTime, waitingForPrerequisitesTime, Optional.of(queuedTime));
    }

    public static DispatchInfo failed(ExecutionFailureInfo failureInfo, Duration elapsedTime, Duration waitingForPrerequisitesTime, Duration queuedTime) {
        Objects.requireNonNull(failureInfo, "coordinatorLocation is null");
        Objects.requireNonNull(queuedTime, "queuedTime is null");
        return new DispatchInfo(Optional.empty(), Optional.of(failureInfo), elapsedTime, waitingForPrerequisitesTime, Optional.of(queuedTime));
    }

    private DispatchInfo(Optional<CoordinatorLocation> coordinatorLocation, Optional<ExecutionFailureInfo> failureInfo, Duration elapsedTime, Duration waitingForPrerequisitesTime, Optional<Duration> queuedTime) {
        this.coordinatorLocation = Objects.requireNonNull(coordinatorLocation, "coordinatorLocation is null");
        this.failureInfo = Objects.requireNonNull(failureInfo, "failureInfo is null");
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        this.waitingForPrerequisitesTime = Objects.requireNonNull(waitingForPrerequisitesTime, "waitingForPrerequisitesTime is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
    }

    public Optional<CoordinatorLocation> getCoordinatorLocation() {
        return this.coordinatorLocation;
    }

    public Optional<ExecutionFailureInfo> getFailureInfo() {
        return this.failureInfo;
    }

    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    public Duration getWaitingForPrerequisitesTime() {
        return this.waitingForPrerequisitesTime;
    }

    public Optional<Duration> getQueuedTime() {
        return this.queuedTime;
    }
}

