/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.SessionTransactionControlTask;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.utils.ParameterUtils;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.DropFunction;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class DropFunctionTask
implements SessionTransactionControlTask<DropFunction> {
    private final SqlParser sqlParser;

    @Inject
    public DropFunctionTask(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public String getName() {
        return "DROP FUNCTION";
    }

    @Override
    public String explain(DropFunction statement, List<Expression> parameters) {
        return String.format("DROP %sFUNCTION %s", statement.isTemporary() ? "TEMPORARY " : "", statement.getFunctionName());
    }

    @Override
    public ListenableFuture<?> execute(DropFunction statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Map parameterLookup = ParameterUtils.parameterExtractor((Statement)statement, parameters);
        Analyzer analyzer = new Analyzer(stateMachine.getSession(), metadata, this.sqlParser, accessControl, Optional.empty(), parameters, parameterLookup, stateMachine.getWarningCollector());
        analyzer.analyze((Statement)statement);
        Optional<List<TypeSignature>> parameterTypes = statement.getParameterTypes().map(types -> (ImmutableList)types.stream().map(TypeSignature::parseTypeSignature).collect(ImmutableList.toImmutableList()));
        if (statement.isTemporary()) {
            stateMachine.removeSessionFunction(new SqlFunctionId(QualifiedObjectName.valueOf((CatalogSchemaName)SessionFunctionHandle.SESSION_NAMESPACE, (String)statement.getFunctionName().getSuffix()), parameterTypes.orElse(Collections.emptyList())), statement.isExists());
        } else {
            metadata.getFunctionAndTypeManager().dropFunction(FunctionAndTypeManager.qualifyObjectName(statement.getFunctionName()), parameterTypes, statement.isExists());
        }
        return Futures.immediateFuture(null);
    }
}

