/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.common.ErrorType;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.Output;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.eventlistener.CTEInformation;
import com.facebook.presto.spi.eventlistener.PlanOptimizerInformation;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.prestospark.PrestoSparkExecutionContext;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.sql.planner.CanonicalPlanWithInfo;
import com.facebook.presto.util.QueryInfoUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class QueryInfo {
    private final QueryId queryId;
    private final SessionRepresentation session;
    private final QueryState state;
    private final MemoryPoolId memoryPool;
    private final boolean scheduled;
    private final URI self;
    private final List<String> fieldNames;
    private final String query;
    private final String queryHash;
    private final Optional<String> expandedQuery;
    private final Optional<String> preparedQuery;
    private final QueryStats queryStats;
    private final Optional<String> setCatalog;
    private final Optional<String> setSchema;
    private final Map<String, String> setSessionProperties;
    private final Set<String> resetSessionProperties;
    private final Map<String, SelectedRole> setRoles;
    private final Map<String, String> addedPreparedStatements;
    private final Set<String> deallocatedPreparedStatements;
    private final Optional<TransactionId> startedTransactionId;
    private final boolean clearTransactionId;
    private final String updateType;
    private final Optional<StageInfo> outputStage;
    private final ExecutionFailureInfo failureInfo;
    private final ErrorType errorType;
    private final ErrorCode errorCode;
    private final List<PrestoWarning> warnings;
    private final Set<Input> inputs;
    private final Optional<Output> output;
    private final boolean finalQueryInfo;
    private final Optional<ResourceGroupId> resourceGroupId;
    private final Optional<QueryType> queryType;
    private final Optional<List<TaskId>> failedTasks;
    private final Optional<List<StageId>> runtimeOptimizedStages;
    private final Map<SqlFunctionId, SqlInvokedFunction> addedSessionFunctions;
    private final Set<SqlFunctionId> removedSessionFunctions;
    private final StatsAndCosts planStatsAndCosts;
    private final List<PlanOptimizerInformation> optimizerInformation;
    private final List<CTEInformation> cteInformationList;
    private final Set<String> scalarFunctions;
    private final Set<String> aggregateFunctions;
    private final Set<String> windowsFunctions;
    private final List<CanonicalPlanWithInfo> planCanonicalInfo;
    private Map<PlanNodeId, PlanNode> planIdNodeMap;
    private final Optional<PrestoSparkExecutionContext> prestoSparkExecutionContext;

    @JsonCreator
    public QueryInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="session") SessionRepresentation session, @JsonProperty(value="state") QueryState state, @JsonProperty(value="memoryPool") MemoryPoolId memoryPool, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="self") URI self, @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="query") String query, @JsonProperty(value="expandedQuery") Optional<String> expandedQuery, @JsonProperty(value="preparedQuery") Optional<String> preparedQuery, @JsonProperty(value="queryStats") QueryStats queryStats, @JsonProperty(value="setCatalog") Optional<String> setCatalog, @JsonProperty(value="setSchema") Optional<String> setSchema, @JsonProperty(value="setSessionProperties") Map<String, String> setSessionProperties, @JsonProperty(value="resetSessionProperties") Set<String> resetSessionProperties, @JsonProperty(value="setRoles") Map<String, SelectedRole> setRoles, @JsonProperty(value="addedPreparedStatements") Map<String, String> addedPreparedStatements, @JsonProperty(value="deallocatedPreparedStatements") Set<String> deallocatedPreparedStatements, @JsonProperty(value="startedTransactionId") Optional<TransactionId> startedTransactionId, @JsonProperty(value="clearTransactionId") boolean clearTransactionId, @JsonProperty(value="updateType") String updateType, @JsonProperty(value="outputStage") Optional<StageInfo> outputStage, @JsonProperty(value="failureInfo") ExecutionFailureInfo failureInfo, @JsonProperty(value="errorCode") ErrorCode errorCode, @JsonProperty(value="warnings") List<PrestoWarning> warnings, @JsonProperty(value="inputs") Set<Input> inputs, @JsonProperty(value="output") Optional<Output> output, @JsonProperty(value="finalQueryInfo") boolean finalQueryInfo, @JsonProperty(value="resourceGroupId") Optional<ResourceGroupId> resourceGroupId, @JsonProperty(value="queryType") Optional<QueryType> queryType, @JsonProperty(value="failedTasks") Optional<List<TaskId>> failedTasks, @JsonProperty(value="runtimeOptimizedStages") Optional<List<StageId>> runtimeOptimizedStages, @JsonProperty(value="addedSessionFunctions") Map<SqlFunctionId, SqlInvokedFunction> addedSessionFunctions, @JsonProperty(value="removedSessionFunctions") Set<SqlFunctionId> removedSessionFunctions, @JsonProperty(value="planStatsAndCosts") StatsAndCosts planStatsAndCosts, @JsonProperty(value="optimizerInformation") List<PlanOptimizerInformation> optimizerInformation, @JsonProperty(value="cteInformation") List<CTEInformation> cteInformationList, @JsonProperty(value="scalarFunctions") Set<String> scalarFunctions, @JsonProperty(value="aggregateFunctions") Set<String> aggregateFunctions, @JsonProperty(value="windowsFunctions") Set<String> windowsFunctions, List<CanonicalPlanWithInfo> planCanonicalInfo, Map<PlanNodeId, PlanNode> planIdNodeMap, @JsonProperty(value="prestoSparkExecutionContext") Optional<PrestoSparkExecutionContext> prestoSparkExecutionContext) {
        Objects.requireNonNull(queryId, "queryId is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(state, "state is null");
        Objects.requireNonNull(self, "self is null");
        Objects.requireNonNull(fieldNames, "fieldNames is null");
        Objects.requireNonNull(queryStats, "queryStats is null");
        Objects.requireNonNull(setCatalog, "setCatalog is null");
        Objects.requireNonNull(setSchema, "setSchema is null");
        Objects.requireNonNull(setSessionProperties, "setSessionProperties is null");
        Objects.requireNonNull(resetSessionProperties, "resetSessionProperties is null");
        Objects.requireNonNull(addedPreparedStatements, "addedPreparedStatements is null");
        Objects.requireNonNull(deallocatedPreparedStatements, "deallocatedPreparedStatements is null");
        Objects.requireNonNull(startedTransactionId, "startedTransactionId is null");
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(expandedQuery, "expandedQuery is null");
        Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        Objects.requireNonNull(outputStage, "outputStage is null");
        Objects.requireNonNull(inputs, "inputs is null");
        Objects.requireNonNull(output, "output is null");
        Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        Objects.requireNonNull(warnings, "warnings is null");
        Objects.requireNonNull(queryType, "queryType is null");
        Objects.requireNonNull(failedTasks, "failedTasks is null");
        Objects.requireNonNull(runtimeOptimizedStages, "runtimeOptimizedStages is null");
        Objects.requireNonNull(addedSessionFunctions, "addedSessionFunctions is null");
        Objects.requireNonNull(removedSessionFunctions, "removedSessionFunctions is null");
        Objects.requireNonNull(planStatsAndCosts, "planStatsAndCosts is null");
        Objects.requireNonNull(optimizerInformation, "optimizerInformation is null");
        Objects.requireNonNull(cteInformationList, "cteInformationList is null");
        Objects.requireNonNull(scalarFunctions, "scalarFunctions is null");
        Objects.requireNonNull(aggregateFunctions, "aggregateFunctions is null");
        Objects.requireNonNull(windowsFunctions, "windowsFunctions is null");
        Objects.requireNonNull(prestoSparkExecutionContext, "prestoSparkExecutionContext is null");
        this.queryId = queryId;
        this.session = session;
        this.state = state;
        this.memoryPool = Objects.requireNonNull(memoryPool, "memoryPool is null");
        this.scheduled = scheduled;
        this.self = self;
        this.fieldNames = ImmutableList.copyOf(fieldNames);
        this.query = query;
        this.queryHash = QueryInfoUtils.computeQueryHash(query);
        this.expandedQuery = expandedQuery;
        this.preparedQuery = preparedQuery;
        this.queryStats = queryStats;
        this.setCatalog = setCatalog;
        this.setSchema = setSchema;
        this.setSessionProperties = ImmutableMap.copyOf(setSessionProperties);
        this.resetSessionProperties = ImmutableSet.copyOf(resetSessionProperties);
        this.setRoles = ImmutableMap.copyOf(setRoles);
        this.addedPreparedStatements = ImmutableMap.copyOf(addedPreparedStatements);
        this.deallocatedPreparedStatements = ImmutableSet.copyOf(deallocatedPreparedStatements);
        this.startedTransactionId = startedTransactionId;
        this.clearTransactionId = clearTransactionId;
        this.updateType = updateType;
        this.outputStage = outputStage;
        this.failureInfo = failureInfo;
        this.errorType = errorCode == null ? null : errorCode.getType();
        this.errorCode = errorCode;
        this.warnings = ImmutableList.copyOf(warnings);
        this.inputs = ImmutableSet.copyOf(inputs);
        this.output = output;
        this.finalQueryInfo = finalQueryInfo;
        if (finalQueryInfo) {
            Preconditions.checkArgument((boolean)state.isDone(), (String)"finalQueryInfo without a terminal query state: %s", (Object)((Object)state));
        }
        this.resourceGroupId = resourceGroupId;
        this.queryType = queryType;
        this.failedTasks = failedTasks;
        this.runtimeOptimizedStages = runtimeOptimizedStages;
        this.addedSessionFunctions = ImmutableMap.copyOf(addedSessionFunctions);
        this.removedSessionFunctions = ImmutableSet.copyOf(removedSessionFunctions);
        this.planStatsAndCosts = planStatsAndCosts;
        this.optimizerInformation = optimizerInformation;
        this.cteInformationList = cteInformationList;
        this.scalarFunctions = scalarFunctions;
        this.aggregateFunctions = aggregateFunctions;
        this.windowsFunctions = windowsFunctions;
        this.planCanonicalInfo = planCanonicalInfo == null ? ImmutableList.of() : planCanonicalInfo;
        this.planIdNodeMap = planIdNodeMap == null ? ImmutableMap.of() : ImmutableMap.copyOf(planIdNodeMap);
        this.prestoSparkExecutionContext = prestoSparkExecutionContext;
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public SessionRepresentation getSession() {
        return this.session;
    }

    @JsonProperty
    public QueryState getState() {
        return this.state;
    }

    @JsonProperty
    public MemoryPoolId getMemoryPool() {
        return this.memoryPool;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public String getQueryHash() {
        return this.queryHash;
    }

    @JsonProperty
    public Optional<String> getExpandedQuery() {
        return this.expandedQuery;
    }

    @JsonProperty
    public Optional<String> getPreparedQuery() {
        return this.preparedQuery;
    }

    @JsonProperty
    public QueryStats getQueryStats() {
        return this.queryStats;
    }

    @JsonProperty
    public Optional<String> getSetCatalog() {
        return this.setCatalog;
    }

    @JsonProperty
    public Optional<String> getSetSchema() {
        return this.setSchema;
    }

    @JsonProperty
    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    @JsonProperty
    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    @JsonProperty
    public Map<String, SelectedRole> getSetRoles() {
        return this.setRoles;
    }

    @JsonProperty
    public Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    @JsonProperty
    public Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    @JsonProperty
    public Optional<TransactionId> getStartedTransactionId() {
        return this.startedTransactionId;
    }

    @JsonProperty
    public boolean isClearTransactionId() {
        return this.clearTransactionId;
    }

    @Nullable
    @JsonProperty
    public String getUpdateType() {
        return this.updateType;
    }

    @JsonProperty
    public Optional<StageInfo> getOutputStage() {
        return this.outputStage;
    }

    @Nullable
    @JsonProperty
    public ExecutionFailureInfo getFailureInfo() {
        return this.failureInfo;
    }

    @Nullable
    @JsonProperty
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty
    public List<PrestoWarning> getWarnings() {
        return this.warnings;
    }

    @JsonProperty
    public boolean isFinalQueryInfo() {
        return this.finalQueryInfo;
    }

    @JsonProperty
    public Set<Input> getInputs() {
        return this.inputs;
    }

    @JsonProperty
    public Optional<Output> getOutput() {
        return this.output;
    }

    @JsonProperty
    public Optional<ResourceGroupId> getResourceGroupId() {
        return this.resourceGroupId;
    }

    @JsonProperty
    public Optional<QueryType> getQueryType() {
        return this.queryType;
    }

    @JsonProperty
    public Optional<List<TaskId>> getFailedTasks() {
        return this.failedTasks;
    }

    @JsonProperty
    public Optional<List<StageId>> getRuntimeOptimizedStages() {
        return this.runtimeOptimizedStages;
    }

    @JsonProperty
    public Map<SqlFunctionId, SqlInvokedFunction> getAddedSessionFunctions() {
        return this.addedSessionFunctions;
    }

    @JsonProperty
    public Set<SqlFunctionId> getRemovedSessionFunctions() {
        return this.removedSessionFunctions;
    }

    @JsonProperty
    public StatsAndCosts getPlanStatsAndCosts() {
        return this.planStatsAndCosts;
    }

    @JsonProperty
    public List<PlanOptimizerInformation> getOptimizerInformation() {
        return this.optimizerInformation;
    }

    @JsonProperty
    public List<CTEInformation> getCteInformationList() {
        return this.cteInformationList;
    }

    @JsonProperty
    public Set<String> getScalarFunctions() {
        return this.scalarFunctions;
    }

    @JsonProperty
    public Set<String> getAggregateFunctions() {
        return this.aggregateFunctions;
    }

    @JsonProperty
    public Set<String> getWindowsFunctions() {
        return this.windowsFunctions;
    }

    @JsonProperty
    public Optional<PrestoSparkExecutionContext> getPrestoSparkExecutionContext() {
        return this.prestoSparkExecutionContext;
    }

    public List<CanonicalPlanWithInfo> getPlanCanonicalInfo() {
        return this.planCanonicalInfo;
    }

    public Map<PlanNodeId, PlanNode> getPlanIdNodeMap() {
        return this.planIdNodeMap;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("state", (Object)this.state).add("fieldNames", this.fieldNames).toString();
    }
}

