/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.buffer.BufferInfo;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.ClientBuffer;
import com.facebook.presto.execution.buffer.LifespanSerializedPageTracker;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.execution.buffer.OutputBufferMemoryManager;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.SerializedPageReference;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class PartitionedOutputBuffer
implements OutputBuffer {
    private final StateMachine<BufferState> state;
    private final OutputBuffers outputBuffers;
    private final OutputBufferMemoryManager memoryManager;
    private final LifespanSerializedPageTracker pageTracker;
    private final List<ClientBuffer> partitions;
    private final AtomicLong totalPagesAdded = new AtomicLong();
    private final AtomicLong totalRowsAdded = new AtomicLong();

    public PartitionedOutputBuffer(String taskInstanceId, StateMachine<BufferState> state, OutputBuffers outputBuffers, DataSize maxBufferSize, Supplier<LocalMemoryContext> systemMemoryContextSupplier, Executor notificationExecutor) {
        this.state = Objects.requireNonNull(state, "state is null");
        Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        Preconditions.checkArgument((outputBuffers.getType() == OutputBuffers.BufferType.PARTITIONED ? 1 : 0) != 0, (Object)"Expected a PARTITIONED output buffer descriptor");
        Preconditions.checkArgument((boolean)outputBuffers.isNoMoreBufferIds(), (Object)"Expected a final output buffer descriptor");
        this.outputBuffers = outputBuffers;
        this.memoryManager = new OutputBufferMemoryManager(Objects.requireNonNull(maxBufferSize, "maxBufferSize is null").toBytes(), Objects.requireNonNull(systemMemoryContextSupplier, "systemMemoryContextSupplier is null"), Objects.requireNonNull(notificationExecutor, "notificationExecutor is null"));
        this.pageTracker = new LifespanSerializedPageTracker(this.memoryManager);
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (OutputBuffers.OutputBufferId bufferId : outputBuffers.getBuffers().keySet()) {
            ClientBuffer partition = new ClientBuffer(taskInstanceId, bufferId, this.pageTracker);
            partitions.add((Object)partition);
        }
        this.partitions = partitions.build();
        state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_BUFFERS);
        state.compareAndSet(BufferState.NO_MORE_PAGES, BufferState.FLUSHING);
        this.checkFlushComplete();
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.state.addStateChangeListener(stateChangeListener);
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == BufferState.FINISHED;
    }

    @Override
    public double getUtilization() {
        return this.memoryManager.getUtilization();
    }

    @Override
    public boolean isOverutilized() {
        return this.memoryManager.isOverutilized();
    }

    @Override
    public OutputBufferInfo getInfo() {
        BufferState state = this.state.get();
        int totalBufferedPages = 0;
        ImmutableList.Builder infos = ImmutableList.builderWithExpectedSize((int)this.partitions.size());
        for (ClientBuffer partition : this.partitions) {
            BufferInfo bufferInfo = partition.getInfo();
            infos.add((Object)bufferInfo);
            totalBufferedPages = (int)((long)totalBufferedPages + bufferInfo.getPageBufferInfo().getBufferedPages());
        }
        return new OutputBufferInfo("PARTITIONED", state, state.canAddBuffers(), state.canAddPages(), this.memoryManager.getBufferedBytes(), totalBufferedPages, this.totalRowsAdded.get(), this.totalPagesAdded.get(), (List<BufferInfo>)infos.build());
    }

    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        Objects.requireNonNull(newOutputBuffers, "newOutputBuffers is null");
        if (this.state.get().isTerminal() || this.outputBuffers.getVersion() >= newOutputBuffers.getVersion()) {
            return;
        }
        this.outputBuffers.checkValidTransition(newOutputBuffers);
    }

    @Override
    public ListenableFuture<?> isFull() {
        return this.memoryManager.getBufferBlockedFuture();
    }

    @Override
    public void registerLifespanCompletionCallback(Consumer<Lifespan> callback) {
        this.pageTracker.registerLifespanCompletionCallback(callback);
    }

    @Override
    public void enqueue(Lifespan lifespan, List<SerializedPage> pages) {
        Preconditions.checkState((this.partitions.size() == 1 ? 1 : 0) != 0, (Object)"Expected exactly one partition");
        this.enqueue(lifespan, 0, pages);
    }

    @Override
    public void enqueue(Lifespan lifespan, int partitionNumber, List<SerializedPage> pages) {
        Objects.requireNonNull(lifespan, "lifespan is null");
        Objects.requireNonNull(pages, "pages is null");
        Preconditions.checkState((boolean)this.pageTracker.isLifespanCompletionCallbackRegistered(), (Object)"lifespanCompletionCallback must be set before enqueueing data");
        if (!this.state.get().canAddPages() || this.pageTracker.isNoMorePagesForLifespan(lifespan)) {
            return;
        }
        ImmutableList.Builder references = ImmutableList.builderWithExpectedSize((int)pages.size());
        long bytesAdded = 0L;
        long rowCount = 0L;
        for (SerializedPage page : pages) {
            long retainedSize = page.getRetainedSizeInBytes();
            bytesAdded += retainedSize;
            rowCount += (long)page.getPositionCount();
            references.add((Object)new SerializedPageReference(page, 1, lifespan));
        }
        ImmutableList serializedPageReferences = references.build();
        this.memoryManager.updateMemoryUsage(bytesAdded);
        this.totalRowsAdded.addAndGet(rowCount);
        this.totalPagesAdded.addAndGet(serializedPageReferences.size());
        this.pageTracker.incrementLifespanPageCount(lifespan, serializedPageReferences.size());
        this.partitions.get(partitionNumber).enqueuePages((Collection<SerializedPageReference>)serializedPageReferences);
        SerializedPageReference.dereferencePages((List<SerializedPageReference>)serializedPageReferences, this.pageTracker);
    }

    @Override
    public void setNoMorePagesForLifespan(Lifespan lifespan) {
        this.pageTracker.setNoMorePagesForLifespan(lifespan);
    }

    @Override
    public boolean isFinishedForLifespan(Lifespan lifespan) {
        return this.pageTracker.isFinishedForLifespan(lifespan);
    }

    @Override
    public ListenableFuture<BufferResult> get(OutputBuffers.OutputBufferId outputBufferId, long startingSequenceId, DataSize maxSize) {
        Objects.requireNonNull(outputBufferId, "outputBufferId is null");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        return this.partitions.get(outputBufferId.getId()).getPages(startingSequenceId, maxSize);
    }

    @Override
    public void acknowledge(OutputBuffers.OutputBufferId outputBufferId, long sequenceId) {
        Objects.requireNonNull(outputBufferId, "bufferId is null");
        this.partitions.get(outputBufferId.getId()).acknowledgePages(sequenceId);
    }

    @Override
    public void abort(OutputBuffers.OutputBufferId bufferId) {
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.partitions.get(bufferId.getId()).destroy();
        this.checkFlushComplete();
    }

    @Override
    public void setNoMorePages() {
        this.state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_PAGES);
        this.state.compareAndSet(BufferState.NO_MORE_BUFFERS, BufferState.FLUSHING);
        this.memoryManager.setNoBlockOnFull();
        this.partitions.forEach(ClientBuffer::setNoMorePages);
        this.checkFlushComplete();
    }

    @Override
    public void destroy() {
        if (this.state.setIf(BufferState.FINISHED, oldState -> !oldState.isTerminal())) {
            this.partitions.forEach(ClientBuffer::destroy);
            this.memoryManager.setNoBlockOnFull();
            this.forceFreeMemory();
        }
    }

    @Override
    public void fail() {
        if (this.state.setIf(BufferState.FAILED, oldState -> !oldState.isTerminal())) {
            this.memoryManager.setNoBlockOnFull();
            this.forceFreeMemory();
        }
    }

    @Override
    public long getPeakMemoryUsage() {
        return this.memoryManager.getPeakMemoryUsage();
    }

    @VisibleForTesting
    void forceFreeMemory() {
        this.memoryManager.close();
    }

    private void checkFlushComplete() {
        if (this.state.get() != BufferState.FLUSHING && this.state.get() != BufferState.NO_MORE_BUFFERS) {
            return;
        }
        if (this.partitions.stream().allMatch(ClientBuffer::isDestroyed)) {
            this.destroy();
        }
    }

    @VisibleForTesting
    OutputBufferMemoryManager getMemoryManager() {
        return this.memoryManager;
    }
}

