/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.ThriftSerializedPage;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ThriftStruct
public class ThriftBufferResult {
    private final String taskInstanceId;
    private final long token;
    private final long nextToken;
    private final boolean bufferComplete;
    private final long bufferedBytes;
    private final List<ThriftSerializedPage> thriftSerializedPages;

    public static ThriftBufferResult fromBufferResult(BufferResult bufferResult) {
        Objects.requireNonNull(bufferResult, "bufferResult is null");
        List<ThriftSerializedPage> thriftSerializedPages = bufferResult.getSerializedPages().stream().map(ThriftSerializedPage::new).collect(Collectors.toList());
        return new ThriftBufferResult(bufferResult.getTaskInstanceId(), bufferResult.getToken(), bufferResult.getNextToken(), bufferResult.isBufferComplete(), bufferResult.getBufferedBytes(), thriftSerializedPages);
    }

    @ThriftConstructor
    public ThriftBufferResult(String taskInstanceId, long token, long nextToken, boolean bufferComplete, long bufferedBytes, List<ThriftSerializedPage> thriftSerializedPages) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)taskInstanceId) ? 1 : 0) != 0, (Object)"taskInstanceId is null");
        this.taskInstanceId = taskInstanceId;
        this.token = token;
        this.nextToken = nextToken;
        this.bufferComplete = bufferComplete;
        this.bufferedBytes = bufferedBytes;
        this.thriftSerializedPages = ImmutableList.copyOf((Collection)Objects.requireNonNull(thriftSerializedPages, "thriftSerializedPages is null"));
    }

    @ThriftField(value=1)
    public String getTaskInstanceId() {
        return this.taskInstanceId;
    }

    @ThriftField(value=2)
    public long getToken() {
        return this.token;
    }

    @ThriftField(value=3)
    public long getNextToken() {
        return this.nextToken;
    }

    @ThriftField(value=4)
    public boolean isBufferComplete() {
        return this.bufferComplete;
    }

    @ThriftField(value=5)
    public List<ThriftSerializedPage> getThriftSerializedPages() {
        return this.thriftSerializedPages;
    }

    @ThriftField(value=6)
    public long getBufferedBytes() {
        return this.bufferedBytes;
    }

    public List<SerializedPage> getSerializedPages() {
        return this.thriftSerializedPages.stream().map(ThriftSerializedPage::toSerializedPage).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftBufferResult that = (ThriftBufferResult)o;
        return Objects.equals(this.token, that.token) && Objects.equals(this.nextToken, that.nextToken) && Objects.equals(this.taskInstanceId, that.taskInstanceId) && Objects.equals(this.bufferComplete, that.bufferComplete) && Objects.equals(this.thriftSerializedPages, that.thriftSerializedPages);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.nextToken, this.taskInstanceId, this.bufferComplete, this.thriftSerializedPages);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("token", this.token).add("nextToken", this.nextToken).add("taskInstanceId", (Object)this.taskInstanceId).add("bufferComplete", this.bufferComplete).add("bufferedBytes", this.bufferedBytes).add("thriftSerializedPages", this.thriftSerializedPages).toString();
    }

    @VisibleForTesting
    public BufferResult toBufferResult() {
        return new BufferResult(this.taskInstanceId, this.token, this.nextToken, this.bufferComplete, this.bufferedBytes, this.getSerializedPages());
    }
}

