/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DynamicFilterSourceOperator
implements Operator {
    private static final int EXPECTED_BLOCK_BUILDER_SIZE = 8;
    private final OperatorContext context;
    private final Consumer<TupleDomain<String>> dynamicPredicateConsumer;
    private final int maxFilterPositionsCount;
    private final long maxFilterSizeInBytes;
    private final List<Channel> channels;
    private final List<Integer> minMaxChannels;
    private final boolean useNewNanDefinition;
    private boolean finished;
    private Page current;
    @Nullable
    private BlockBuilder[] blockBuilders;
    @Nullable
    private TypedSet[] valueSets;
    private int minMaxCollectionLimit;
    @Nullable
    private Block[] minValues;
    @Nullable
    private Block[] maxValues;

    private DynamicFilterSourceOperator(OperatorContext context, Consumer<TupleDomain<String>> dynamicPredicateConsumer, List<Channel> channels, PlanNodeId planNodeId, int maxFilterPositionsCount, DataSize maxFilterSize, int minMaxCollectionLimit, boolean useNewNanDefinition) {
        this.context = Objects.requireNonNull(context, "context is null");
        this.maxFilterPositionsCount = maxFilterPositionsCount;
        this.maxFilterSizeInBytes = maxFilterSize.toBytes();
        this.dynamicPredicateConsumer = Objects.requireNonNull(dynamicPredicateConsumer, "dynamicPredicateConsumer is null");
        this.channels = Objects.requireNonNull(channels, "channels is null");
        this.blockBuilders = new BlockBuilder[channels.size()];
        this.valueSets = new TypedSet[channels.size()];
        ImmutableList.Builder minMaxChannelsBuilder = ImmutableList.builder();
        for (int channelIndex = 0; channelIndex < channels.size(); ++channelIndex) {
            Type type = channels.get(channelIndex).getType();
            if (minMaxCollectionLimit > 0 && type.isOrderable() && !type.equals(DoubleType.DOUBLE) && !type.equals(RealType.REAL)) {
                minMaxChannelsBuilder.add((Object)channelIndex);
            }
            this.blockBuilders[channelIndex] = type.createBlockBuilder(null, 8);
            this.valueSets[channelIndex] = new TypedSet(type, this.blockBuilders[channelIndex], 8, String.format("DynamicFilterSourceOperator_%s_%d", planNodeId, channelIndex), Optional.empty());
        }
        this.minMaxCollectionLimit = minMaxCollectionLimit;
        this.minMaxChannels = minMaxChannelsBuilder.build();
        if (!this.minMaxChannels.isEmpty()) {
            this.minValues = new Block[channels.size()];
            this.maxValues = new Block[channels.size()];
        }
        this.useNewNanDefinition = useNewNanDefinition;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.context;
    }

    @Override
    public boolean needsInput() {
        return this.current == null && !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Verify.verify((!this.finished ? 1 : 0) != 0, (String)"DynamicFilterSourceOperator: addInput() shouldn't not be called after finish()", (Object[])new Object[0]);
        this.current = page;
        if (this.valueSets == null) {
            if (this.minValues == null) {
                return;
            }
            this.minMaxCollectionLimit -= page.getPositionCount();
            if (this.minMaxCollectionLimit < 0) {
                this.handleMinMaxCollectionLimitExceeded();
                return;
            }
            for (Integer channelIndex : this.minMaxChannels) {
                Block block = page.getBlock(this.channels.get(channelIndex).index);
                this.updateMinMaxValues(block, channelIndex);
            }
            return;
        }
        this.minMaxCollectionLimit -= page.getPositionCount();
        long filterSizeInBytes = 0L;
        int filterPositionsCount = 0;
        for (int channelIndex = 0; channelIndex < this.channels.size(); ++channelIndex) {
            Block block = page.getBlock(this.channels.get(channelIndex).getIndex());
            TypedSet valueSet = this.valueSets[channelIndex];
            for (int position = 0; position < block.getPositionCount(); ++position) {
                valueSet.add(block, position);
            }
            filterSizeInBytes += valueSet.getRetainedSizeInBytes();
            filterPositionsCount += valueSet.size();
        }
        if (filterPositionsCount > this.maxFilterPositionsCount || filterSizeInBytes > this.maxFilterSizeInBytes) {
            this.handleTooLargePredicate();
        }
    }

    private void handleTooLargePredicate() {
        if (this.minMaxChannels.isEmpty()) {
            this.dynamicPredicateConsumer.accept((TupleDomain<String>)TupleDomain.all());
        } else if (this.minMaxCollectionLimit < 0) {
            this.handleMinMaxCollectionLimitExceeded();
        } else {
            for (Integer channelIndex : this.minMaxChannels) {
                Block block = this.blockBuilders[channelIndex].build();
                this.updateMinMaxValues(block, channelIndex);
            }
        }
        this.valueSets = null;
        this.blockBuilders = null;
    }

    private void handleMinMaxCollectionLimitExceeded() {
        this.dynamicPredicateConsumer.accept((TupleDomain<String>)TupleDomain.all());
        this.minValues = null;
        this.maxValues = null;
    }

    private void updateMinMaxValues(Block block, int channelIndex) {
        Preconditions.checkState((this.minValues != null && this.maxValues != null ? 1 : 0) != 0);
        Type type = this.channels.get(channelIndex).type;
        int minValuePosition = -1;
        int maxValuePosition = -1;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            if (minValuePosition == -1) {
                minValuePosition = position;
                maxValuePosition = position;
                continue;
            }
            if (type.compareTo(block, position, block, minValuePosition) < 0) {
                minValuePosition = position;
                continue;
            }
            if (type.compareTo(block, position, block, maxValuePosition) <= 0) continue;
            maxValuePosition = position;
        }
        if (minValuePosition == -1) {
            return;
        }
        if (this.minValues[channelIndex] == null) {
            this.minValues[channelIndex] = block.getSingleValueBlock(minValuePosition);
            this.maxValues[channelIndex] = block.getSingleValueBlock(maxValuePosition);
            return;
        }
        Block currentMin = this.minValues[channelIndex];
        Block currentMax = this.maxValues[channelIndex];
        if (type.compareTo(block, minValuePosition, currentMin, 0) < 0) {
            this.minValues[channelIndex] = block.getSingleValueBlock(minValuePosition);
        }
        if (type.compareTo(block, maxValuePosition, currentMax, 0) > 0) {
            this.maxValues[channelIndex] = block.getSingleValueBlock(maxValuePosition);
        }
    }

    @Override
    public Page getOutput() {
        Page result = this.current;
        this.current = null;
        return result;
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        ImmutableMap.Builder domainsBuilder = ImmutableMap.builder();
        if (this.valueSets == null) {
            if (this.minValues == null) {
                return;
            }
            for (Integer channelIndex : this.minMaxChannels) {
                Type type = this.channels.get(channelIndex).type;
                if (this.minValues[channelIndex] == null) {
                    domainsBuilder.put((Object)this.channels.get(channelIndex).filterId, (Object)Domain.none((Type)type));
                    continue;
                }
                Object min = TypeUtils.readNativeValue((Type)type, (Block)this.minValues[channelIndex], (int)0);
                Object max = TypeUtils.readNativeValue((Type)type, (Block)this.maxValues[channelIndex], (int)0);
                Domain domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true), (Range[])new Range[0]), (boolean)false);
                domainsBuilder.put((Object)this.channels.get(channelIndex).filterId, (Object)domain);
            }
            this.minValues = null;
            this.maxValues = null;
            this.dynamicPredicateConsumer.accept((TupleDomain<String>)TupleDomain.withColumnDomains((Map)domainsBuilder.build()));
            return;
        }
        Verify.verify((this.blockBuilders != null ? 1 : 0) != 0, (String)"blockBuilders is null when finish is called in DynamicFilterSourceOperator", (Object[])new Object[0]);
        for (int channelIndex = 0; channelIndex < this.channels.size(); ++channelIndex) {
            Block block = this.blockBuilders[channelIndex].build();
            Type type = this.channels.get(channelIndex).getType();
            domainsBuilder.put((Object)this.channels.get(channelIndex).getFilterId(), (Object)this.convertToDomain(type, block));
        }
        this.valueSets = null;
        this.blockBuilders = null;
        this.dynamicPredicateConsumer.accept((TupleDomain<String>)TupleDomain.withColumnDomains((Map)domainsBuilder.build()));
    }

    private Domain convertToDomain(Type type, Block block) {
        ImmutableList.Builder values = ImmutableList.builder();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            Object value = TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
            if (value == null || TypeUtils.isFloatingPointNaN((Type)type, (Object)value) && !this.useNewNanDefinition) continue;
            values.add(value);
        }
        return Domain.create((ValueSet)ValueSet.copyOf((Type)type, (Collection)values.build()), (boolean)false);
    }

    @Override
    public boolean isFinished() {
        return this.current == null && this.finished;
    }

    public static class DynamicFilterSourceOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Consumer<TupleDomain<String>> dynamicPredicateConsumer;
        private final List<Channel> channels;
        private final int maxFilterPositionsCount;
        private final DataSize maxFilterSize;
        private final int minMaxCollectionLimit;
        private final boolean useNewNanDefinition;
        private boolean closed;

        public DynamicFilterSourceOperatorFactory(int operatorId, PlanNodeId planNodeId, Consumer<TupleDomain<String>> dynamicPredicateConsumer, List<Channel> channels, int maxFilterPositionsCount, DataSize maxFilterSize, int minMaxCollectionLimit, boolean useNewNanDefinition) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.dynamicPredicateConsumer = Objects.requireNonNull(dynamicPredicateConsumer, "dynamicPredicateConsumer is null");
            this.channels = Objects.requireNonNull(channels, "channels is null");
            Verify.verify((channels.stream().map(channel -> channel.getFilterId()).collect(Collectors.toSet()).size() == channels.size() ? 1 : 0) != 0, (String)"duplicate dynamic filters are not allowed", (Object[])new Object[0]);
            Verify.verify((channels.stream().map(channel -> channel.getIndex()).collect(Collectors.toSet()).size() == channels.size() ? 1 : 0) != 0, (String)"duplicate channel indices are not allowed", (Object[])new Object[0]);
            this.maxFilterPositionsCount = maxFilterPositionsCount;
            this.maxFilterSize = maxFilterSize;
            this.minMaxCollectionLimit = minMaxCollectionLimit;
            this.useNewNanDefinition = useNewNanDefinition;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new DynamicFilterSourceOperator(driverContext.addOperatorContext(this.operatorId, this.planNodeId, DynamicFilterSourceOperator.class.getSimpleName()), this.dynamicPredicateConsumer, this.channels, this.planNodeId, this.maxFilterPositionsCount, this.maxFilterSize, this.minMaxCollectionLimit, this.useNewNanDefinition);
        }

        @Override
        public void noMoreOperators() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("duplicate() is not supported for DynamicFilterSourceOperatorFactory");
        }
    }

    public static class Channel {
        private final String filterId;
        private final Type type;
        private final int index;

        public Channel(String filterId, Type type, int index) {
            this.filterId = Objects.requireNonNull(filterId, "filterId is null");
            this.type = Objects.requireNonNull(type, "type is null");
            this.index = index;
        }

        public String getFilterId() {
            return this.filterId;
        }

        public Type getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

